/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils.helper;

import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.utils.helper.ParticleHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020!H\u0002J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0003H&J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u0003H&J\u000e\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010,H&J\u0018\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020!H$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcn/coostack/cooparticlesapi/utils/helper/ProgressSequencedHelper;", "Lcn/coostack/cooparticlesapi/utils/helper/ParticleHelper;", "maxCount", "", "progressMaxTick", "<init>", "(II)V", "getMaxCount", "()I", "setMaxCount", "(I)V", "getProgressMaxTick", "setProgressMaxTick", "value", "current", "getCurrent", "setCurrent", "step", "", "getStep", "()D", "setStep", "(D)V", "remainder", "recalculateStep", "setProgress", "", "percent", "increaseProgress", "decreaseProgress", "doProgressTo", "targetTick", "over", "", "isZero", "calculateActualStep", "isAdding", "calculateTotalStep", "from", "to", "addMultiple", "count", "removeMultiple", "getLoadedStyle", "Lcn/coostack/cooparticlesapi/particles/Controlable;", "changeStatusBatch", "indexes", "", "status", "cooparticlesapi-fabric-1.21.1"})
@SourceDebugExtension(value={"SMAP\nProgressSequencedHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressSequencedHelper.kt\ncn/coostack/cooparticlesapi/utils/helper/ProgressSequencedHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public abstract class ProgressSequencedHelper
implements ParticleHelper {
    private int maxCount;
    private int progressMaxTick;
    private int current;
    private double step;
    private double remainder;

    public ProgressSequencedHelper(int maxCount, int progressMaxTick) {
        this.maxCount = maxCount;
        this.progressMaxTick = progressMaxTick;
        this.step = (double)this.maxCount / (double)this.progressMaxTick;
        if (!(this.maxCount > 0)) {
            boolean $i$a$-require-ProgressSequencedHelper$32 = false;
            String $i$a$-require-ProgressSequencedHelper$32 = "maxCount \u5fc5\u987b\u5927\u4e8e 0";
            throw new IllegalArgumentException($i$a$-require-ProgressSequencedHelper$32.toString());
        }
        if (!(this.progressMaxTick > 0)) {
            boolean bl = false;
            String string = "progressMaxTick \u5fc5\u987b\u5927\u4e8e 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.recalculateStep();
    }

    public final int getMaxCount() {
        return this.maxCount;
    }

    public final void setMaxCount(int n) {
        this.maxCount = n;
    }

    public final int getProgressMaxTick() {
        return this.progressMaxTick;
    }

    public final void setProgressMaxTick(int n) {
        this.progressMaxTick = n;
    }

    public final int getCurrent() {
        return this.current;
    }

    protected final void setCurrent(int n) {
        this.current = n;
    }

    protected final double getStep() {
        return this.step;
    }

    protected final void setStep(double d) {
        this.step = d;
    }

    @NotNull
    public final ProgressSequencedHelper recalculateStep() {
        this.step = (double)this.maxCount / (double)this.progressMaxTick;
        this.remainder = 0.0;
        return this;
    }

    public final void setProgress(double percent) {
        double clamped = RangesKt.coerceIn((double)percent, (double)0.0, (double)1.0);
        int targetTick = MathKt.roundToInt((double)(clamped * (double)this.progressMaxTick));
        this.doProgressTo(targetTick);
    }

    public final void increaseProgress() {
        if (this.over()) {
            return;
        }
        if (this.getLoadedStyle() == null) {
            return;
        }
        int actualStep = this.calculateActualStep(true);
        if (actualStep > 0) {
            this.addMultiple(actualStep);
            int n = this.current;
            this.current = n + 1;
        }
    }

    public final void decreaseProgress() {
        if (this.isZero()) {
            return;
        }
        if (this.getLoadedStyle() == null) {
            return;
        }
        int actualStep = this.calculateActualStep(false);
        if (actualStep > 0) {
            this.removeMultiple(actualStep);
            int n = this.current;
            this.current = n + -1;
        }
    }

    public final void doProgressTo(int targetTick) {
        if (this.getLoadedStyle() == null) {
            return;
        }
        int target = RangesKt.coerceIn((int)targetTick, (int)0, (int)this.progressMaxTick);
        if (target > this.current) {
            int addCount = this.calculateTotalStep(this.current, target);
            this.addMultiple(addCount);
        } else if (target < this.current) {
            int removeCount = this.calculateTotalStep(target, this.current);
            this.removeMultiple(removeCount);
        }
        this.current = target;
    }

    public final boolean over() {
        return this.current >= this.progressMaxTick;
    }

    public final boolean isZero() {
        return this.current <= 0;
    }

    private final int calculateActualStep(boolean isAdding) {
        double raw = this.step + this.remainder;
        int integerPart = (int)raw;
        this.remainder = raw - (double)integerPart;
        return RangesKt.coerceAtLeast((int)(isAdding ? integerPart : integerPart), (int)1);
    }

    private final int calculateTotalStep(int from, int to) {
        int delta = to - from;
        return MathKt.roundToInt((double)((double)delta * this.step));
    }

    public abstract void addMultiple(int var1);

    public abstract void removeMultiple(int var1);

    @Nullable
    public abstract Controlable<?> getLoadedStyle();

    protected abstract void changeStatusBatch(@NotNull int[] var1, boolean var2);
}

