/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.string;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.functions.FunctionParameters;
import com.ezylang.evalex.parser.Token;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.stream.IntStream;

@FunctionParameters(value={@FunctionParameter(name="format"), @FunctionParameter(name="arguments", isVarArg=true)})
public class StringFormatFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        String format = parameterValues[0].getStringValue();
        Object[] arguments = this.getFormatArguments(parameterValues, expression.getConfiguration());
        return expression.convertValue(String.format(expression.getConfiguration().getLocale(), format, arguments));
    }

    private Object[] getFormatArguments(EvaluationValue[] parameterValues, ExpressionConfiguration configuration) {
        if (parameterValues.length > 1) {
            return this.convertParametersToObjects(parameterValues, configuration);
        }
        return new Object[0];
    }

    private Object[] convertParametersToObjects(EvaluationValue[] parameterValues, ExpressionConfiguration configuration) {
        return IntStream.range(1, parameterValues.length).mapToObj(i -> this.convertParameterToObject(parameterValues[i], configuration)).toArray();
    }

    private Object convertParameterToObject(EvaluationValue parameterValue, ExpressionConfiguration configuration) {
        if (parameterValue.isDateTimeValue()) {
            return this.convertInstantToLocalDateTime(parameterValue.getDateTimeValue(), configuration.getZoneId());
        }
        return parameterValue.getValue();
    }

    private ZonedDateTime convertInstantToLocalDateTime(Instant instant, ZoneId zoneId) {
        return instant.atZone(zoneId);
    }
}

