/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.shop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.sethi.pebbles.chestshop.ChestShop;
import tech.sethi.pebbles.chestshop.economy.CobbleApiEconomy;
import tech.sethi.pebbles.chestshop.economy.IEconomy;
import tech.sethi.pebbles.chestshop.economy.ImpactorEconomy;
import tech.sethi.pebbles.chestshop.economy.PebblesEconomy;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\tR#\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Ltech/sethi/pebbles/chestshop/shop/BalanceHandler;", "", "<init>", "()V", "", "reloadAllBalances", "", "player", "saveBalance", "(Ljava/lang/String;)V", "saveAllBalances", "", "getBalance", "(Ljava/lang/String;)D", "amount", "addBalance", "(Ljava/lang/String;D)V", "withdrawBalance", "", "balances", "Ljava/util/Map;", "getBalances", "()Ljava/util/Map;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "balanceFolder", "Ljava/lang/String;", "getBalanceFolder", "()Ljava/lang/String;", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "economy", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "getEconomy", "()Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "Balance", "common"})
public final class BalanceHandler {
    @NotNull
    public static final BalanceHandler INSTANCE = new BalanceHandler();
    @NotNull
    private static final Map<String, Double> balances = new LinkedHashMap();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final String balanceFolder = "config/pebbles-chestshop/balances/";
    @NotNull
    private static final IEconomy economy;

    private BalanceHandler() {
    }

    @NotNull
    public final Map<String, Double> getBalances() {
        return balances;
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final String getBalanceFolder() {
        return balanceFolder;
    }

    public final void reloadAllBalances() {
        balances.clear();
        File balanceFolderFile = new File(balanceFolder);
        if (!balanceFolderFile.exists()) {
            balanceFolderFile.mkdirs();
        } else {
            File[] fileArray = balanceFolderFile.listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            for (File balanceFile : fileArray) {
                Intrinsics.checkNotNull((Object)balanceFile);
                String balanceString = FilesKt.readText$default((File)balanceFile, null, (int)1, null);
                Double balance = (Double)gson.fromJson(balanceString, Double.TYPE);
                String uuid = FilesKt.getNameWithoutExtension((File)balanceFile);
                balances.put(uuid, balance);
            }
        }
    }

    public final void saveBalance(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Double d = balances.get(player);
        if (d == null) {
            return;
        }
        double balance = d;
        File balanceFile = new File(balanceFolder + player + ".json");
        String balanceString = gson.toJson((Object)balance);
        Intrinsics.checkNotNull((Object)balanceString);
        FilesKt.writeText$default((File)balanceFile, (String)balanceString, null, (int)2, null);
    }

    public final void saveAllBalances() {
        Iterator<Map.Entry<String, Double>> iterator = balances.entrySet().iterator();
        while (iterator.hasNext()) {
            String uuid = iterator.next().getKey();
            this.saveBalance(uuid);
        }
    }

    @NotNull
    public final IEconomy getEconomy() {
        return economy;
    }

    public final double getBalance(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Double d = balances.get(player);
        return d != null ? d : 0.0;
    }

    public final void addBalance(@NotNull String player, double amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        balances.put(player, this.getBalance(player) + amount);
    }

    public final synchronized void withdrawBalance(@NotNull String player) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                double balance = this.getBalance(player);
                if (!(balance > 0.0)) break block1;
                UUID uUID = UUID.fromString(player);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                economy.deposit(uUID, balance);
                MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
                Intrinsics.checkNotNull((Object)minecraftServer);
                class_3222 class_32222 = minecraftServer.method_3760().method_14602(UUID.fromString(player));
                if (class_32222 != null) {
                    class_32222.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " You have withdrawn " + balance + " " + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + " from your chest shop balance."), false);
                }
                balances.put(player, 0.0);
                break block2;
            }
            MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_3222 class_32223 = minecraftServer.method_3760().method_14602(UUID.fromString(player));
            if (class_32223 == null) break block2;
            class_32223.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>You have no balance to withdraw."), false);
        }
    }

    static {
        File balanceFolderFile = new File(balanceFolder);
        if (!balanceFolderFile.exists()) {
            balanceFolderFile.mkdirs();
        } else {
            INSTANCE.reloadAllBalances();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        while (true) {
                            INSTANCE.saveAllBalances();
                            Thread.sleep(300000L);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        economy = switch (ConfigHandler.INSTANCE.getConfig().getEconomy()) {
            case "pebbleseconomy" -> new PebblesEconomy();
            case "impactor" -> new ImpactorEconomy();
            case "cobbleapi" -> new CobbleApiEconomy();
            default -> new ImpactorEconomy();
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ltech/sethi/pebbles/chestshop/shop/BalanceHandler$Balance;", "", "", "uuid", "", "balance", "<init>", "(Ljava/lang/String;D)V", "component1", "()Ljava/lang/String;", "component2", "()D", "copy", "(Ljava/lang/String;D)Ltech/sethi/pebbles/chestshop/shop/BalanceHandler$Balance;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getUuid", "D", "getBalance", "common"})
    public static final class Balance {
        @NotNull
        private final String uuid;
        private final double balance;

        public Balance(@NotNull String uuid, double balance) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.balance = balance;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public final double getBalance() {
            return this.balance;
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        public final double component2() {
            return this.balance;
        }

        @NotNull
        public final Balance copy(@NotNull String uuid, double balance) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Balance(uuid, balance);
        }

        public static /* synthetic */ Balance copy$default(Balance balance, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = balance.uuid;
            }
            if ((n & 2) != 0) {
                d = balance.balance;
            }
            return balance.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "Balance(uuid=" + this.uuid + ", balance=" + this.balance + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Double.hashCode(this.balance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Balance)) {
                return false;
            }
            Balance balance = (Balance)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)balance.uuid)) {
                return false;
            }
            return Double.compare(this.balance, balance.balance) == 0;
        }
    }
}

