/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.shop;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import tech.sethi.pebbles.chestshop.economy.CobbleApiEconomy;
import tech.sethi.pebbles.chestshop.economy.IEconomy;
import tech.sethi.pebbles.chestshop.economy.ImpactorEconomy;
import tech.sethi.pebbles.chestshop.economy.PebblesEconomy;
import tech.sethi.pebbles.chestshop.shop.BalanceHandler;
import tech.sethi.pebbles.chestshop.shop.Shop;
import tech.sethi.pebbles.chestshop.shop.ShopItem;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u001d\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Ltech/sethi/pebbles/chestshop/shop/ProcessTransaction;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Ltech/sethi/pebbles/chestshop/shop/Shop;", "shop", "", "process", "(Lnet/minecraft/class_3222;Ltech/sethi/pebbles/chestshop/shop/Shop;)V", "Lnet/minecraft/class_1661;", "inventory", "Lnet/minecraft/class_1799;", "itemStack", "", "hasEnoughItems", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)Z", "removeItemsFromInventory", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "giveItemsToPlayer", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)V", "Lnet/minecraft/class_2595;", "chestBlockEntity", "chestHasEnoughSpace", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)Z", "insertItemIntoChest", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)V", "chestHasEnoughItems", "deleteItemFromChest", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "shopHasBudget", "(Ltech/sethi/pebbles/chestshop/shop/Shop;)Z", "deductBudget", "(Ltech/sethi/pebbles/chestshop/shop/Shop;)V", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "economy", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "getEconomy", "()Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "common"})
@SourceDebugExtension(value={"SMAP\nProcessTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessTransaction.kt\ntech/sethi/pebbles/chestshop/shop/ProcessTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1#2:290\n*E\n"})
public final class ProcessTransaction {
    @NotNull
    private final IEconomy economy = switch (ConfigHandler.INSTANCE.getConfig().getEconomy()) {
        case "pebbleseconomy" -> new PebblesEconomy();
        case "impactor" -> new ImpactorEconomy();
        case "cobbleapi" -> new CobbleApiEconomy();
        default -> new ImpactorEconomy();
    };

    @NotNull
    public final IEconomy getEconomy() {
        return this.economy;
    }

    public final synchronized void process(@NotNull class_3222 player, @NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)player.method_5845(), (Object)shop.getOwner())) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " " + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getOwnShop()), false);
            return;
        }
        class_1661 playerInv = player.method_31548();
        class_2960 class_29602 = class_2960.method_12829((String)shop.getShopItem().getItem());
        if (class_29602 == null) {
            return;
        }
        class_2960 shopIdentifier = class_29602;
        class_1799 shopItemStack = shop.getShopItem().toItemStack();
        String[] stringArray = new String[]{", "};
        List chestLocation = StringsKt.split$default((CharSequence)shop.getChestLocation(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        class_2586 chestEntity = player.method_37908().method_8321(new class_2338(Integer.parseInt((String)chestLocation.get(0)), Integer.parseInt((String)chestLocation.get(1)), Integer.parseInt((String)chestLocation.get(2))));
        class_2586 class_25862 = chestEntity;
        if ((class_25862 != null && (class_25862 = class_25862.method_11010()) != null ? (class_2745)class_25862.method_11654((class_2769)class_2281.field_10770) : null) != class_2745.field_12569) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " Shop is malformed."), false);
            return;
        }
        Intrinsics.checkNotNull((Object)chestEntity, (String)"null cannot be cast to non-null type net.minecraft.block.entity.ChestBlockEntity");
        class_2595 cfr_ignored_0 = (class_2595)chestEntity;
        String string = shop.getShopItem().getType();
        if (Intrinsics.areEqual((Object)string, (Object)"sell")) {
            if (ConfigHandler.INSTANCE.isBuyingBlacklisted(shop.getShopItem().getItem())) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Buying this item from players is blacklisted.</red>"), false);
                return;
            }
            Intrinsics.checkNotNull((Object)playerInv);
            if (this.hasEnoughItems(playerInv, shopItemStack) && this.chestHasEnoughSpace((class_2595)chestEntity, shopItemStack) && this.shopHasBudget(shop)) {
                Integer n = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n);
                if (n <= 0) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Invalid price for selling."), false);
                    return;
                }
                class_1799 removedStack = this.removeItemsFromInventory(playerInv, shopItemStack);
                this.insertItemIntoChest((class_2595)chestEntity, removedStack);
                this.deductBudget(shop);
                UUID uUID = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
                Integer n2 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n2);
                this.economy.deposit(uUID, n2.intValue());
                String string2 = ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix();
                Integer n3 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n3);
                player.method_7353(PM.INSTANCE.returnStyledText(string2 + " Sold item for " + n3 + " " + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + "."), false);
            } else if (!this.hasEnoughItems(playerInv, shopItemStack)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " " + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getNotEnoughItem()), false);
            } else if (!this.chestHasEnoughSpace((class_2595)chestEntity, shopItemStack)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " " + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getChestFull()), false);
            } else if (!this.shopHasBudget(shop)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " " + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getShopOutOfBudget()), false);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"buy")) {
            if (ConfigHandler.INSTANCE.isSellingBlacklisted(shop.getShopItem().getItem())) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Selling this item to players is blacklisted.</red>"), false);
                return;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            double d = this.economy.getBalance(uUID);
            Integer n = shop.getShopItem().getPrice();
            Intrinsics.checkNotNull((Object)n);
            if (d >= (double)n.intValue() && this.chestHasEnoughItems((class_2595)chestEntity, shopItemStack)) {
                Integer n4 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n4);
                if (n4 <= 0) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Invalid price for buying."), false);
                    return;
                }
                UUID uUID2 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUuid(...)");
                Integer n5 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n5);
                this.economy.withdraw(uUID2, n5.intValue());
                class_1799 removedFromChest = this.deleteItemFromChest((class_2595)chestEntity, shopItemStack);
                Intrinsics.checkNotNull((Object)playerInv);
                this.giveItemsToPlayer(playerInv, removedFromChest);
                String string3 = shop.getOwner();
                Integer n6 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n6);
                BalanceHandler.INSTANCE.addBalance(string3, n6.intValue());
                String string4 = ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix();
                Integer n7 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n7);
                player.method_7353(PM.INSTANCE.returnStyledText(string4 + " <grey>Bought item for " + n7 + "."), false);
            } else {
                UUID uUID3 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUuid(...)");
                double d2 = this.economy.getBalance(uUID3);
                Integer n8 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n8);
                if (d2 < (double)n8.intValue()) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Not enough " + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + " to buy."), false);
                } else if (!this.chestHasEnoughItems((class_2595)chestEntity, shopItemStack)) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Not enough items in chest to buy."), false);
                }
            }
        } else {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " Shop is not configured properly."), false);
        }
    }

    public final boolean hasEnoughItems(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int totalMatchingItemCount = 0;
        int n = inventory.method_5439();
        for (int slotIndex = 0; slotIndex < n; ++slotIndex) {
            class_1799 candidateStack = inventory.method_5438(slotIndex);
            if (candidateStack.method_7960() || !class_1799.method_31577((class_1799)candidateStack, (class_1799)itemStack) || (totalMatchingItemCount += candidateStack.method_7947()) < itemStack.method_7947()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final class_1799 removeItemsFromInventory(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int remainingToRemove = itemStack.method_7947();
        class_1799 removedStack = itemStack.method_7972();
        removedStack.method_7939(0);
        int n = inventory.method_5439();
        for (int slotIndex = 0; slotIndex < n && remainingToRemove > 0; ++slotIndex) {
            class_1799 candidateStack = inventory.method_5438(slotIndex);
            if (candidateStack.method_7960() || !class_1799.method_31577((class_1799)candidateStack, (class_1799)itemStack)) continue;
            int removeAmount = Math.min(remainingToRemove, candidateStack.method_7947());
            inventory.method_5434(slotIndex, removeAmount);
            removedStack.method_7939(removedStack.method_7947() + removeAmount);
            remainingToRemove -= removeAmount;
        }
        Intrinsics.checkNotNull((Object)removedStack);
        return removedStack;
    }

    public final void giveItemsToPlayer(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        inventory.method_7398(itemStack);
    }

    public final boolean chestHasEnoughSpace(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int availableCapacity = 0;
        int emptySlots = 0;
        int n = chestBlockEntity.method_5439();
        for (int slotIndex = 0; slotIndex < n; ++slotIndex) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(slotIndex);
            if (chestItemStack.method_7960()) {
                ++emptySlots;
                continue;
            }
            if (!class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack)) continue;
            availableCapacity += chestItemStack.method_7914() - chestItemStack.method_7947();
        }
        return (availableCapacity += emptySlots * itemStack.method_7914()) >= itemStack.method_7947();
    }

    public final void insertItemIntoChest(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        class_1799 chestItemStack;
        int slotIndex;
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int remaining = itemStack.method_7947();
        int n = chestBlockEntity.method_5439();
        for (slotIndex = 0; slotIndex < n; ++slotIndex) {
            int space;
            int toAdd;
            if (remaining <= 0) {
                return;
            }
            chestItemStack = chestBlockEntity.method_5438(slotIndex);
            if (chestItemStack.method_7960() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack) || chestItemStack.method_7947() >= chestItemStack.method_7914() || (toAdd = Math.min(remaining, space = chestItemStack.method_7914() - chestItemStack.method_7947())) <= 0) continue;
            chestItemStack.method_7939(chestItemStack.method_7947() + toAdd);
            chestBlockEntity.method_5447(slotIndex, chestItemStack);
            remaining -= toAdd;
        }
        n = chestBlockEntity.method_5439();
        for (slotIndex = 0; slotIndex < n; ++slotIndex) {
            if (remaining <= 0) {
                return;
            }
            chestItemStack = chestBlockEntity.method_5438(slotIndex);
            if (!chestItemStack.method_7960()) continue;
            int toPlace = Math.min(remaining, itemStack.method_7914());
            class_1799 newStack = itemStack.method_7972();
            newStack.method_7939(toPlace);
            chestBlockEntity.method_5447(slotIndex, newStack);
            remaining -= toPlace;
        }
    }

    public final boolean chestHasEnoughItems(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int totalMatchingItemCount = 0;
        int n = chestBlockEntity.method_5439();
        for (int slotIndex = 0; slotIndex < n; ++slotIndex) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(slotIndex);
            if (chestItemStack.method_7960() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack) || (totalMatchingItemCount += chestItemStack.method_7947()) < itemStack.method_7947()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final class_1799 deleteItemFromChest(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int remainingToDelete = itemStack.method_7947();
        class_1799 removedStack = itemStack.method_7972();
        removedStack.method_7939(0);
        int n = chestBlockEntity.method_5439();
        for (int slotIndex = 0; slotIndex < n && remainingToDelete > 0; ++slotIndex) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(slotIndex);
            if (chestItemStack.method_7960() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack)) continue;
            int removeAmount = Math.min(remainingToDelete, chestItemStack.method_7947());
            chestBlockEntity.method_5434(slotIndex, removeAmount);
            removedStack.method_7939(removedStack.method_7947() + removeAmount);
            remainingToDelete -= removeAmount;
        }
        Intrinsics.checkNotNull((Object)removedStack);
        return removedStack;
    }

    public final boolean shopHasBudget(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"sell")) {
            boolean bl;
            Integer n = shop.getShopItem().getSellBudget();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n2);
                bl = it >= n2;
            } else {
                bl = false;
            }
            return bl;
        }
        return Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"buy");
    }

    public final void deductBudget(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"sell")) {
            Integer n;
            ShopItem shopItem = shop.getShopItem();
            Integer n2 = shop.getShopItem().getSellBudget();
            if (n2 != null) {
                int n3 = n2;
                Integer n4 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n4);
                n = n3 - n4;
            } else {
                n = null;
            }
            shopItem.setSellBudget(n);
        }
    }
}

