/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.shop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8242;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import tech.sethi.pebbles.chestshop.ChestShop;
import tech.sethi.pebbles.chestshop.shop.BalanceHandler;
import tech.sethi.pebbles.chestshop.shop.Shop;
import tech.sethi.pebbles.chestshop.shop.ShopCreationSession;
import tech.sethi.pebbles.chestshop.shop.ShopCreationState;
import tech.sethi.pebbles.chestshop.shop.ShopItem;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u0003J%\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0015\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0015\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001bR#\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R#\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0\u001f8\u0006\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010#R\u001f\u0010)\u001a\n (*\u0004\u0018\u00010'0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Ltech/sethi/pebbles/chestshop/shop/ShopCreator;", "", "<init>", "()V", "", "location", "dimension", "generateCompoundKey", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "reloadAllShops", "player", "chestLocation", "Ltech/sethi/pebbles/chestshop/shop/ShopItem;", "shopItem", "startSession", "(Ljava/lang/String;Ljava/lang/String;Ltech/sethi/pebbles/chestshop/shop/ShopItem;)V", "Ltech/sethi/pebbles/chestshop/shop/ShopCreationState;", "newState", "advanceSession", "(Ljava/lang/String;Ltech/sethi/pebbles/chestshop/shop/ShopCreationState;)V", "cancelSession", "(Ljava/lang/String;)V", "finalizeSession", "Ltech/sethi/pebbles/chestshop/shop/Shop;", "shop", "saveShop", "(Ltech/sethi/pebbles/chestshop/shop/Shop;)V", "saveAllShops", "deleteShop", "placeSign", "", "shops", "Ljava/util/Map;", "getShops", "()Ljava/util/Map;", "Ltech/sethi/pebbles/chestshop/shop/ShopCreationSession;", "sessions", "getSessions", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "shopFolder", "Ljava/lang/String;", "getShopFolder", "()Ljava/lang/String;", "common"})
@SourceDebugExtension(value={"SMAP\nShopCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShopCreator.kt\ntech/sethi/pebbles/chestshop/shop/ShopCreator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n13346#2,2:226\n1557#3:228\n1628#3,3:229\n*S KotlinDebug\n*F\n+ 1 ShopCreator.kt\ntech/sethi/pebbles/chestshop/shop/ShopCreator\n*L\n57#1:226,2\n166#1:228\n166#1:229,3\n*E\n"})
public final class ShopCreator {
    @NotNull
    public static final ShopCreator INSTANCE = new ShopCreator();
    @NotNull
    private static final Map<String, Shop> shops = new LinkedHashMap();
    @NotNull
    private static final Map<String, ShopCreationSession> sessions = new LinkedHashMap();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final String shopFolder = "config/pebbles-chestshop/shops/";

    private ShopCreator() {
    }

    @NotNull
    public final Map<String, Shop> getShops() {
        return shops;
    }

    @NotNull
    public final Map<String, ShopCreationSession> getSessions() {
        return sessions;
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final String getShopFolder() {
        return shopFolder;
    }

    @NotNull
    public final String generateCompoundKey(@NotNull String location, @NotNull String dimension) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        return location + ":" + dimension;
    }

    public final void reloadAllShops() {
        block7: {
            File shopFolderFile;
            block6: {
                shops.clear();
                shopFolderFile = new File(shopFolder);
                if (shopFolderFile.exists()) break block6;
                shopFolderFile.mkdirs();
                break block7;
            }
            File[] fileArray = shopFolderFile.listFiles();
            if (fileArray == null) break block7;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File shopFile = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                try {
                    Intrinsics.checkNotNull((Object)shopFile);
                    String shopString = FilesKt.readText$default((File)shopFile, null, (int)1, null);
                    Shop shop = (Shop)gson.fromJson(shopString, Shop.class);
                    if (shop == null) {
                        ChestShop.INSTANCE.getLOGGER().error("Invalid or null shop in file " + shopFile.getName() + ". Skipping.");
                        continue;
                    }
                    try {
                        String key = INSTANCE.generateCompoundKey(shop.getChestLocation(), shop.getDimension());
                        shops.put(key, shop);
                    }
                    catch (Exception e) {
                        ChestShop.INSTANCE.getLOGGER().error("Malformed shop data in file " + shopFile.getName() + ". Skipping.", (Throwable)e);
                    }
                    continue;
                }
                catch (Exception e) {
                    ChestShop.INSTANCE.getLOGGER().error("Failed to load shop file " + shopFile.getName(), (Throwable)e);
                }
            }
        }
    }

    public final void startSession(@NotNull String player, @NotNull String chestLocation, @NotNull ShopItem shopItem) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)chestLocation, (String)"chestLocation");
        Intrinsics.checkNotNullParameter((Object)shopItem, (String)"shopItem");
        MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3222 playerEntity = minecraftServer.method_3760().method_14602(UUID.fromString(player));
        class_3222 class_32222 = playerEntity;
        String string = class_32222 != null && (class_32222 = class_32222.method_37908()) != null && (class_32222 = class_32222.method_27983()) != null && (class_32222 = class_32222.method_29177()) != null ? class_32222.method_12832() : null;
        Intrinsics.checkNotNull(string);
        String dimension = string;
        if (ConfigHandler.INSTANCE.isCreationBlacklisted(shopItem.getItem())) {
            class_3222 class_32223 = playerEntity;
            if (class_32223 != null) {
                class_32223.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>This item is blacklisted from shop creation.</red>"), false);
            }
            return;
        }
        ShopCreationSession session = new ShopCreationSession(player, ShopCreationState.INITIAL, new Shop(player, chestLocation, dimension, shopItem, null, 16, null));
        sessions.put(player, session);
        session.timeout();
    }

    public final void advanceSession(@NotNull String player, @NotNull ShopCreationState newState) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        ShopCreationSession session = sessions.get(player);
        if (session != null) {
            session.setState(newState);
        }
    }

    public final void cancelSession(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        sessions.remove(player);
    }

    public final void finalizeSession(@NotNull String player) {
        ShopCreationSession session;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ShopCreationSession shopCreationSession = session = sessions.remove(player);
        if ((shopCreationSession != null ? shopCreationSession.getShop() : null) != null) {
            class_3222 playerEntity;
            Shop shop = session.getShop();
            Intrinsics.checkNotNull((Object)shop);
            String string = shop.getChestLocation();
            Shop shop2 = session.getShop();
            Intrinsics.checkNotNull((Object)shop2);
            String string2 = this.generateCompoundKey(string, shop2.getDimension());
            Shop shop3 = session.getShop();
            Intrinsics.checkNotNull((Object)shop3);
            shops.put(string2, shop3);
            MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_3222 class_32222 = playerEntity = minecraftServer.method_3760().method_14602(UUID.fromString(player));
            if (class_32222 != null) {
                class_32222.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " " + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationComplete()), false);
            }
            Shop shop4 = session.getShop();
            Intrinsics.checkNotNull((Object)shop4);
            this.placeSign(shop4);
            Shop shop5 = session.getShop();
            Intrinsics.checkNotNull((Object)shop5);
            this.saveShop(shop5);
        }
    }

    public final void saveShop(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        File shopFile = new File(shopFolder + shop.getOwner() + shop.getChestLocation() + ".json");
        String shopString = gson.toJson((Object)shop);
        Intrinsics.checkNotNull((Object)shopString);
        FilesKt.writeText$default((File)shopFile, (String)shopString, null, (int)2, null);
    }

    public final void saveAllShops() {
        for (Shop shop : shops.values()) {
            this.saveShop(shop);
        }
    }

    public final void deleteShop(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        String shopFilePath = shopFolder + shop.getOwner() + shop.getChestLocation() + ".json";
        File shopFile = new File(shopFilePath);
        shopFile.delete();
        String shopKey = this.generateCompoundKey(shop.getChestLocation(), shop.getDimension());
        if (Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"sell") && shop.getShopItem().getSellBudget() != null) {
            Integer n = shop.getShopItem().getSellBudget();
            Intrinsics.checkNotNull((Object)n);
            if (n > 0) {
                String string = shop.getOwner();
                Integer n2 = shop.getShopItem().getSellBudget();
                Intrinsics.checkNotNull((Object)n2);
                BalanceHandler.INSTANCE.addBalance(string, n2.intValue());
            }
        }
        shops.remove(shopKey);
    }

    /*
     * WARNING - void declaration
     */
    private final void placeSign(Shop shop) {
        void $this$mapTo$iv$iv;
        MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3222 playerEntity = minecraftServer.method_3760().method_14602(UUID.fromString(shop.getOwner()));
        String[] stringArray = new String[]{", "};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)shop.getChestLocation(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt((String)it));
        }
        List coords = (List)destination$iv$iv;
        int x = ((Number)coords.get(0)).intValue();
        int y = ((Number)coords.get(1)).intValue();
        int z = ((Number)coords.get(2)).intValue();
        class_2338 chestBlockPos = new class_2338(x, y, z);
        String dimensionString = shop.getDimension();
        class_3222 class_32222 = playerEntity;
        Intrinsics.checkNotNull((Object)class_32222);
        if (!Intrinsics.areEqual((Object)class_32222.method_37908().method_27983().method_29177().method_12832(), (Object)dimensionString)) {
            playerEntity.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>You must be in the same dimension as the shop to create a sign</red>"), false);
            sessions.remove(shop.getOwner());
            return;
        }
        class_1937 world = playerEntity.method_37908();
        class_2680 chestBlockState = world.method_8320(chestBlockPos);
        class_2350 facing = (class_2350)chestBlockState.method_11654((class_2769)class_2383.field_11177);
        class_2338 signBlockPos = chestBlockPos.method_10093(facing);
        world.method_8652(signBlockPos, (class_2680)class_2246.field_10187.method_9564().method_11657((class_2769)class_2551.field_11726, (Comparable)facing), 3);
        class_2586 signBlockEntity = world.method_8321(signBlockPos);
        Object object = class_7923.field_41178.method_10223(class_2960.method_60654((String)shop.getShopItem().getItem()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        class_1792 shopItemStack = (class_1792)object;
        if (signBlockEntity instanceof class_2625) {
            String headerText = Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"buy") ? ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopSignBuyRow() : ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopSignSellRow();
            class_2561[] class_2561Array = new class_2561[]{PM.INSTANCE.returnStyledText(headerText), PM.INSTANCE.returnStyledText("<aqua><b>" + shopItemStack.method_7848().getString() + "<b></aqua>"), PM.INSTANCE.returnStyledText("<black><b>" + shop.getShopItem().getPrice() + "</b></black>"), PM.INSTANCE.returnStyledText("<yellow>" + playerEntity.method_5477().getString() + "</yellow>")};
            class_2561[] messageArray = class_2561Array;
            class_2561[] filteredMessageArray = (class_2561[])messageArray.clone();
            class_1767 signTextColor = class_1767.field_7963;
            boolean signTextGlowing = false;
            class_8242 signText = new class_8242(messageArray, filteredMessageArray, signTextColor, signTextGlowing);
            ((class_2625)signBlockEntity).method_49840(signText, true);
            ((class_2625)signBlockEntity).method_49840(signText, false);
            shop.setSignLocation(signBlockPos.method_23854());
        }
    }

    static {
        File shopFolderFile = new File(shopFolder);
        if (!shopFolderFile.exists()) {
            shopFolderFile.mkdirs();
        } else {
            INSTANCE.reloadAllShops();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        while (true) {
                            INSTANCE.saveAllShops();
                            Thread.sleep(300000L);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

