/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005)*+,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000bR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001f\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006."}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler;", "", "<init>", "()V", "", "reload", "reloadBlacklist", "", "itemId", "", "isCreationBlacklisted", "(Ljava/lang/String;)Z", "isBuyingBlacklisted", "isSellingBlacklisted", "Ljava/io/File;", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "blacklistFile", "getBlacklistFile", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;", "config", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;", "getConfig", "()Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;", "setConfig", "(Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;)V", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;", "blacklist", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;", "getBlacklist", "()Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;", "setBlacklist", "(Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Config", "Message", "Creator", "Interactions", "Blacklist", "common"})
public final class ConfigHandler {
    @NotNull
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    @NotNull
    private static final File configFile = new File("config/pebbles-chestshop/config.json");
    @NotNull
    private static final File blacklistFile = new File("config/pebbles-chestshop/blacklist.json");
    @NotNull
    private static Config config = new Config(null, null, null, null, null, 31, null);
    @NotNull
    private static Blacklist blacklist = new Blacklist(null, null, null, 7, null);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private ConfigHandler() {
    }

    @NotNull
    public final File getConfigFile() {
        return configFile;
    }

    @NotNull
    public final File getBlacklistFile() {
        return blacklistFile;
    }

    @NotNull
    public final Config getConfig() {
        return config;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        ConfigHandler.config = config;
    }

    @NotNull
    public final Blacklist getBlacklist() {
        return blacklist;
    }

    public final void setBlacklist(@NotNull Blacklist blacklist) {
        Intrinsics.checkNotNullParameter((Object)blacklist, (String)"<set-?>");
        ConfigHandler.blacklist = blacklist;
    }

    public final Gson getGson() {
        return gson;
    }

    public final void reload() {
        String configString = FilesKt.readText$default((File)configFile, null, (int)1, null);
        config = (Config)gson.fromJson(configString, Config.class);
    }

    public final void reloadBlacklist() {
        String blacklistString = FilesKt.readText$default((File)blacklistFile, null, (int)1, null);
        blacklist = (Blacklist)gson.fromJson(blacklistString, Blacklist.class);
    }

    public final boolean isCreationBlacklisted(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return blacklist.getCreation().contains(itemId);
    }

    public final boolean isBuyingBlacklisted(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return blacklist.getBuy().contains(itemId);
    }

    public final boolean isSellingBlacklisted(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return blacklist.getSell().contains(itemId);
    }

    static {
        if (configFile.exists()) {
            configString = FilesKt.readText$default((File)configFile, null, (int)1, null);
            config = (Config)gson.fromJson(configString, Config.class);
        } else {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            configString = gson.toJson((Object)config);
            Intrinsics.checkNotNull((Object)configString);
            FilesKt.writeText$default((File)configFile, (String)configString, null, (int)2, null);
        }
        if (blacklistFile.exists()) {
            blacklistString = FilesKt.readText$default((File)blacklistFile, null, (int)1, null);
            blacklist = (Blacklist)gson.fromJson(blacklistString, Blacklist.class);
        } else {
            blacklistFile.getParentFile().mkdirs();
            blacklistFile.createNewFile();
            blacklistString = gson.toJson((Object)blacklist);
            Intrinsics.checkNotNull((Object)blacklistString);
            FilesKt.writeText$default((File)blacklistFile, (String)blacklistString, null, (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ@\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001a\u0010\nR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001b\u0010\n\u00a8\u0006\u001c"}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;", "", "", "", "creation", "buy", "sell", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "component1", "()Ljava/util/List;", "component2", "component3", "copy", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Blacklist;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getCreation", "getBuy", "getSell", "common"})
    public static final class Blacklist {
        @NotNull
        private final List<String> creation;
        @NotNull
        private final List<String> buy;
        @NotNull
        private final List<String> sell;

        public Blacklist(@NotNull List<String> creation, @NotNull List<String> buy, @NotNull List<String> sell) {
            Intrinsics.checkNotNullParameter(creation, (String)"creation");
            Intrinsics.checkNotNullParameter(buy, (String)"buy");
            Intrinsics.checkNotNullParameter(sell, (String)"sell");
            this.creation = creation;
            this.buy = buy;
            this.sell = sell;
        }

        public /* synthetic */ Blacklist(List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            Object[] objectArray;
            if ((n & 1) != 0) {
                objectArray = new String[]{"minecraft:shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:cyan_shulker_box", "minecraft:gray_shulker_box", "minecraft:green_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:light_gray_shulker_box", "minecraft:lime_shulker_box", "minecraft:magenta_shulker_box", "minecraft:orange_shulker_box", "minecraft:pink_shulker_box", "minecraft:purple_shulker_box", "minecraft:red_shulker_box", "minecraft:white_shulker_box", "minecraft:yellow_shulker_box", "minecraft:bundle"};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            if ((n & 2) != 0) {
                objectArray = new String[]{"minecraft:shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:cyan_shulker_box", "minecraft:gray_shulker_box", "minecraft:green_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:light_gray_shulker_box", "minecraft:lime_shulker_box", "minecraft:magenta_shulker_box", "minecraft:orange_shulker_box", "minecraft:pink_shulker_box", "minecraft:purple_shulker_box", "minecraft:red_shulker_box", "minecraft:white_shulker_box", "minecraft:yellow_shulker_box", "minecraft:bundle"};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            }
            if ((n & 4) != 0) {
                objectArray = new String[]{"minecraft:shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:cyan_shulker_box", "minecraft:gray_shulker_box", "minecraft:green_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:light_gray_shulker_box", "minecraft:lime_shulker_box", "minecraft:magenta_shulker_box", "minecraft:orange_shulker_box", "minecraft:pink_shulker_box", "minecraft:purple_shulker_box", "minecraft:red_shulker_box", "minecraft:white_shulker_box", "minecraft:yellow_shulker_box", "minecraft:bundle"};
                list3 = CollectionsKt.listOf((Object[])objectArray);
            }
            this(list, list2, list3);
        }

        @NotNull
        public final List<String> getCreation() {
            return this.creation;
        }

        @NotNull
        public final List<String> getBuy() {
            return this.buy;
        }

        @NotNull
        public final List<String> getSell() {
            return this.sell;
        }

        @NotNull
        public final List<String> component1() {
            return this.creation;
        }

        @NotNull
        public final List<String> component2() {
            return this.buy;
        }

        @NotNull
        public final List<String> component3() {
            return this.sell;
        }

        @NotNull
        public final Blacklist copy(@NotNull List<String> creation, @NotNull List<String> buy, @NotNull List<String> sell) {
            Intrinsics.checkNotNullParameter(creation, (String)"creation");
            Intrinsics.checkNotNullParameter(buy, (String)"buy");
            Intrinsics.checkNotNullParameter(sell, (String)"sell");
            return new Blacklist(creation, buy, sell);
        }

        public static /* synthetic */ Blacklist copy$default(Blacklist blacklist, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = blacklist.creation;
            }
            if ((n & 2) != 0) {
                list2 = blacklist.buy;
            }
            if ((n & 4) != 0) {
                list3 = blacklist.sell;
            }
            return blacklist.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "Blacklist(creation=" + this.creation + ", buy=" + this.buy + ", sell=" + this.sell + ")";
        }

        public int hashCode() {
            int result = ((Object)this.creation).hashCode();
            result = result * 31 + ((Object)this.buy).hashCode();
            result = result * 31 + ((Object)this.sell).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Blacklist)) {
                return false;
            }
            Blacklist blacklist = (Blacklist)other;
            if (!Intrinsics.areEqual(this.creation, blacklist.creation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.buy, blacklist.buy)) {
                return false;
            }
            return Intrinsics.areEqual(this.sell, blacklist.sell);
        }

        public Blacklist() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011JB\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001e\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001f\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b \u0010\fR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010\u0011\u00a8\u0006#"}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;", "", "", "economy", "currencyName", "configItem", "overviewUiName", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "component5", "()Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;)Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Config;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getEconomy", "getCurrencyName", "getConfigItem", "getOverviewUiName", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;", "getMessage", "common"})
    public static final class Config {
        @NotNull
        private final String economy;
        @NotNull
        private final String currencyName;
        @NotNull
        private final String configItem;
        @NotNull
        private final String overviewUiName;
        @NotNull
        private final Message message;

        public Config(@NotNull String economy, @NotNull String currencyName, @NotNull String configItem, @NotNull String overviewUiName, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)economy, (String)"economy");
            Intrinsics.checkNotNullParameter((Object)currencyName, (String)"currencyName");
            Intrinsics.checkNotNullParameter((Object)configItem, (String)"configItem");
            Intrinsics.checkNotNullParameter((Object)overviewUiName, (String)"overviewUiName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.economy = economy;
            this.currencyName = currencyName;
            this.configItem = configItem;
            this.overviewUiName = overviewUiName;
            this.message = message;
        }

        public /* synthetic */ Config(String string, String string2, String string3, String string4, Message message, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "impactor";
            }
            if ((n & 2) != 0) {
                string2 = "PokeDollar";
            }
            if ((n & 4) != 0) {
                string3 = "minecraft:paper";
            }
            if ((n & 8) != 0) {
                string4 = "<blue>Chestshop Overview</blue>";
            }
            if ((n & 0x10) != 0) {
                message = new Message(null, null, null, 7, null);
            }
            this(string, string2, string3, string4, message);
        }

        @NotNull
        public final String getEconomy() {
            return this.economy;
        }

        @NotNull
        public final String getCurrencyName() {
            return this.currencyName;
        }

        @NotNull
        public final String getConfigItem() {
            return this.configItem;
        }

        @NotNull
        public final String getOverviewUiName() {
            return this.overviewUiName;
        }

        @NotNull
        public final Message getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.economy;
        }

        @NotNull
        public final String component2() {
            return this.currencyName;
        }

        @NotNull
        public final String component3() {
            return this.configItem;
        }

        @NotNull
        public final String component4() {
            return this.overviewUiName;
        }

        @NotNull
        public final Message component5() {
            return this.message;
        }

        @NotNull
        public final Config copy(@NotNull String economy, @NotNull String currencyName, @NotNull String configItem, @NotNull String overviewUiName, @NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)economy, (String)"economy");
            Intrinsics.checkNotNullParameter((Object)currencyName, (String)"currencyName");
            Intrinsics.checkNotNullParameter((Object)configItem, (String)"configItem");
            Intrinsics.checkNotNullParameter((Object)overviewUiName, (String)"overviewUiName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Config(economy, currencyName, configItem, overviewUiName, message);
        }

        public static /* synthetic */ Config copy$default(Config config, String string, String string2, String string3, String string4, Message message, int n, Object object) {
            if ((n & 1) != 0) {
                string = config.economy;
            }
            if ((n & 2) != 0) {
                string2 = config.currencyName;
            }
            if ((n & 4) != 0) {
                string3 = config.configItem;
            }
            if ((n & 8) != 0) {
                string4 = config.overviewUiName;
            }
            if ((n & 0x10) != 0) {
                message = config.message;
            }
            return config.copy(string, string2, string3, string4, message);
        }

        @NotNull
        public String toString() {
            return "Config(economy=" + this.economy + ", currencyName=" + this.currencyName + ", configItem=" + this.configItem + ", overviewUiName=" + this.overviewUiName + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.economy.hashCode();
            result = result * 31 + this.currencyName.hashCode();
            result = result * 31 + this.configItem.hashCode();
            result = result * 31 + this.overviewUiName.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual((Object)this.economy, (Object)config.economy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currencyName, (Object)config.currencyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configItem, (Object)config.configItem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overviewUiName, (Object)config.overviewUiName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)config.message);
        }

        public Config() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0010\u0010\u0016\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0013J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0013J\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0013J\u0010\u0010\u001c\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0013J\u0010\u0010\u001d\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u0013J\u0010\u0010\u001e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u0013J\u0010\u0010\u001f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010\u0013J\u0092\u0001\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u001a\u0010$\u001a\u00020#2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010'\u001a\u00020&H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b)\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b,\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b-\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010*\u001a\u0004\b.\u0010\u0013R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b/\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010*\u001a\u0004\b0\u0010\u0013R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010*\u001a\u0004\b1\u0010\u0013R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010*\u001a\u0004\b2\u0010\u0013R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010*\u001a\u0004\b3\u0010\u0013R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010*\u001a\u0004\b4\u0010\u0013R\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010*\u001a\u0004\b5\u0010\u0013R\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010*\u001a\u0004\b6\u0010\u0013R\u0017\u0010\u000f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010*\u001a\u0004\b7\u0010\u0013\u00a8\u00068"}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;", "", "", "emptyChest", "mismatchedItems", "shopCreationInProgress", "shopCreationStarted", "shopCreationSelectType", "shopCreationSetPrice", "shopCreationSetSellBudget", "shopCreationTimeout", "shopCreationCancelled", "shopCreationComplete", "shopAlreadyExists", "shopSignBuyRow", "shopSignSellRow", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getEmptyChest", "getMismatchedItems", "getShopCreationInProgress", "getShopCreationStarted", "getShopCreationSelectType", "getShopCreationSetPrice", "getShopCreationSetSellBudget", "getShopCreationTimeout", "getShopCreationCancelled", "getShopCreationComplete", "getShopAlreadyExists", "getShopSignBuyRow", "getShopSignSellRow", "common"})
    public static final class Creator {
        @NotNull
        private final String emptyChest;
        @NotNull
        private final String mismatchedItems;
        @NotNull
        private final String shopCreationInProgress;
        @NotNull
        private final String shopCreationStarted;
        @NotNull
        private final String shopCreationSelectType;
        @NotNull
        private final String shopCreationSetPrice;
        @NotNull
        private final String shopCreationSetSellBudget;
        @NotNull
        private final String shopCreationTimeout;
        @NotNull
        private final String shopCreationCancelled;
        @NotNull
        private final String shopCreationComplete;
        @NotNull
        private final String shopAlreadyExists;
        @NotNull
        private final String shopSignBuyRow;
        @NotNull
        private final String shopSignSellRow;

        public Creator(@NotNull String emptyChest, @NotNull String mismatchedItems, @NotNull String shopCreationInProgress, @NotNull String shopCreationStarted, @NotNull String shopCreationSelectType, @NotNull String shopCreationSetPrice, @NotNull String shopCreationSetSellBudget, @NotNull String shopCreationTimeout, @NotNull String shopCreationCancelled, @NotNull String shopCreationComplete, @NotNull String shopAlreadyExists, @NotNull String shopSignBuyRow, @NotNull String shopSignSellRow) {
            Intrinsics.checkNotNullParameter((Object)emptyChest, (String)"emptyChest");
            Intrinsics.checkNotNullParameter((Object)mismatchedItems, (String)"mismatchedItems");
            Intrinsics.checkNotNullParameter((Object)shopCreationInProgress, (String)"shopCreationInProgress");
            Intrinsics.checkNotNullParameter((Object)shopCreationStarted, (String)"shopCreationStarted");
            Intrinsics.checkNotNullParameter((Object)shopCreationSelectType, (String)"shopCreationSelectType");
            Intrinsics.checkNotNullParameter((Object)shopCreationSetPrice, (String)"shopCreationSetPrice");
            Intrinsics.checkNotNullParameter((Object)shopCreationSetSellBudget, (String)"shopCreationSetSellBudget");
            Intrinsics.checkNotNullParameter((Object)shopCreationTimeout, (String)"shopCreationTimeout");
            Intrinsics.checkNotNullParameter((Object)shopCreationCancelled, (String)"shopCreationCancelled");
            Intrinsics.checkNotNullParameter((Object)shopCreationComplete, (String)"shopCreationComplete");
            Intrinsics.checkNotNullParameter((Object)shopAlreadyExists, (String)"shopAlreadyExists");
            Intrinsics.checkNotNullParameter((Object)shopSignBuyRow, (String)"shopSignBuyRow");
            Intrinsics.checkNotNullParameter((Object)shopSignSellRow, (String)"shopSignSellRow");
            this.emptyChest = emptyChest;
            this.mismatchedItems = mismatchedItems;
            this.shopCreationInProgress = shopCreationInProgress;
            this.shopCreationStarted = shopCreationStarted;
            this.shopCreationSelectType = shopCreationSelectType;
            this.shopCreationSetPrice = shopCreationSetPrice;
            this.shopCreationSetSellBudget = shopCreationSetSellBudget;
            this.shopCreationTimeout = shopCreationTimeout;
            this.shopCreationCancelled = shopCreationCancelled;
            this.shopCreationComplete = shopCreationComplete;
            this.shopAlreadyExists = shopAlreadyExists;
            this.shopSignBuyRow = shopSignBuyRow;
            this.shopSignSellRow = shopSignSellRow;
        }

        public /* synthetic */ Creator(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "<red>The chest is empty!</red>";
            }
            if ((n & 2) != 0) {
                string2 = "<red>The chest contains mismatched items!</red>";
            }
            if ((n & 4) != 0) {
                string3 = "<red>Shop creation already in progress!</red>";
            }
            if ((n & 8) != 0) {
                string4 = "<green>Shop creation started!</green>";
            }
            if ((n & 0x10) != 0) {
                string5 = "<aqua>Select shop type:</aqua> <green><click:run_command:'/chestshop settype buy'>[BUY]</click></green> or <red><click:run_command:'/chestshop settype sell'>[SELL]</click></red>";
            }
            if ((n & 0x20) != 0) {
                string6 = "<aqua>Click <green><click:suggest_command:'/chestshop setprice '>[HERE]</click></green> to set a price.";
            }
            if ((n & 0x40) != 0) {
                string7 = "<aqua>Click <green><click:suggest_command:'/chestshop setsellbudget '>[HERE]</click></green> to set a sell budget.";
            }
            if ((n & 0x80) != 0) {
                string8 = "<red>Shop creation session timed out!</red>";
            }
            if ((n & 0x100) != 0) {
                string9 = "<red>Shop creation session cancelled!</red>";
            }
            if ((n & 0x200) != 0) {
                string10 = "<green>Shop created!</green>";
            }
            if ((n & 0x400) != 0) {
                string11 = "<red>A shop already exists here!</red>";
            }
            if ((n & 0x800) != 0) {
                string12 = "<green>[BUY]</green>";
            }
            if ((n & 0x1000) != 0) {
                string13 = "<red>[SELL]</red>";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13);
        }

        @NotNull
        public final String getEmptyChest() {
            return this.emptyChest;
        }

        @NotNull
        public final String getMismatchedItems() {
            return this.mismatchedItems;
        }

        @NotNull
        public final String getShopCreationInProgress() {
            return this.shopCreationInProgress;
        }

        @NotNull
        public final String getShopCreationStarted() {
            return this.shopCreationStarted;
        }

        @NotNull
        public final String getShopCreationSelectType() {
            return this.shopCreationSelectType;
        }

        @NotNull
        public final String getShopCreationSetPrice() {
            return this.shopCreationSetPrice;
        }

        @NotNull
        public final String getShopCreationSetSellBudget() {
            return this.shopCreationSetSellBudget;
        }

        @NotNull
        public final String getShopCreationTimeout() {
            return this.shopCreationTimeout;
        }

        @NotNull
        public final String getShopCreationCancelled() {
            return this.shopCreationCancelled;
        }

        @NotNull
        public final String getShopCreationComplete() {
            return this.shopCreationComplete;
        }

        @NotNull
        public final String getShopAlreadyExists() {
            return this.shopAlreadyExists;
        }

        @NotNull
        public final String getShopSignBuyRow() {
            return this.shopSignBuyRow;
        }

        @NotNull
        public final String getShopSignSellRow() {
            return this.shopSignSellRow;
        }

        @NotNull
        public final String component1() {
            return this.emptyChest;
        }

        @NotNull
        public final String component2() {
            return this.mismatchedItems;
        }

        @NotNull
        public final String component3() {
            return this.shopCreationInProgress;
        }

        @NotNull
        public final String component4() {
            return this.shopCreationStarted;
        }

        @NotNull
        public final String component5() {
            return this.shopCreationSelectType;
        }

        @NotNull
        public final String component6() {
            return this.shopCreationSetPrice;
        }

        @NotNull
        public final String component7() {
            return this.shopCreationSetSellBudget;
        }

        @NotNull
        public final String component8() {
            return this.shopCreationTimeout;
        }

        @NotNull
        public final String component9() {
            return this.shopCreationCancelled;
        }

        @NotNull
        public final String component10() {
            return this.shopCreationComplete;
        }

        @NotNull
        public final String component11() {
            return this.shopAlreadyExists;
        }

        @NotNull
        public final String component12() {
            return this.shopSignBuyRow;
        }

        @NotNull
        public final String component13() {
            return this.shopSignSellRow;
        }

        @NotNull
        public final Creator copy(@NotNull String emptyChest, @NotNull String mismatchedItems, @NotNull String shopCreationInProgress, @NotNull String shopCreationStarted, @NotNull String shopCreationSelectType, @NotNull String shopCreationSetPrice, @NotNull String shopCreationSetSellBudget, @NotNull String shopCreationTimeout, @NotNull String shopCreationCancelled, @NotNull String shopCreationComplete, @NotNull String shopAlreadyExists, @NotNull String shopSignBuyRow, @NotNull String shopSignSellRow) {
            Intrinsics.checkNotNullParameter((Object)emptyChest, (String)"emptyChest");
            Intrinsics.checkNotNullParameter((Object)mismatchedItems, (String)"mismatchedItems");
            Intrinsics.checkNotNullParameter((Object)shopCreationInProgress, (String)"shopCreationInProgress");
            Intrinsics.checkNotNullParameter((Object)shopCreationStarted, (String)"shopCreationStarted");
            Intrinsics.checkNotNullParameter((Object)shopCreationSelectType, (String)"shopCreationSelectType");
            Intrinsics.checkNotNullParameter((Object)shopCreationSetPrice, (String)"shopCreationSetPrice");
            Intrinsics.checkNotNullParameter((Object)shopCreationSetSellBudget, (String)"shopCreationSetSellBudget");
            Intrinsics.checkNotNullParameter((Object)shopCreationTimeout, (String)"shopCreationTimeout");
            Intrinsics.checkNotNullParameter((Object)shopCreationCancelled, (String)"shopCreationCancelled");
            Intrinsics.checkNotNullParameter((Object)shopCreationComplete, (String)"shopCreationComplete");
            Intrinsics.checkNotNullParameter((Object)shopAlreadyExists, (String)"shopAlreadyExists");
            Intrinsics.checkNotNullParameter((Object)shopSignBuyRow, (String)"shopSignBuyRow");
            Intrinsics.checkNotNullParameter((Object)shopSignSellRow, (String)"shopSignSellRow");
            return new Creator(emptyChest, mismatchedItems, shopCreationInProgress, shopCreationStarted, shopCreationSelectType, shopCreationSetPrice, shopCreationSetSellBudget, shopCreationTimeout, shopCreationCancelled, shopCreationComplete, shopAlreadyExists, shopSignBuyRow, shopSignSellRow);
        }

        public static /* synthetic */ Creator copy$default(Creator creator, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n, Object object) {
            if ((n & 1) != 0) {
                string = creator.emptyChest;
            }
            if ((n & 2) != 0) {
                string2 = creator.mismatchedItems;
            }
            if ((n & 4) != 0) {
                string3 = creator.shopCreationInProgress;
            }
            if ((n & 8) != 0) {
                string4 = creator.shopCreationStarted;
            }
            if ((n & 0x10) != 0) {
                string5 = creator.shopCreationSelectType;
            }
            if ((n & 0x20) != 0) {
                string6 = creator.shopCreationSetPrice;
            }
            if ((n & 0x40) != 0) {
                string7 = creator.shopCreationSetSellBudget;
            }
            if ((n & 0x80) != 0) {
                string8 = creator.shopCreationTimeout;
            }
            if ((n & 0x100) != 0) {
                string9 = creator.shopCreationCancelled;
            }
            if ((n & 0x200) != 0) {
                string10 = creator.shopCreationComplete;
            }
            if ((n & 0x400) != 0) {
                string11 = creator.shopAlreadyExists;
            }
            if ((n & 0x800) != 0) {
                string12 = creator.shopSignBuyRow;
            }
            if ((n & 0x1000) != 0) {
                string13 = creator.shopSignSellRow;
            }
            return creator.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13);
        }

        @NotNull
        public String toString() {
            return "Creator(emptyChest=" + this.emptyChest + ", mismatchedItems=" + this.mismatchedItems + ", shopCreationInProgress=" + this.shopCreationInProgress + ", shopCreationStarted=" + this.shopCreationStarted + ", shopCreationSelectType=" + this.shopCreationSelectType + ", shopCreationSetPrice=" + this.shopCreationSetPrice + ", shopCreationSetSellBudget=" + this.shopCreationSetSellBudget + ", shopCreationTimeout=" + this.shopCreationTimeout + ", shopCreationCancelled=" + this.shopCreationCancelled + ", shopCreationComplete=" + this.shopCreationComplete + ", shopAlreadyExists=" + this.shopAlreadyExists + ", shopSignBuyRow=" + this.shopSignBuyRow + ", shopSignSellRow=" + this.shopSignSellRow + ")";
        }

        public int hashCode() {
            int result = this.emptyChest.hashCode();
            result = result * 31 + this.mismatchedItems.hashCode();
            result = result * 31 + this.shopCreationInProgress.hashCode();
            result = result * 31 + this.shopCreationStarted.hashCode();
            result = result * 31 + this.shopCreationSelectType.hashCode();
            result = result * 31 + this.shopCreationSetPrice.hashCode();
            result = result * 31 + this.shopCreationSetSellBudget.hashCode();
            result = result * 31 + this.shopCreationTimeout.hashCode();
            result = result * 31 + this.shopCreationCancelled.hashCode();
            result = result * 31 + this.shopCreationComplete.hashCode();
            result = result * 31 + this.shopAlreadyExists.hashCode();
            result = result * 31 + this.shopSignBuyRow.hashCode();
            result = result * 31 + this.shopSignSellRow.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Creator)) {
                return false;
            }
            Creator creator = (Creator)other;
            if (!Intrinsics.areEqual((Object)this.emptyChest, (Object)creator.emptyChest)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mismatchedItems, (Object)creator.mismatchedItems)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationInProgress, (Object)creator.shopCreationInProgress)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationStarted, (Object)creator.shopCreationStarted)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationSelectType, (Object)creator.shopCreationSelectType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationSetPrice, (Object)creator.shopCreationSetPrice)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationSetSellBudget, (Object)creator.shopCreationSetSellBudget)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationTimeout, (Object)creator.shopCreationTimeout)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationCancelled, (Object)creator.shopCreationCancelled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopCreationComplete, (Object)creator.shopCreationComplete)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopAlreadyExists, (Object)creator.shopAlreadyExists)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopSignBuyRow, (Object)creator.shopSignBuyRow)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.shopSignSellRow, (Object)creator.shopSignSellRow);
        }

        public Creator() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u000eJ`\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b\"\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b#\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b$\u0010\u000eR\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b%\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b&\u0010\u000eR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010 \u001a\u0004\b'\u0010\u000eR\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010 \u001a\u0004\b(\u0010\u000e\u00a8\u0006)"}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;", "", "", "noPermission", "doubleChest", "shopOutOfBudget", "ownShop", "notEnoughItem", "chestFull", "shopRemoved", "unclaimedBalance", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getNoPermission", "getDoubleChest", "getShopOutOfBudget", "getOwnShop", "getNotEnoughItem", "getChestFull", "getShopRemoved", "getUnclaimedBalance", "common"})
    public static final class Interactions {
        @NotNull
        private final String noPermission;
        @NotNull
        private final String doubleChest;
        @NotNull
        private final String shopOutOfBudget;
        @NotNull
        private final String ownShop;
        @NotNull
        private final String notEnoughItem;
        @NotNull
        private final String chestFull;
        @NotNull
        private final String shopRemoved;
        @NotNull
        private final String unclaimedBalance;

        public Interactions(@NotNull String noPermission, @NotNull String doubleChest, @NotNull String shopOutOfBudget, @NotNull String ownShop, @NotNull String notEnoughItem, @NotNull String chestFull, @NotNull String shopRemoved, @NotNull String unclaimedBalance) {
            Intrinsics.checkNotNullParameter((Object)noPermission, (String)"noPermission");
            Intrinsics.checkNotNullParameter((Object)doubleChest, (String)"doubleChest");
            Intrinsics.checkNotNullParameter((Object)shopOutOfBudget, (String)"shopOutOfBudget");
            Intrinsics.checkNotNullParameter((Object)ownShop, (String)"ownShop");
            Intrinsics.checkNotNullParameter((Object)notEnoughItem, (String)"notEnoughItem");
            Intrinsics.checkNotNullParameter((Object)chestFull, (String)"chestFull");
            Intrinsics.checkNotNullParameter((Object)shopRemoved, (String)"shopRemoved");
            Intrinsics.checkNotNullParameter((Object)unclaimedBalance, (String)"unclaimedBalance");
            this.noPermission = noPermission;
            this.doubleChest = doubleChest;
            this.shopOutOfBudget = shopOutOfBudget;
            this.ownShop = ownShop;
            this.notEnoughItem = notEnoughItem;
            this.chestFull = chestFull;
            this.shopRemoved = shopRemoved;
            this.unclaimedBalance = unclaimedBalance;
        }

        public /* synthetic */ Interactions(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "<red>You do not have permission to do that!</red>";
            }
            if ((n & 2) != 0) {
                string2 = "<red>Double chests are not supported!</red>";
            }
            if ((n & 4) != 0) {
                string3 = "<red>Shop ran out of budget!</red>";
            }
            if ((n & 8) != 0) {
                string4 = "<red>You cannot buy from your own shop!</red>";
            }
            if ((n & 0x10) != 0) {
                string5 = "<red>You do not have enough items!</red>";
            }
            if ((n & 0x20) != 0) {
                string6 = "<red>The chest is full!</red>";
            }
            if ((n & 0x40) != 0) {
                string7 = "<red>Shop removed!</red>";
            }
            if ((n & 0x80) != 0) {
                string8 = "<color:#ff99be>You have unclaimed chest shop balance. Type /chestshop or click <color:#2fff24><u><click:run_command:'/chestshop'>[HERE]</click></u></color></color>";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @NotNull
        public final String getNoPermission() {
            return this.noPermission;
        }

        @NotNull
        public final String getDoubleChest() {
            return this.doubleChest;
        }

        @NotNull
        public final String getShopOutOfBudget() {
            return this.shopOutOfBudget;
        }

        @NotNull
        public final String getOwnShop() {
            return this.ownShop;
        }

        @NotNull
        public final String getNotEnoughItem() {
            return this.notEnoughItem;
        }

        @NotNull
        public final String getChestFull() {
            return this.chestFull;
        }

        @NotNull
        public final String getShopRemoved() {
            return this.shopRemoved;
        }

        @NotNull
        public final String getUnclaimedBalance() {
            return this.unclaimedBalance;
        }

        @NotNull
        public final String component1() {
            return this.noPermission;
        }

        @NotNull
        public final String component2() {
            return this.doubleChest;
        }

        @NotNull
        public final String component3() {
            return this.shopOutOfBudget;
        }

        @NotNull
        public final String component4() {
            return this.ownShop;
        }

        @NotNull
        public final String component5() {
            return this.notEnoughItem;
        }

        @NotNull
        public final String component6() {
            return this.chestFull;
        }

        @NotNull
        public final String component7() {
            return this.shopRemoved;
        }

        @NotNull
        public final String component8() {
            return this.unclaimedBalance;
        }

        @NotNull
        public final Interactions copy(@NotNull String noPermission, @NotNull String doubleChest, @NotNull String shopOutOfBudget, @NotNull String ownShop, @NotNull String notEnoughItem, @NotNull String chestFull, @NotNull String shopRemoved, @NotNull String unclaimedBalance) {
            Intrinsics.checkNotNullParameter((Object)noPermission, (String)"noPermission");
            Intrinsics.checkNotNullParameter((Object)doubleChest, (String)"doubleChest");
            Intrinsics.checkNotNullParameter((Object)shopOutOfBudget, (String)"shopOutOfBudget");
            Intrinsics.checkNotNullParameter((Object)ownShop, (String)"ownShop");
            Intrinsics.checkNotNullParameter((Object)notEnoughItem, (String)"notEnoughItem");
            Intrinsics.checkNotNullParameter((Object)chestFull, (String)"chestFull");
            Intrinsics.checkNotNullParameter((Object)shopRemoved, (String)"shopRemoved");
            Intrinsics.checkNotNullParameter((Object)unclaimedBalance, (String)"unclaimedBalance");
            return new Interactions(noPermission, doubleChest, shopOutOfBudget, ownShop, notEnoughItem, chestFull, shopRemoved, unclaimedBalance);
        }

        public static /* synthetic */ Interactions copy$default(Interactions interactions, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, Object object) {
            if ((n & 1) != 0) {
                string = interactions.noPermission;
            }
            if ((n & 2) != 0) {
                string2 = interactions.doubleChest;
            }
            if ((n & 4) != 0) {
                string3 = interactions.shopOutOfBudget;
            }
            if ((n & 8) != 0) {
                string4 = interactions.ownShop;
            }
            if ((n & 0x10) != 0) {
                string5 = interactions.notEnoughItem;
            }
            if ((n & 0x20) != 0) {
                string6 = interactions.chestFull;
            }
            if ((n & 0x40) != 0) {
                string7 = interactions.shopRemoved;
            }
            if ((n & 0x80) != 0) {
                string8 = interactions.unclaimedBalance;
            }
            return interactions.copy(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @NotNull
        public String toString() {
            return "Interactions(noPermission=" + this.noPermission + ", doubleChest=" + this.doubleChest + ", shopOutOfBudget=" + this.shopOutOfBudget + ", ownShop=" + this.ownShop + ", notEnoughItem=" + this.notEnoughItem + ", chestFull=" + this.chestFull + ", shopRemoved=" + this.shopRemoved + ", unclaimedBalance=" + this.unclaimedBalance + ")";
        }

        public int hashCode() {
            int result = this.noPermission.hashCode();
            result = result * 31 + this.doubleChest.hashCode();
            result = result * 31 + this.shopOutOfBudget.hashCode();
            result = result * 31 + this.ownShop.hashCode();
            result = result * 31 + this.notEnoughItem.hashCode();
            result = result * 31 + this.chestFull.hashCode();
            result = result * 31 + this.shopRemoved.hashCode();
            result = result * 31 + this.unclaimedBalance.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Interactions)) {
                return false;
            }
            Interactions interactions = (Interactions)other;
            if (!Intrinsics.areEqual((Object)this.noPermission, (Object)interactions.noPermission)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.doubleChest, (Object)interactions.doubleChest)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopOutOfBudget, (Object)interactions.shopOutOfBudget)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ownShop, (Object)interactions.ownShop)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.notEnoughItem, (Object)interactions.notEnoughItem)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chestFull, (Object)interactions.chestFull)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shopRemoved, (Object)interactions.shopRemoved)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.unclaimedBalance, (Object)interactions.unclaimedBalance);
        }

        public Interactions() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f\u00a8\u0006 "}, d2={"Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;", "", "", "prefix", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;", "creator", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;", "interactions", "<init>", "(Ljava/lang/String;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;)V", "component1", "()Ljava/lang/String;", "component2", "()Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;", "component3", "()Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;", "copy", "(Ljava/lang/String;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;)Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Message;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getPrefix", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Creator;", "getCreator", "Ltech/sethi/pebbles/chestshop/util/ConfigHandler$Interactions;", "getInteractions", "common"})
    public static final class Message {
        @NotNull
        private final String prefix;
        @NotNull
        private final Creator creator;
        @NotNull
        private final Interactions interactions;

        public Message(@NotNull String prefix, @NotNull Creator creator, @NotNull Interactions interactions) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            Intrinsics.checkNotNullParameter((Object)interactions, (String)"interactions");
            this.prefix = prefix;
            this.creator = creator;
            this.interactions = interactions;
        }

        public /* synthetic */ Message(String string, Creator creator, Interactions interactions, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "<green>[ChestShop]</green>";
            }
            if ((n & 2) != 0) {
                creator = new Creator(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
            }
            if ((n & 4) != 0) {
                interactions = new Interactions(null, null, null, null, null, null, null, null, 255, null);
            }
            this(string, creator, interactions);
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final Creator getCreator() {
            return this.creator;
        }

        @NotNull
        public final Interactions getInteractions() {
            return this.interactions;
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        @NotNull
        public final Creator component2() {
            return this.creator;
        }

        @NotNull
        public final Interactions component3() {
            return this.interactions;
        }

        @NotNull
        public final Message copy(@NotNull String prefix, @NotNull Creator creator, @NotNull Interactions interactions) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            Intrinsics.checkNotNullParameter((Object)interactions, (String)"interactions");
            return new Message(prefix, creator, interactions);
        }

        public static /* synthetic */ Message copy$default(Message message, String string, Creator creator, Interactions interactions, int n, Object object) {
            if ((n & 1) != 0) {
                string = message.prefix;
            }
            if ((n & 2) != 0) {
                creator = message.creator;
            }
            if ((n & 4) != 0) {
                interactions = message.interactions;
            }
            return message.copy(string, creator, interactions);
        }

        @NotNull
        public String toString() {
            return "Message(prefix=" + this.prefix + ", creator=" + this.creator + ", interactions=" + this.interactions + ")";
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = result * 31 + this.creator.hashCode();
            result = result * 31 + this.interactions.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Message)) {
                return false;
            }
            Message message = (Message)other;
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)message.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creator, (Object)message.creator)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.interactions, (Object)message.interactions);
        }

        public Message() {
            this(null, null, null, 7, null);
        }
    }
}

