/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.NotNull;
import tech.sethi.pebbles.chestshop.ChestShop;
import tech.sethi.pebbles.chestshop.economy.IEconomy;
import tech.sethi.pebbles.chestshop.screenhandlers.ShopOverviewScreenHandlerKt;
import tech.sethi.pebbles.chestshop.shop.BalanceHandler;
import tech.sethi.pebbles.chestshop.shop.Shop;
import tech.sethi.pebbles.chestshop.shop.ShopCreationSession;
import tech.sethi.pebbles.chestshop.shop.ShopCreationState;
import tech.sethi.pebbles.chestshop.shop.ShopCreator;
import tech.sethi.pebbles.chestshop.shop.ShopItem;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;
import tech.sethi.pebbles.chestshop.util.PermUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ltech/sethi/pebbles/chestshop/commands/ChestShopCommands;", "", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "<init>", "()V", "common"})
public final class ChestShopCommands {
    @NotNull
    public static final ChestShopCommands INSTANCE = new ChestShopCommands();

    private ChestShopCommands() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder chestShopCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"chestshop").executes(ChestShopCommands::register$lambda$1);
        LiteralArgumentBuilder chestShopReloadCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(ChestShopCommands::register$lambda$2)).executes(ChestShopCommands::register$lambda$4);
        LiteralArgumentBuilder chestShopSetTypeCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"settype").then(class_2170.method_9244((String)"type", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(ChestShopCommands::register$lambda$9));
        LiteralArgumentBuilder chestShopSetPriceCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"setprice").then(class_2170.method_9244((String)"price", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)1000000000))).executes(ChestShopCommands::register$lambda$16));
        LiteralArgumentBuilder chestShopSetSellBudget = (LiteralArgumentBuilder)class_2170.method_9247((String)"setsellbudget").then(class_2170.method_9244((String)"budget", (ArgumentType)((ArgumentType)IntegerArgumentType.integer())).executes(ChestShopCommands::register$lambda$22));
        LiteralArgumentBuilder chestShopCancelCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"cancel").executes(ChestShopCommands::register$lambda$27);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)chestShopCommand.then((ArgumentBuilder)chestShopReloadCommand)).then((ArgumentBuilder)chestShopSetTypeCommand)).then((ArgumentBuilder)chestShopSetPriceCommand)).then((ArgumentBuilder)chestShopSetSellBudget)).then((ArgumentBuilder)chestShopCancelCommand));
    }

    private static final class_2561 register$lambda$1$lambda$0() {
        return PM.INSTANCE.returnStyledText("<red>Only players can use this command</red>");
    }

    private static final int register$lambda$1(CommandContext context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 class_32222 = ((class_2168)context.getSource()).method_44023();
            Intrinsics.checkNotNull((Object)class_32222);
            class_3222 player = class_32222;
            player.method_17355((class_3908)ShopOverviewScreenHandlerKt.getShopOverviewScreenHandlerFactory());
        } else {
            ((class_2168)context.getSource()).method_9226(ChestShopCommands::register$lambda$1$lambda$0, false);
        }
        return 1;
    }

    private static final boolean register$lambda$2(class_2168 source) {
        Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
        return PermUtil.INSTANCE.commandRequiresPermission(source, "pebbles.chestshop.reload");
    }

    private static final class_2561 register$lambda$4$lambda$3() {
        return PM.INSTANCE.returnStyledText("<blue>Reloaded ChestShop shops and config!");
    }

    private static final int register$lambda$4(CommandContext context) {
        class_2168 source = (class_2168)context.getSource();
        ShopCreator.INSTANCE.reloadAllShops();
        ConfigHandler.INSTANCE.reload();
        source.method_9226(ChestShopCommands::register$lambda$4$lambda$3, false);
        return 1;
    }

    private static final class_2561 register$lambda$9$lambda$6$lambda$5() {
        return PM.INSTANCE.returnStyledText("<red>Only players can use this command</red>");
    }

    private static final class_2561 register$lambda$9$lambda$7() {
        return PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationSetPrice());
    }

    private static final class_2561 register$lambda$9$lambda$8() {
        return PM.INSTANCE.returnStyledText("<red>Invalid shop creation state or no session exists</red>");
    }

    private static final int register$lambda$9(CommandContext context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            int n;
            int it = n = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$9$lambda$6$lambda$5, false);
            return n;
        }
        class_3222 player = class_32222;
        ShopCreationSession session = ShopCreator.INSTANCE.getSessions().get(player.method_5845());
        String type = StringArgumentType.getString((CommandContext)context, (String)"type");
        if (session != null && session.getState() == ShopCreationState.SELECT_TYPE) {
            Shop shop = session.getShop();
            Intrinsics.checkNotNull((Object)shop);
            shop.getShopItem().setType(type);
            session.setState(ShopCreationState.SET_PRICE);
            source.method_9226(ChestShopCommands::register$lambda$9$lambda$7, false);
        } else {
            source.method_9226(ChestShopCommands::register$lambda$9$lambda$8, false);
        }
        return 1;
    }

    private static final class_2561 register$lambda$16$lambda$11$lambda$10() {
        return PM.INSTANCE.returnStyledText("<red>Only players can use this command</red>");
    }

    private static final class_2561 register$lambda$16$lambda$13$lambda$12() {
        return PM.INSTANCE.returnStyledText("<red>Invalid shop creation state or no session exists</red>");
    }

    private static final class_2561 register$lambda$16$lambda$14() {
        return PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationSetSellBudget());
    }

    private static final class_2561 register$lambda$16$lambda$15() {
        return PM.INSTANCE.returnStyledText("<red>Invalid shop creation state or no session exists</red>");
    }

    private static final int register$lambda$16(CommandContext context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            int n;
            int it = n = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$16$lambda$11$lambda$10, false);
            return n;
        }
        class_3222 player = class_32222;
        int price = IntegerArgumentType.getInteger((CommandContext)context, (String)"price");
        ShopCreationSession shopCreationSession = ShopCreator.INSTANCE.getSessions().get(player.method_5845());
        if (shopCreationSession == null) {
            int n;
            int it = n = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$16$lambda$13$lambda$12, false);
            return n;
        }
        ShopCreationSession session = shopCreationSession;
        if (session.getState() == ShopCreationState.SET_PRICE) {
            Shop shop = session.getShop();
            Intrinsics.checkNotNull((Object)shop);
            shop.getShopItem().setPrice(price);
            Shop shop2 = session.getShop();
            Intrinsics.checkNotNull((Object)shop2);
            if (Intrinsics.areEqual((Object)shop2.getShopItem().getType(), (Object)"sell")) {
                session.setState(ShopCreationState.SET_SELL_BUDGET);
                source.method_9226(ChestShopCommands::register$lambda$16$lambda$14, false);
                String string = player.method_5845();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.uuidAsString");
                ShopCreator.INSTANCE.advanceSession(string, ShopCreationState.SET_SELL_BUDGET);
            } else {
                String string = player.method_5845();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.uuidAsString");
                ShopCreator.INSTANCE.finalizeSession(string);
            }
        } else {
            source.method_9226(ChestShopCommands::register$lambda$16$lambda$15, false);
        }
        return 1;
    }

    private static final class_2561 register$lambda$22$lambda$18$lambda$17() {
        return PM.INSTANCE.returnStyledText("<red>Only players can use this command</red>");
    }

    private static final class_2561 register$lambda$22$lambda$20$lambda$19() {
        return PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>You don't have enough " + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + " to set that budget</red>");
    }

    private static final class_2561 register$lambda$22$lambda$21() {
        return PM.INSTANCE.returnStyledText("<red>Invalid shop creation state or no session exists</red>");
    }

    private static final int register$lambda$22(CommandContext context) {
        Object object;
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            int n;
            int it = n = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$22$lambda$18$lambda$17, false);
            return n;
        }
        class_3222 player = class_32222;
        IEconomy iEconomy = BalanceHandler.INSTANCE.getEconomy();
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
        double playerBal = iEconomy.getBalance(uUID);
        int budget = IntegerArgumentType.getInteger((CommandContext)context, (String)"budget");
        if ((double)budget > playerBal) {
            int it;
            int it2 = it = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$22$lambda$20$lambda$19, false);
            return it;
        }
        ShopCreationSession session = ShopCreator.INSTANCE.getSessions().get(player.method_5845());
        if (session != null && session.getState() == ShopCreationState.SET_SELL_BUDGET && ((object = session.getShop()) != null && (object = ((Shop)object).getShopItem()) != null ? ((ShopItem)object).getPrice() : null) != null) {
            IEconomy iEconomy2 = ChestShop.INSTANCE.getEconomy();
            Intrinsics.checkNotNull((Object)iEconomy2);
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"player.uuid");
            iEconomy2.withdraw(uUID2, budget);
            Shop shop = session.getShop();
            Intrinsics.checkNotNull((Object)shop);
            shop.getShopItem().setSellBudget(budget);
            session.setState(ShopCreationState.FINALIZE);
            String string = player.method_5845();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.uuidAsString");
            ShopCreator.INSTANCE.finalizeSession(string);
        } else {
            source.method_9226(ChestShopCommands::register$lambda$22$lambda$21, false);
        }
        return 1;
    }

    private static final class_2561 register$lambda$27$lambda$24$lambda$23() {
        return PM.INSTANCE.returnStyledText("<red>Only players can use this command</red>");
    }

    private static final class_2561 register$lambda$27$lambda$25() {
        return PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationCancelled());
    }

    private static final class_2561 register$lambda$27$lambda$26() {
        return PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>No active shop creation session to cancel.</red>");
    }

    private static final int register$lambda$27(CommandContext context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 class_32222 = source.method_44023();
        if (class_32222 == null) {
            int n;
            int it = n = 1;
            boolean bl = false;
            source.method_9226(ChestShopCommands::register$lambda$27$lambda$24$lambda$23, false);
            return n;
        }
        class_3222 player = class_32222;
        boolean hasSession = ShopCreator.INSTANCE.getSessions().containsKey(player.method_5845());
        String string = player.method_5845();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.uuidAsString");
        ShopCreator.INSTANCE.cancelSession(string);
        if (hasSession) {
            source.method_9226(ChestShopCommands::register$lambda$27$lambda$25, false);
        } else {
            source.method_9226(ChestShopCommands::register$lambda$27$lambda$26, false);
        }
        return 1;
    }
}

