/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.economy;

import java.math.BigDecimal;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import org.jetbrains.annotations.NotNull;
import tech.sethi.pebbles.chestshop.economy.IEconomy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Ltech/sethi/pebbles/chestshop/economy/ImpactorEconomy;", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "Ljava/util/UUID;", "playerUUID", "", "amount", "", "deposit", "(Ljava/util/UUID;D)V", "getBalance", "(Ljava/util/UUID;)D", "withdraw", "Lnet/impactdev/impactor/api/economy/EconomyService;", "iEconomy", "Lnet/impactdev/impactor/api/economy/EconomyService;", "<init>", "()V", "common"})
public final class ImpactorEconomy
implements IEconomy {
    @NotNull
    private final EconomyService iEconomy;

    public ImpactorEconomy() {
        EconomyService economyService = EconomyService.instance();
        Intrinsics.checkNotNullExpressionValue((Object)economyService, (String)"instance()");
        this.iEconomy = economyService;
    }

    @Override
    public double getBalance(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        return ((Account)this.iEconomy.account(playerUUID).get()).balance().doubleValue();
    }

    @Override
    public void withdraw(@NotNull UUID playerUUID, double amount) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Account account = (Account)this.iEconomy.account(playerUUID).get();
        account.withdraw(new BigDecimal(String.valueOf(amount)));
    }

    @Override
    public void deposit(@NotNull UUID playerUUID, double amount) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Account account = (Account)this.iEconomy.account(playerUUID).get();
        account.deposit(new BigDecimal(String.valueOf(amount)));
    }
}

