/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.events;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import tech.sethi.pebbles.chestshop.ChestShop;
import tech.sethi.pebbles.chestshop.shop.BalanceHandler;
import tech.sethi.pebbles.chestshop.shop.ProcessTransaction;
import tech.sethi.pebbles.chestshop.shop.Shop;
import tech.sethi.pebbles.chestshop.shop.ShopCreationSession;
import tech.sethi.pebbles.chestshop.shop.ShopCreationState;
import tech.sethi.pebbles.chestshop.shop.ShopCreator;
import tech.sethi.pebbles.chestshop.shop.ShopItem;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;
import tech.sethi.pebbles.chestshop.util.PermUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b \u0010\u0011J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0011J\r\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0011J\r\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0011J\r\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0011J+\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00162\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ltech/sethi/pebbles/chestshop/events/PlayerEvents;", "", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2338;", "blockPos", "", "allowOpenChest", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;)Z", "", "initiateShopCreationSession", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;)V", "Lnet/minecraft/class_2595;", "chestEntity", "isSingleChest", "(Lnet/minecraft/class_2595;)Z", "onBreak", "()V", "onPlaceChest", "onPlayerJoin", "onPlayerQuit", "onRightClick", "Lkotlin/Triple;", "", "Lnet/minecraft/class_1799;", "validateChestContents", "(Lnet/minecraft/class_2595;)Lkotlin/Triple;", "Lnet/minecraft/class_1792;", "configItem", "Lnet/minecraft/class_1792;", "getConfigItem", "()Lnet/minecraft/class_1792;", "<init>", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerEvents.kt\ntech/sethi/pebbles/chestshop/events/PlayerEvents\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n187#2,3:293\n1#3:296\n*S KotlinDebug\n*F\n+ 1 PlayerEvents.kt\ntech/sethi/pebbles/chestshop/events/PlayerEvents\n*L\n58#1:293,3\n*E\n"})
public final class PlayerEvents {
    @NotNull
    public static final PlayerEvents INSTANCE = new PlayerEvents();
    @NotNull
    private static final class_1792 configItem;

    private PlayerEvents() {
    }

    @NotNull
    public final class_1792 getConfigItem() {
        return configItem;
    }

    public final void onRightClick() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register(PlayerEvents::onRightClick$lambda$2);
    }

    public final void onBreak() {
        BlockEvent.BREAK.register(PlayerEvents::onBreak$lambda$5);
    }

    public final void onPlaceChest() {
        BlockEvent.PLACE.register(PlayerEvents::onPlaceChest$lambda$6);
    }

    public final void onPlayerJoin() {
        PlayerEvent.PLAYER_JOIN.register(PlayerEvents::onPlayerJoin$lambda$7);
    }

    public final void onPlayerQuit() {
        PlayerEvent.PLAYER_QUIT.register(PlayerEvents::onPlayerQuit$lambda$8);
    }

    private final void initiateShopCreationSession(class_3222 player, class_2338 blockPos) {
        class_2586 class_25862 = player.method_37908().method_8321(blockPos);
        Intrinsics.checkNotNull((Object)class_25862, (String)"null cannot be cast to non-null type net.minecraft.block.entity.ChestBlockEntity");
        class_2595 chestEntity = (class_2595)class_25862;
        Triple<Boolean, String, class_1799> validationResults = this.validateChestContents(chestEntity);
        if (!((Boolean)validationResults.getFirst()).booleanValue()) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + (String)validationResults.getSecond()), false);
            return;
        }
        String playerUUID = player.method_5845();
        String blockPosString = blockPos.method_23854();
        Object object = validationResults.getThird();
        Intrinsics.checkNotNull((Object)object);
        class_1799 firstItem = (class_1799)object;
        String string = class_7923.field_41178.method_10221((Object)firstItem.method_7909()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ITEM.getId(firstItem.item).toString()");
        ShopItem shopItem = new ShopItem(string, String.valueOf(firstItem.method_7969()), null, null, null, 28, null);
        ChestShop.INSTANCE.getLOGGER().info("Starting shop creation session for player " + playerUUID + " at " + blockPosString + " with item " + shopItem.getItem());
        Intrinsics.checkNotNullExpressionValue((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullExpressionValue((Object)blockPosString, (String)"blockPosString");
        ShopCreator.INSTANCE.startSession(playerUUID, blockPosString, shopItem);
        player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationStarted()), false);
        ShopCreator.INSTANCE.advanceSession(playerUUID, ShopCreationState.SELECT_TYPE);
        player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationSelectType()), false);
    }

    private final Triple<Boolean, String, class_1799> validateChestContents(class_2595 chestEntity) {
        boolean hasItems = false;
        class_1799 firstItem = null;
        boolean allItemsMatch = true;
        int n = chestEntity.method_5439();
        for (int slot = 0; slot < n; ++slot) {
            class_1799 stack = chestEntity.method_5438(slot);
            if (stack.method_7960()) continue;
            hasItems = true;
            if (firstItem == null) {
                firstItem = stack;
                continue;
            }
            if (Intrinsics.areEqual((Object)firstItem.method_7909(), (Object)stack.method_7909()) && class_1799.method_31577((class_1799)firstItem, (class_1799)stack)) continue;
            allItemsMatch = false;
            break;
        }
        return !hasItems ? new Triple((Object)false, (Object)ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getEmptyChest(), null) : (!allItemsMatch ? new Triple((Object)false, (Object)ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getMismatchedItems(), null) : new Triple((Object)true, (Object)"", firstItem));
    }

    private final boolean allowOpenChest(class_3222 player, class_2338 blockPos) {
        String chestLocation = blockPos.method_23854();
        Intrinsics.checkNotNullExpressionValue((Object)chestLocation, (String)"chestLocation");
        String string = player.method_37908().method_27983().method_29177().method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.world.registryKey.value.path");
        String chestCompoundKey = ShopCreator.INSTANCE.generateCompoundKey(chestLocation, string);
        Shop shop = ShopCreator.INSTANCE.getShops().get(chestCompoundKey);
        if (shop != null) {
            boolean bl;
            if (Intrinsics.areEqual((Object)shop.getOwner(), (Object)player.method_5845())) {
                return true;
            }
            class_2168 class_21682 = player.method_5671();
            Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"player.commandSource");
            if (PermUtil.INSTANCE.commandRequiresPermission(class_21682, "pebbles.chestshop.override")) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " Overriding shop chest protection..."), false);
                bl = true;
            } else {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getNoPermission()), false);
                bl = false;
            }
            return bl;
        }
        return true;
    }

    private final boolean isSingleChest(class_2595 chestEntity) {
        class_2680 chestState = chestEntity.method_11010();
        class_2745 chestType = (class_2745)chestState.method_11654((class_2769)class_2281.field_10770);
        return chestType == class_2745.field_12569;
    }

    private static final EventResult onRightClick$lambda$2(class_1657 player, class_1268 hand, class_2338 blockPos, class_2350 class_23502) {
        class_2680 clickedBlockState = player.method_37908().method_8320(blockPos);
        class_2248 clickedBlock = clickedBlockState.method_26204();
        class_1792 itemInHand = player.method_5998(hand).method_7909();
        if (Intrinsics.areEqual((Object)itemInHand, (Object)configItem) && Intrinsics.areEqual((Object)clickedBlock, (Object)class_2246.field_10034)) {
            boolean bl;
            block13: {
                boolean isAlreadyShop;
                class_2586 class_25862 = player.method_37908().method_8321(blockPos);
                Intrinsics.checkNotNull((Object)class_25862, (String)"null cannot be cast to non-null type net.minecraft.block.entity.ChestBlockEntity");
                class_2595 chestEntity = (class_2595)class_25862;
                String string = blockPos.method_23854();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockPos.toShortString()");
                String string2 = player.method_37908().method_27983().method_29177().method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"player.world.registryKey.value.path");
                String shopCompoundKey = ShopCreator.INSTANCE.generateCompoundKey(string, string2);
                boolean bl2 = isAlreadyShop = ShopCreator.INSTANCE.getShops().get(shopCompoundKey) != null;
                if (!INSTANCE.isSingleChest(chestEntity)) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getDoubleChest()), false);
                    return EventResult.interrupt((Boolean)false);
                }
                if (isAlreadyShop) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopAlreadyExists()), false);
                    return EventResult.interrupt((Boolean)false);
                }
                Map<String, ShopCreationSession> $this$any$iv = ShopCreator.INSTANCE.getSessions();
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Object object = $this$any$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = (Map.Entry)object.next();
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)((ShopCreationSession)it.getValue()).getPlayer(), (Object)player.method_5845())) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getCreator().getShopCreationInProgress()), false);
                return EventResult.interrupt((Boolean)false);
            }
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
            class_3222 class_32222 = (class_3222)player;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPos");
            if (PermUtil.INSTANCE.flanInteractPermission(class_32222, blockPos)) {
                INSTANCE.initiateShopCreationSession((class_3222)player, blockPos);
                return EventResult.interrupt((Boolean)false);
            }
        }
        if (Intrinsics.areEqual((Object)clickedBlock, (Object)class_2246.field_10034)) {
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
            class_3222 class_32223 = (class_3222)player;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPos");
            if (INSTANCE.allowOpenChest(class_32223, blockPos)) {
                return EventResult.pass();
            }
            return EventResult.interrupt((Boolean)false);
        }
        if (Intrinsics.areEqual((Object)clickedBlock, (Object)class_2246.field_10187)) {
            Object v7;
            block14: {
                String signLocation = blockPos.method_23854();
                Iterable iterable = ShopCreator.INSTANCE.getShops().values();
                for (Object object : iterable) {
                    Shop it = (Shop)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSignLocation(), (Object)signLocation)) continue;
                    v7 = object;
                    break block14;
                }
                v7 = null;
            }
            Shop shop = v7;
            if (shop != null) {
                ProcessTransaction processTransaction = new ProcessTransaction();
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
                processTransaction.process((class_3222)player, shop);
                player.method_7346();
                return EventResult.interrupt((Boolean)false);
            }
        }
        return EventResult.pass();
    }

    private static final EventResult onBreak$lambda$5(class_1937 world, class_2338 blockPos, class_2680 blockState, class_3222 player, IntValue exp) {
        String blockLocation = blockPos.method_23854();
        if (Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10034) || Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10187)) {
            Shop shop;
            Shop shop2;
            if (Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10034)) {
                Intrinsics.checkNotNullExpressionValue((Object)blockLocation, (String)"blockLocation");
                String string = world.method_27983().method_29177().method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"world.registryKey.value.path");
                String chestCompoundKey = ShopCreator.INSTANCE.generateCompoundKey(blockLocation, string);
                shop2 = ShopCreator.INSTANCE.getShops().get(chestCompoundKey);
            } else {
                Object v2;
                block7: {
                    Iterable iterable = ShopCreator.INSTANCE.getShops().values();
                    for (Object t : iterable) {
                        Shop it = (Shop)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSignLocation(), (Object)blockLocation)) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                shop2 = shop = (Shop)v2;
            }
            if (shop != null) {
                if (Intrinsics.areEqual((Object)shop.getOwner(), (Object)player.method_5845())) {
                    EventResult eventResult;
                    EventResult it = eventResult = EventResult.pass();
                    boolean bl = false;
                    ShopCreator.INSTANCE.deleteShop(shop);
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getShopRemoved()), false);
                    return eventResult;
                }
                class_2168 class_21682 = player.method_5671();
                Intrinsics.checkNotNullExpressionValue((Object)class_21682, (String)"player.commandSource");
                if (PermUtil.INSTANCE.commandRequiresPermission(class_21682, "pebbles.chestshop.override")) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <gray>Overriding shop chest protection...</gray>"), false);
                    ShopCreator.INSTANCE.deleteShop(shop);
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getShopRemoved()), false);
                    return EventResult.pass();
                }
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getNoPermission()), false);
                return EventResult.interrupt((Boolean)false);
            }
        }
        return EventResult.pass();
    }

    private static final EventResult onPlaceChest$lambda$6(class_1937 world, class_2338 blockPos, class_2680 blockState, class_1297 player) {
        if (blockState.method_26204() instanceof class_2281) {
            class_2338[] class_2338Array = new class_2338[]{blockPos.method_10095(), blockPos.method_10072(), blockPos.method_10078(), blockPos.method_10067()};
            List adjacentBlockPositions = CollectionsKt.listOf((Object[])class_2338Array);
            for (class_2338 adjacentBlockPos : adjacentBlockPositions) {
                class_2680 adjacentBlockState = world.method_8320(adjacentBlockPos);
                if (!(adjacentBlockState.method_26204() instanceof class_2281)) continue;
                String adjacentChestLocation = adjacentBlockPos.method_23854();
                Intrinsics.checkNotNullExpressionValue((Object)adjacentChestLocation, (String)"adjacentChestLocation");
                String string = world.method_27983().method_29177().method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"world.registryKey.value.path");
                String chestCompoundKey = ShopCreator.INSTANCE.generateCompoundKey(adjacentChestLocation, string);
                if (ShopCreator.INSTANCE.getShops().get(chestCompoundKey) == null) continue;
                class_2586 class_25862 = world.method_8321(blockPos);
                Intrinsics.checkNotNull((Object)class_25862, (String)"null cannot be cast to non-null type net.minecraft.block.entity.ChestBlockEntity");
                class_2595 chestEntity = (class_2595)class_25862;
                if (INSTANCE.isSingleChest(chestEntity)) continue;
                class_1297 class_12972 = player;
                if (class_12972 != null) {
                    class_12972.method_43496(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getDoubleChest()));
                }
                world.method_8501(blockPos, class_2246.field_10124.method_9564());
                return EventResult.interrupt((Boolean)false);
            }
        }
        return EventResult.pass();
    }

    private static final void onPlayerJoin$lambda$7(class_3222 player) {
        String playerUUID = player.method_5845();
        Intrinsics.checkNotNullExpressionValue((Object)playerUUID, (String)"playerUUID");
        double playerBalance = BalanceHandler.INSTANCE.getBalance(playerUUID);
        if (playerBalance > 0.0) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getUnclaimedBalance()), false);
        }
        EventResult.pass();
    }

    private static final void onPlayerQuit$lambda$8(class_3222 player) {
        String playerUUID = player.method_5845();
        Intrinsics.checkNotNullExpressionValue((Object)playerUUID, (String)"playerUUID");
        BalanceHandler.INSTANCE.saveBalance(playerUUID);
        EventResult.pass();
    }

    static {
        Object object = class_7923.field_41178.method_10223(class_2960.method_12829((String)ConfigHandler.INSTANCE.getConfig().getConfigItem()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(Identifier.tryP\u2026ndler.config.configItem))");
        configItem = (class_1792)object;
    }
}

