/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.shop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.sethi.pebbles.chestshop.ChestShop;
import tech.sethi.pebbles.chestshop.economy.IEconomy;
import tech.sethi.pebbles.chestshop.economy.ImpactorEconomy;
import tech.sethi.pebbles.chestshop.economy.PebblesEconomy;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b%\u0010\fJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00028\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001f\u0010!\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Ltech/sethi/pebbles/chestshop/shop/BalanceHandler;", "", "", "player", "", "amount", "", "addBalance", "(Ljava/lang/String;D)V", "getBalance", "(Ljava/lang/String;)D", "reloadAllBalances", "()V", "saveAllBalances", "saveBalance", "(Ljava/lang/String;)V", "withdrawBalance", "balanceFolder", "Ljava/lang/String;", "getBalanceFolder", "()Ljava/lang/String;", "", "balances", "Ljava/util/Map;", "getBalances", "()Ljava/util/Map;", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "economy", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "getEconomy", "()Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "<init>", "Balance", "common"})
public final class BalanceHandler {
    @NotNull
    public static final BalanceHandler INSTANCE = new BalanceHandler();
    @NotNull
    private static final Map<String, Double> balances = new LinkedHashMap();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final String balanceFolder = "config/pebbles-chestshop/balances/";
    @NotNull
    private static final IEconomy economy;

    private BalanceHandler() {
    }

    @NotNull
    public final Map<String, Double> getBalances() {
        return balances;
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final String getBalanceFolder() {
        return balanceFolder;
    }

    public final void reloadAllBalances() {
        balances.clear();
        File balanceFolderFile = new File(balanceFolder);
        if (!balanceFolderFile.exists()) {
            balanceFolderFile.mkdirs();
        } else {
            File[] balanceFiles = balanceFolderFile.listFiles();
            if (balanceFiles != null) {
                for (File balanceFile : balanceFiles) {
                    Intrinsics.checkNotNullExpressionValue((Object)balanceFile, (String)"balanceFile");
                    String balanceString = FilesKt.readText$default((File)balanceFile, null, (int)1, null);
                    Double balance = (Double)gson.fromJson(balanceString, Double.TYPE);
                    String uuid = FilesKt.getNameWithoutExtension((File)balanceFile);
                    Intrinsics.checkNotNullExpressionValue((Object)balance, (String)"balance");
                    balances.put(uuid, balance);
                }
            }
        }
    }

    public final void saveBalance(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Double d = balances.get(player);
        if (d == null) {
            return;
        }
        double balance = d;
        File balanceFile = new File(balanceFolder + player + ".json");
        String balanceString = gson.toJson((Object)balance);
        Intrinsics.checkNotNullExpressionValue((Object)balanceString, (String)"balanceString");
        FilesKt.writeText$default((File)balanceFile, (String)balanceString, null, (int)2, null);
    }

    public final void saveAllBalances() {
        Iterator<Map.Entry<String, Double>> iterator = balances.entrySet().iterator();
        while (iterator.hasNext()) {
            String uuid = iterator.next().getKey();
            this.saveBalance(uuid);
        }
    }

    @NotNull
    public final IEconomy getEconomy() {
        return economy;
    }

    public final double getBalance(@NotNull String player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Double d = balances.get(player);
        return d != null ? d : 0.0;
    }

    public final void addBalance(@NotNull String player, double amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        balances.put(player, this.getBalance(player) + amount);
    }

    public final synchronized void withdrawBalance(@NotNull String player) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                double balance = this.getBalance(player);
                if (!(balance > 0.0)) break block1;
                UUID uUID = UUID.fromString(player);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(player)");
                economy.deposit(uUID, balance);
                MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
                Intrinsics.checkNotNull((Object)minecraftServer);
                class_3222 class_32222 = minecraftServer.method_3760().method_14602(UUID.fromString(player));
                if (class_32222 != null) {
                    class_32222.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " You have withdrawn " + balance + ' ' + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + " from your chest shop balance."), false);
                }
                balances.put(player, 0.0);
                break block2;
            }
            MinecraftServer minecraftServer = ChestShop.INSTANCE.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            class_3222 class_32223 = minecraftServer.method_3760().method_14602(UUID.fromString(player));
            if (class_32223 == null) break block2;
            class_32223.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>You have no balance to withdraw."), false);
        }
    }

    static {
        File balanceFolderFile = new File(balanceFolder);
        if (!balanceFolderFile.exists()) {
            balanceFolderFile.mkdirs();
        } else {
            INSTANCE.reloadAllBalances();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        while (true) {
                            INSTANCE.saveAllBalances();
                            Thread.sleep(300000L);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        String string = ConfigHandler.INSTANCE.getConfig().getEconomy();
        economy = Intrinsics.areEqual((Object)string, (Object)"pebbleseconomy") ? (IEconomy)new PebblesEconomy() : (Intrinsics.areEqual((Object)string, (Object)"impactor") ? (IEconomy)new ImpactorEconomy() : (IEconomy)new PebblesEconomy());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u001a"}, d2={"Ltech/sethi/pebbles/chestshop/shop/BalanceHandler$Balance;", "", "", "component1", "()Ljava/lang/String;", "", "component2", "()D", "uuid", "balance", "copy", "(Ljava/lang/String;D)Ltech/sethi/pebbles/chestshop/shop/BalanceHandler$Balance;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "D", "getBalance", "Ljava/lang/String;", "getUuid", "<init>", "(Ljava/lang/String;D)V", "common"})
    public static final class Balance {
        @NotNull
        private final String uuid;
        private final double balance;

        public Balance(@NotNull String uuid, double balance) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.balance = balance;
        }

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        public final double getBalance() {
            return this.balance;
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        public final double component2() {
            return this.balance;
        }

        @NotNull
        public final Balance copy(@NotNull String uuid, double balance) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new Balance(uuid, balance);
        }

        public static /* synthetic */ Balance copy$default(Balance balance, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = balance.uuid;
            }
            if ((n & 2) != 0) {
                d = balance.balance;
            }
            return balance.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "Balance(uuid=" + this.uuid + ", balance=" + this.balance + ')';
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Double.hashCode(this.balance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Balance)) {
                return false;
            }
            Balance balance = (Balance)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)balance.uuid)) {
                return false;
            }
            return Double.compare(this.balance, balance.balance) == 0;
        }
    }
}

