/*
 * Decompiled with CFR 0.152.
 */
package tech.sethi.pebbles.chestshop.shop;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.sethi.pebbles.chestshop.economy.IEconomy;
import tech.sethi.pebbles.chestshop.economy.ImpactorEconomy;
import tech.sethi.pebbles.chestshop.economy.PebblesEconomy;
import tech.sethi.pebbles.chestshop.shop.BalanceHandler;
import tech.sethi.pebbles.chestshop.shop.Shop;
import tech.sethi.pebbles.chestshop.shop.ShopItem;
import tech.sethi.pebbles.chestshop.util.ConfigHandler;
import tech.sethi.pebbles.chestshop.util.PM;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006("}, d2={"Ltech/sethi/pebbles/chestshop/shop/ProcessTransaction;", "", "Lnet/minecraft/class_2595;", "chestBlockEntity", "Lnet/minecraft/class_1799;", "itemStack", "", "chestHasEnoughItems", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)Z", "chestHasEnoughSpace", "Ltech/sethi/pebbles/chestshop/shop/Shop;", "shop", "", "deductBudget", "(Ltech/sethi/pebbles/chestshop/shop/Shop;)V", "deleteItemFromChest", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_1661;", "inventory", "giveItemsToPlayer", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)V", "hasEnoughItems", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)Z", "insertItemIntoChest", "(Lnet/minecraft/class_2595;Lnet/minecraft/class_1799;)V", "Lnet/minecraft/class_3222;", "player", "process", "(Lnet/minecraft/class_3222;Ltech/sethi/pebbles/chestshop/shop/Shop;)V", "removeItemsFromInventory", "(Lnet/minecraft/class_1661;Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "shopHasBudget", "(Ltech/sethi/pebbles/chestshop/shop/Shop;)Z", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "economy", "Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "getEconomy", "()Ltech/sethi/pebbles/chestshop/economy/IEconomy;", "<init>", "()V", "common"})
@SourceDebugExtension(value={"SMAP\nProcessTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessTransaction.kt\ntech/sethi/pebbles/chestshop/shop/ProcessTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public final class ProcessTransaction {
    @NotNull
    private final IEconomy economy;

    public ProcessTransaction() {
        String string = ConfigHandler.INSTANCE.getConfig().getEconomy();
        this.economy = Intrinsics.areEqual((Object)string, (Object)"pebbleseconomy") ? (IEconomy)new PebblesEconomy() : (Intrinsics.areEqual((Object)string, (Object)"impactor") ? (IEconomy)new ImpactorEconomy() : (IEconomy)new PebblesEconomy());
    }

    @NotNull
    public final IEconomy getEconomy() {
        return this.economy;
    }

    public final synchronized void process(@NotNull class_3222 player, @NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)player.method_5845(), (Object)shop.getOwner())) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getOwnShop()), false);
            return;
        }
        if (shop.getShopItem().getPrice() != null) {
            Integer n = shop.getShopItem().getPrice();
            Intrinsics.checkNotNull((Object)n);
            if (n <= 0) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>This shop has an invalid price and cannot be used.</red>"), false);
                return;
            }
        }
        class_1661 playerInv = player.method_31548();
        class_2960 class_29602 = class_2960.method_12829((String)shop.getShopItem().getItem());
        if (class_29602 == null) {
            return;
        }
        class_2960 shopIdentifier = class_29602;
        Object object = class_7923.field_41178.method_10223(shopIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(shopIdentifier)");
        class_1792 shopItem = (class_1792)object;
        class_1799 shopItemStack = new class_1799((class_1935)shopItem, 1);
        if (!(Intrinsics.areEqual((Object)shop.getShopItem().getNbt(), (Object)"null") || Intrinsics.areEqual((Object)shop.getShopItem().getNbt(), (Object)"") || Intrinsics.areEqual((Object)shop.getShopItem().getNbt(), (Object)"{}"))) {
            shopItemStack.method_7980(class_2522.method_10718((String)shop.getShopItem().getNbt()));
        }
        String[] stringArray = new String[]{", "};
        List chestLocation = StringsKt.split$default((CharSequence)shop.getChestLocation(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        class_2586 chestEntity = player.method_37908().method_8321(new class_2338(Integer.parseInt((String)chestLocation.get(0)), Integer.parseInt((String)chestLocation.get(1)), Integer.parseInt((String)chestLocation.get(2))));
        class_2586 class_25862 = chestEntity;
        if ((class_25862 != null && (class_25862 = class_25862.method_11010()) != null ? (class_2745)class_25862.method_11654((class_2769)class_2281.field_10770) : null) != class_2745.field_12569) {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " Shop is malformed."), false);
            return;
        }
        Intrinsics.checkNotNull((Object)chestEntity, (String)"null cannot be cast to non-null type net.minecraft.block.entity.ChestBlockEntity");
        class_2595 cfr_ignored_0 = (class_2595)chestEntity;
        String string = shop.getShopItem().getType();
        if (Intrinsics.areEqual((Object)string, (Object)"sell")) {
            if (ConfigHandler.INSTANCE.isBuyingBlacklisted(shop.getShopItem().getItem())) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Buying this item from players is blacklisted.</red>"), false);
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)playerInv, (String)"playerInv");
            if (this.hasEnoughItems(playerInv, shopItemStack) && this.chestHasEnoughSpace((class_2595)chestEntity, shopItemStack) && this.shopHasBudget(shop)) {
                class_1799 removedStack = this.removeItemsFromInventory(playerInv, shopItemStack);
                if (removedStack != null) {
                    this.insertItemIntoChest((class_2595)chestEntity, removedStack);
                    this.deductBudget(shop);
                    UUID uUID = player.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
                    Integer n = shop.getShopItem().getPrice();
                    Intrinsics.checkNotNull((Object)n);
                    this.economy.deposit(uUID, n.intValue());
                    StringBuilder stringBuilder = new StringBuilder().append(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix()).append(" Sold item for ");
                    Integer n2 = shop.getShopItem().getPrice();
                    Intrinsics.checkNotNull((Object)n2);
                    player.method_7353(PM.INSTANCE.returnStyledText(stringBuilder.append(n2).append(' ').append(ConfigHandler.INSTANCE.getConfig().getCurrencyName()).append('.').toString()), false);
                } else {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getNotEnoughItem()), false);
                }
            } else if (!this.hasEnoughItems(playerInv, shopItemStack)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getNotEnoughItem()), false);
            } else if (!this.chestHasEnoughSpace((class_2595)chestEntity, shopItemStack)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getChestFull()), false);
            } else if (!this.shopHasBudget(shop)) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + ' ' + ConfigHandler.INSTANCE.getConfig().getMessage().getInteractions().getShopOutOfBudget()), false);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"buy")) {
            if (ConfigHandler.INSTANCE.isSellingBlacklisted(shop.getShopItem().getItem())) {
                player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Selling this item to players is blacklisted.</red>"), false);
                return;
            }
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
            double d = this.economy.getBalance(uUID);
            Integer n = shop.getShopItem().getPrice();
            Intrinsics.checkNotNull((Object)n);
            if (d >= (double)n.intValue() && this.chestHasEnoughItems((class_2595)chestEntity, shopItemStack)) {
                UUID uUID2 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"player.uuid");
                Integer n3 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n3);
                this.economy.withdraw(uUID2, n3.intValue());
                class_1799 removedFromChest = this.deleteItemFromChest((class_2595)chestEntity, shopItemStack);
                if (removedFromChest != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)playerInv, (String)"playerInv");
                    this.giveItemsToPlayer(playerInv, removedFromChest);
                    String string2 = shop.getOwner();
                    Integer n4 = shop.getShopItem().getPrice();
                    Intrinsics.checkNotNull((Object)n4);
                    BalanceHandler.INSTANCE.addBalance(string2, n4.intValue());
                    StringBuilder stringBuilder = new StringBuilder().append(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix()).append(" <grey>Bought item for ");
                    Integer n5 = shop.getShopItem().getPrice();
                    Intrinsics.checkNotNull((Object)n5);
                    player.method_7353(PM.INSTANCE.returnStyledText(stringBuilder.append(n5).append('.').toString()), false);
                } else {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Not enough items in chest to buy."), false);
                }
            } else {
                UUID uUID3 = player.method_5667();
                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"player.uuid");
                double d2 = this.economy.getBalance(uUID3);
                Integer n6 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n6);
                if (d2 < (double)n6.intValue()) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Not enough " + ConfigHandler.INSTANCE.getConfig().getCurrencyName() + " to buy."), false);
                } else if (!this.chestHasEnoughItems((class_2595)chestEntity, shopItemStack)) {
                    player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " <red>Not enough items in chest to buy."), false);
                }
            }
        } else {
            player.method_7353(PM.INSTANCE.returnStyledText(ConfigHandler.INSTANCE.getConfig().getMessage().getPrefix() + " Shop is not configured properly."), false);
        }
    }

    public final boolean hasEnoughItems(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || stack.method_7947() < itemStack.method_7947()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final class_1799 removeItemsFromInventory(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = inventory.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || stack.method_7947() < itemStack.method_7947()) continue;
            return inventory.method_5434(i, itemStack.method_7947());
        }
        return null;
    }

    public final void giveItemsToPlayer(@NotNull class_1661 inventory, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        inventory.method_7398(itemStack);
    }

    public final boolean chestHasEnoughSpace(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = chestBlockEntity.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(i);
            if (chestItemStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack) || chestItemStack.method_7947() >= chestItemStack.method_7914()) continue;
            return true;
        }
        return false;
    }

    public final void insertItemIntoChest(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = chestBlockEntity.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(i);
            if (chestItemStack.method_7960()) {
                chestBlockEntity.method_5447(i, itemStack);
                return;
            }
            if (!Intrinsics.areEqual((Object)chestItemStack.method_7909(), (Object)itemStack.method_7909()) || chestItemStack.method_7947() >= chestItemStack.method_7914() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack)) continue;
            int newCount = chestItemStack.method_7947() + 1;
            chestItemStack.method_7939(newCount);
            chestBlockEntity.method_5447(i, chestItemStack);
            return;
        }
    }

    public final boolean chestHasEnoughItems(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = chestBlockEntity.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(i);
            if (chestItemStack.method_7960() || !Intrinsics.areEqual((Object)chestItemStack.method_7909(), (Object)itemStack.method_7909()) || chestItemStack.method_7947() < itemStack.method_7947() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final class_1799 deleteItemFromChest(@NotNull class_2595 chestBlockEntity, @NotNull class_1799 itemStack) {
        Intrinsics.checkNotNullParameter((Object)chestBlockEntity, (String)"chestBlockEntity");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int n = chestBlockEntity.method_5439();
        for (int i = 0; i < n; ++i) {
            class_1799 chestItemStack = chestBlockEntity.method_5438(i);
            if (chestItemStack.method_7960() || !class_1799.method_31577((class_1799)chestItemStack, (class_1799)itemStack) || chestItemStack.method_7947() < itemStack.method_7947()) continue;
            return chestBlockEntity.method_5434(i, itemStack.method_7947());
        }
        return null;
    }

    public final boolean shopHasBudget(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"sell")) {
            boolean bl;
            Integer n = shop.getShopItem().getSellBudget();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                Integer n2 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n2);
                bl = it >= n2;
            } else {
                bl = false;
            }
            return bl;
        }
        return Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"buy");
    }

    public final void deductBudget(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"shop");
        if (Intrinsics.areEqual((Object)shop.getShopItem().getType(), (Object)"sell")) {
            Integer n;
            ShopItem shopItem = shop.getShopItem();
            Integer n2 = shop.getShopItem().getSellBudget();
            if (n2 != null) {
                int n3 = n2;
                Integer n4 = shop.getShopItem().getPrice();
                Intrinsics.checkNotNull((Object)n4);
                n = n3 - n4;
            } else {
                n = null;
            }
            shopItem.setSellBudget(n);
        }
    }
}

