/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.moddingx.libx.command.CommandUtil;

public class Suggestions {
    public static final SuggestionProvider<CommandSourceStack> SPAWN_POSITIONS = (context, builder) -> {
        Team team = SkyblockSavedData.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getTeamFromPlayer((Player)((CommandSourceStack)context.getSource()).m_81375_());
        if (team != null) {
            Set<TemplatesConfig.Spawn> possibleSpawns = team.getPossibleSpawns();
            possibleSpawns.forEach(spawn -> builder.suggest(String.format("%s %s %s", spawn.pos().m_123341_(), spawn.pos().m_123342_(), spawn.pos().m_123343_())));
        }
        return BlockPosArgument.m_118239_().listSuggestions(context, builder);
    };
    public static final SuggestionProvider<CommandSourceStack> INVITED_PLAYERS_OF_PLAYERS_TEAM = (context, builder) -> {
        Team team = SkyblockSavedData.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getTeamFromPlayer((Player)((CommandSourceStack)context.getSource()).m_81375_());
        if (team != null) {
            Set<UUID> players = team.getJoinRequests();
            PlayerList playerList = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_();
            players.forEach(id -> {
                ServerPlayer player = playerList.m_11259_(id);
                if (player != null) {
                    builder.suggest(player.m_5446_().getString());
                }
            });
        }
        return EntityArgument.m_91449_().listSuggestions(context, builder);
    };
    public static final SuggestionProvider<CommandSourceStack> TEMPLATES = (context, builder) -> SharedSuggestionProvider.m_82981_(TemplateLoader.getTemplateNames().stream().map(s -> "\"" + s + "\""), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SPREADS = (context, builder) -> {
        try {
            return SharedSuggestionProvider.m_82981_(Files.list(SkyPaths.SPREADS_DIR).filter(s -> s.toString().endsWith(".nbt") || s.toString().endsWith(".snbt")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(s -> "\"" + SkyPaths.SPREADS_DIR.relativize((Path)s) + "\""), (SuggestionsBuilder)builder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final SuggestionProvider<CommandSourceStack> SPREADS_FOR_TEAM = (context, builder) -> {
        String teamName = (String)CommandUtil.getArgumentOrDefault((CommandContext)context, (String)"team", String.class, (Object)"Spawn");
        SkyblockSavedData data = SkyblockSavedData.get((Level)((CommandSourceStack)context.getSource()).m_81372_());
        Team team = data.getTeam(teamName);
        if (team == null) {
            throw new RuntimeException("Team " + teamName + " not found");
        }
        return SharedSuggestionProvider.m_82981_(team.getAllSpreadNames().stream().map(s -> s.split(" ").length == 1 ? s : "\"" + s + "\""), (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> ALL_TEAMS = (context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)SkyblockSavedData.get(((CommandSourceStack)context.getSource()).m_81375_().m_9236_()).getTeams().stream().filter(team -> !team.isSpawn()).map(team -> team.getName().split(" ").length == 1 ? team.getName() : "\"" + team.getName() + "\"").collect(Collectors.toSet()), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> VISIT_TEAMS = (context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)SkyblockSavedData.get(((CommandSourceStack)context.getSource()).m_81375_().m_9236_()).getTeams().stream().filter(team -> team.allowsVisits() || ((CommandSourceStack)context.getSource()).m_6761_(2)).filter(team -> !team.isSpawn()).map(team -> team.getName().split(" ").length == 1 ? team.getName() : "\"" + team.getName() + "\"").collect(Collectors.toSet()), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> INVITE_TEAMS = (context, builder) -> {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)world);
        List<UUID> teams = data.getInvites((Player)source.m_81375_());
        if (teams != null && !teams.isEmpty()) {
            return SharedSuggestionProvider.m_82970_((Iterable)teams.stream().map(data::getTeam).filter(Objects::nonNull).filter(team -> !team.isSpawn()).map(team -> team.getName().split(" ").length == 1 ? team.getName() : "\"" + team.getName() + "\"").collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82967_((String[])new String[]{""}, (SuggestionsBuilder)builder);
    };
}

