/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.config.StartingInventory;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class InventoryCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"inventory").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(source -> source.m_6761_(2))).executes(context -> InventoryCommand.exportInventory((CommandSourceStack)context.getSource())));
    }

    private static int exportInventory(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        try {
            Files.createDirectories(SkyPaths.MOD_EXPORTS, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"skyblockbuilder.command.error.creating_path", (Object[])new Object[]{SkyPaths.MOD_EXPORTS.toString()})).create();
        }
        Path filePath = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, "starter_inventory", "json5");
        JsonObject json = new JsonObject();
        json.add("items", (JsonElement)InventoryCommand.vanillaInventory(player));
        if (ModList.get().isLoaded("curios")) {
            json.add("curios_items", (JsonElement)InventoryCommand.curiosInventory(player));
        }
        Path file = SkyPaths.MOD_EXPORTS.resolve(filePath.getFileName());
        try {
            BufferedWriter w = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json));
            w.close();
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"skyblockbuilder.command.error.creating_file", (Object[])new Object[]{file.toString()})).create();
        }
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.success.export_inventory", (Object[])new Object[]{filePath.toString()}).m_130940_(ChatFormatting.GOLD), true);
        return 1;
    }

    private static JsonArray vanillaInventory(ServerPlayer player) {
        JsonArray items = new JsonArray();
        Inventory inventory = player.m_150109_();
        for (ItemStack stack : inventory.f_35974_) {
            if (stack.m_41619_()) continue;
            items.add((JsonElement)StartingInventory.serializeItem(stack));
        }
        for (ItemStack stack : inventory.f_35976_) {
            if (stack.m_41619_()) continue;
            items.add((JsonElement)StartingInventory.serializeItem(stack, EquipmentSlot.OFFHAND));
        }
        for (Object slot : (Object)Inventory.f_150068_) {
            ItemStack stack = (ItemStack)inventory.f_35975_.get((int)slot);
            if (stack.m_41619_()) continue;
            EquipmentSlot equipmentSlot = switch (slot) {
                case 0 -> EquipmentSlot.FEET;
                case 1 -> EquipmentSlot.LEGS;
                case 2 -> EquipmentSlot.CHEST;
                case 3 -> EquipmentSlot.HEAD;
                default -> EquipmentSlot.MAINHAND;
            };
            items.add((JsonElement)StartingInventory.serializeItem(stack, equipmentSlot));
        }
        return items;
    }

    private static JsonArray curiosInventory(ServerPlayer player) {
        JsonArray items = new JsonArray();
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                String identifier = (String)entry.getKey();
                IDynamicStackHandler stacks = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    items.add((JsonElement)CuriosCompat.serializeItem(stack, identifier));
                }
            }
        });
        return items;
    }
}

