/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StartingInventory {
    private static final List<Pair<EquipmentSlot, ItemStack>> STARTER_ITEMS = new ArrayList<Pair<EquipmentSlot, ItemStack>>();

    public static void loadStarterItems() {
        STARTER_ITEMS.clear();
        File startInventoryConfig = new File(SkyPaths.ITEMS_FILE.toUri());
        try {
            String s = IOUtils.toString((Reader)new InputStreamReader(new FileInputStream(startInventoryConfig)));
            JsonObject json = GsonHelper.m_13869_((String)s, (boolean)true);
            if (json.has("items")) {
                JsonArray items = json.getAsJsonArray("items");
                HashSet<EquipmentSlot> usedTypes = new HashSet<EquipmentSlot>();
                int slotsUsedInMainInventory = 0;
                for (JsonElement item : items) {
                    EquipmentSlot slot;
                    JsonObject itemObj = (JsonObject)item;
                    ItemStack stack = CraftingHelper.getItemStack((JsonObject)itemObj, (boolean)true);
                    EquipmentSlot equipmentSlot = slot = itemObj.has("Slot") ? EquipmentSlot.m_20747_((String)GsonHelper.m_13906_((JsonObject)itemObj, (String)"Slot")) : EquipmentSlot.MAINHAND;
                    if (slot == EquipmentSlot.MAINHAND) {
                        if (slotsUsedInMainInventory >= 36) {
                            throw new IllegalStateException("Too many starting items in main inventory. Not more than 36 are allowed.");
                        }
                        ++slotsUsedInMainInventory;
                    } else {
                        if (usedTypes.contains(slot)) {
                            throw new IllegalStateException("Slot type that is not 'mainhand' was used multiple times for starting inventory.");
                        }
                        usedTypes.add(slot);
                    }
                    STARTER_ITEMS.add((Pair<EquipmentSlot, ItemStack>)Pair.of((Object)slot, (Object)stack));
                }
            }
            if (ModList.get().isLoaded("curios") && json.has("curios_items")) {
                CuriosCompat.loadStarterInventory(json.getAsJsonArray("curios_items"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read starting inventory", e);
        }
    }

    public static List<Pair<EquipmentSlot, ItemStack>> getStarterItems() {
        return ImmutableList.copyOf(STARTER_ITEMS);
    }

    public static JsonObject serializeItem(ItemStack stack) {
        return StartingInventory.serializeItem(stack, EquipmentSlot.MAINHAND);
    }

    public static JsonObject serializeItem(ItemStack stack, EquipmentSlot slot) {
        JsonObject json = RandomUtility.serializeItem(stack);
        if (slot != EquipmentSlot.MAINHAND) {
            json.addProperty("Slot", slot.toString().toLowerCase(Locale.ROOT));
        }
        return json;
    }
}

