/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class BlockMapper
implements ValueMapper<Block, JsonElement> {
    private static final InputProperties<Block> INPUT = new InputProperties<Block>(){

        public Block defaultValue() {
            return Blocks.f_50016_;
        }

        public Block valueOf(String str) {
            return (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)str));
        }

        public boolean canInputChar(char chr) {
            return ResourceLocation.m_135816_((char)chr);
        }

        public boolean isValid(String str) {
            return ForgeRegistries.BLOCKS.containsKey(ResourceLocation.m_135820_((String)str));
        }

        public String toString(Block block) {
            return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString();
        }
    };

    public Class<Block> type() {
        return Block.class;
    }

    public Class<JsonElement> element() {
        return JsonElement.class;
    }

    public Block fromJson(JsonElement json) {
        return (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)json.getAsString()));
    }

    public JsonElement toJson(Block value) {
        return new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)value), "This block doesn't exist: " + value).toString());
    }

    public Block fromNetwork(FriendlyByteBuf buffer) {
        return (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
    }

    public void toNetwork(Block value, FriendlyByteBuf buffer) {
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)value), "This block doesn't exist: " + value));
    }

    public ConfigEditor<Block> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.input(INPUT);
    }
}

