/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.item;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.util.ClientUtility;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.moddingx.libx.annotation.meta.RemoveIn;
import org.moddingx.libx.config.ConfigManager;

public class ItemStructureSaver
extends Item {
    private static final MutableComponent TOOLTIP_INFO = Component.m_237115_((String)"skyblockbuilder.item.structure_saver.info.tooltip").m_130940_(ChatFormatting.GOLD);
    private static final MutableComponent TOOLTIP_SAVE = Component.m_237115_((String)"skyblockbuilder.item.structure_saver.save.tooltip").m_130940_(ChatFormatting.GOLD);
    private static final MutableComponent TOOLTIP_RESTORE = Component.m_237115_((String)"skyblockbuilder.item.structure_saver.restore.tooltip").m_130940_(ChatFormatting.GOLD);

    public ItemStructureSaver() {
        super(new Item.Properties());
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!context.m_43725_().f_46443_ && player != null && player.m_6144_()) {
            ItemStack stack = context.m_43722_();
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("Position1")) {
                tag.m_128365_("Position1", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                tag.m_128473_("PreviousPositions");
                player.m_5661_((Component)Component.m_237110_((String)"skyblockbuilder.structure_saver.pos", (Object[])new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
                return InteractionResult.SUCCESS;
            }
            if (!tag.m_128441_("Position2")) {
                tag.m_128365_("Position2", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                player.m_5661_((Component)Component.m_237110_((String)"skyblockbuilder.structure_saver.pos", (Object[])new Object[]{2, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PreviousPositions") && entity.m_6144_()) {
            ItemStructureSaver.restorePositions(stack);
        }
        return super.onEntitySwing(stack, entity);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Position1") && tag.m_128441_("Position2")) {
            if (!tag.m_128441_("CanSave")) {
                tag.m_128379_("CanSave", true);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (level.f_46443_) {
                ClientUtility.openItemScreen(stack);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        BlockPos pos;
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Position1")) {
            pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position1"));
            tooltip.add((Component)Component.m_237110_((String)"skyblockbuilder.item.structure_saver.position.tooltip", (Object[])new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (nbt.m_128441_("Position2")) {
            pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position2"));
            tooltip.add((Component)Component.m_237110_((String)"skyblockbuilder.item.structure_saver.position.tooltip", (Object[])new Object[]{1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (nbt.m_128441_("CanSave")) {
            tooltip.add((Component)TOOLTIP_SAVE);
        } else {
            tooltip.add((Component)TOOLTIP_INFO);
        }
        if (nbt.m_128441_("PreviousPositions")) {
            tooltip.add((Component)TOOLTIP_RESTORE);
        }
    }

    @Nullable
    public static BoundingBox getArea(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("Position1") || !nbt.m_128441_("Position2")) {
            return null;
        }
        BlockPos pos1 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position1"));
        BlockPos pos2 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Position2"));
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.21")
    public static String saveSchematic(Level level, ItemStack stack, boolean saveToConfig, boolean ignoreAir, boolean asSnbt) {
        return ItemStructureSaver.saveSchematic(level, stack, saveToConfig, ignoreAir, asSnbt, false, null);
    }

    public static String saveSchematic(Level level, ItemStack stack, boolean saveToConfig, boolean ignoreAir, boolean asSnbt, boolean netherValidation) {
        return ItemStructureSaver.saveSchematic(level, stack, saveToConfig, ignoreAir, asSnbt, netherValidation, null);
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.21")
    public static String saveSchematic(Level level, ItemStack stack, boolean saveToConfig, boolean ignoreAir, boolean asSnbt, @Nullable String name) {
        return ItemStructureSaver.saveSchematic(level, stack, saveToConfig, ignoreAir, asSnbt, false, name);
    }

    public static String saveSchematic(Level level, ItemStack stack, boolean saveToConfig, boolean ignoreAir, boolean asSnbt, boolean netherValidation, @Nullable String name) {
        StructureTemplate template = new StructureTemplate();
        BoundingBox boundingBox = ItemStructureSaver.getArea(stack);
        if (boundingBox == null) {
            SkyblockBuilder.getLogger().error("No bounding box found for schematic!");
            return null;
        }
        if (netherValidation && level.m_45556_(AABB.m_82321_((BoundingBox)boundingBox)).noneMatch(state -> state.m_60713_(Blocks.f_50142_))) {
            SkyblockBuilder.getLogger().error("No portals found for schematic!");
            return null;
        }
        BlockPos origin = new BlockPos(boundingBox.m_162395_(), boundingBox.m_162396_(), boundingBox.m_162398_());
        BlockPos bounds = new BlockPos(boundingBox.m_71056_(), boundingBox.m_71057_(), boundingBox.m_71058_());
        HashSet toIgnore = Sets.newHashSet((Object[])new Block[]{Blocks.f_50454_});
        if (ignoreAir) {
            toIgnore.add(Blocks.f_50016_);
        }
        Set<TemplatesConfig.Spawn> spawnPositions = RandomUtility.fillTemplateFromWorld(template, level, origin, (Vec3i)bounds, true, toIgnore);
        if (saveToConfig) {
            JsonObject json = TemplateUtil.spawnsAsJson(spawnPositions);
            Path configFile = SkyPaths.MOD_CONFIG.resolve("templates.json5");
            try {
                JsonObject config = (JsonObject)SkyblockBuilder.PRETTY_GSON.fromJson(Files.readString(configFile), JsonObject.class);
                if (!config.has("spawns")) {
                    config.add("spawns", (JsonElement)new JsonObject());
                }
                JsonObject spawns = config.getAsJsonObject("spawns");
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                String formattedDate = dateFormat.format(calendar.getTime());
                String spawnsName = "exported_at_" + formattedDate;
                spawns.add(spawnsName, (JsonElement)json);
                config.add("spawns", (JsonElement)spawns);
                Path templatePath = RandomUtility.getFilePath(SkyPaths.TEMPLATES_DIR, name, asSnbt ? "snbt" : "nbt");
                CompoundTag tag = template.m_74618_(new CompoundTag());
                try {
                    TemplateUtil.writeTemplate(templatePath, tag, asSnbt);
                    SkyblockBuilder.getLogger().info("Saved template at {}", (Object)templatePath.toAbsolutePath());
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    return null;
                }
                String fileName = templatePath.getFileName().toFile().getName();
                int dot = fileName.lastIndexOf(".");
                String templateName = fileName.substring(0, dot);
                JsonObject templateObject = new JsonObject();
                templateObject.addProperty("name", templateName);
                templateObject.addProperty("file", fileName);
                templateObject.addProperty("spawns", spawnsName);
                if (!config.has("templates")) {
                    config.add("templates", (JsonElement)new JsonObject());
                }
                JsonArray templates = config.getAsJsonArray("templates");
                templates.add((JsonElement)templateObject);
                config.add("templates", (JsonElement)templates);
                Files.writeString(configFile, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)config), new OpenOption[0]);
                ConfigManager.reloadConfig(TemplatesConfig.class);
                if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                    ConfigManager.forceResync(null);
                }
                return configFile.getFileName().toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to overwrite config " + configFile.getFileName());
            }
        }
        if (!spawnPositions.isEmpty()) {
            Path spawns = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, name + "_spawns", "json");
            JsonObject json = TemplateUtil.spawnsAsJson(spawnPositions);
            try {
                Files.writeString(spawns, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json), new OpenOption[0]);
                SkyblockBuilder.getLogger().info("Saved spawns at {}", (Object)spawns.toAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        Path path = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, name, asSnbt ? "snbt" : "nbt");
        CompoundTag tag = template.m_74618_(new CompoundTag());
        try {
            TemplateUtil.writeTemplate(path, tag, asSnbt);
            SkyblockBuilder.getLogger().info("Saved template at {}", (Object)path.toAbsolutePath());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
        return path.getFileName().toString();
    }

    public static ItemStack restorePositions(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("PreviousPositions")) {
            return stack;
        }
        CompoundTag last = tag.m_128469_("PreviousPositions");
        tag.m_128365_("Position1", (Tag)last.m_128469_("Position1"));
        tag.m_128365_("Position2", (Tag)last.m_128469_("Position2"));
        tag.m_128379_("CanSave", true);
        tag.m_128473_("PreviousPositions");
        stack.m_41751_(tag);
        return stack;
    }

    public static ItemStack removeTags(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Position1") && tag.m_128441_("Position2")) {
            CompoundTag last = new CompoundTag();
            last.m_128365_("Position1", (Tag)tag.m_128469_("Position1"));
            last.m_128365_("Position2", (Tag)tag.m_128469_("Position2"));
            tag.m_128365_("PreviousPositions", (Tag)last);
        }
        tag.m_128473_("Position1");
        tag.m_128473_("Position2");
        tag.m_128473_("CanSave");
        stack.m_41751_(tag);
        return stack;
    }
}

