/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ProfilesUpdateMessage(Set<GameProfile> profiles) {

    public static class Serializer
    implements PacketSerializer<ProfilesUpdateMessage> {
        public Class<ProfilesUpdateMessage> messageClass() {
            return ProfilesUpdateMessage.class;
        }

        public void encode(ProfilesUpdateMessage msg, FriendlyByteBuf buffer) {
            int size = msg.profiles.size();
            buffer.m_130130_(size);
            msg.profiles.forEach(profile -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("Id", profile.getId());
                tag.m_128359_("Name", profile.getName());
                buffer.m_130079_(tag);
            });
        }

        public ProfilesUpdateMessage decode(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            HashSet<GameProfile> profiles = new HashSet<GameProfile>();
            for (int i = 0; i < size; ++i) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                UUID id = tag.m_128342_("Id");
                String name = tag.m_128461_("Name");
                profiles.add(new GameProfile(id, name));
            }
            return new ProfilesUpdateMessage(profiles);
        }
    }

    public static class Handler
    implements PacketHandler<ProfilesUpdateMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ProfilesUpdateMessage msg, Supplier<NetworkEvent.Context> ctx) {
            GameProfileCache.addProfiles(msg.profiles);
            return true;
        }
    }
}

