/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.world.IslandPos;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.commons.io.IOUtils;

public class TemplateUtil {
    public static JsonObject possibleSpawnsAsJson(@Nonnull Team team) {
        return TemplateUtil.spawnsAsJson(team.getIsland(), team.getPossibleSpawns());
    }

    public static JsonObject defaultSpawnsAsJson(@Nonnull Team team) {
        return TemplateUtil.spawnsAsJson(team.getIsland(), team.getDefaultPossibleSpawns());
    }

    public static JsonObject spawnsAsJson(Set<TemplatesConfig.Spawn> spawns) {
        JsonArray north = new JsonArray();
        JsonArray east = new JsonArray();
        JsonArray south = new JsonArray();
        JsonArray west = new JsonArray();
        for (TemplatesConfig.Spawn spawn : spawns) {
            JsonArray position = new JsonArray();
            position.add((Number)spawn.pos().m_123341_());
            position.add((Number)spawn.pos().m_123342_());
            position.add((Number)spawn.pos().m_123343_());
            switch (spawn.direction()) {
                case NORTH: {
                    north.add((JsonElement)position);
                    break;
                }
                case EAST: {
                    east.add((JsonElement)position);
                    break;
                }
                case SOUTH: {
                    south.add((JsonElement)position);
                    break;
                }
                case WEST: {
                    west.add((JsonElement)position);
                }
            }
        }
        JsonObject json = new JsonObject();
        json.add("north", (JsonElement)north);
        json.add("east", (JsonElement)east);
        json.add("south", (JsonElement)south);
        json.add("west", (JsonElement)west);
        return json;
    }

    public static JsonObject spawnsAsJson(IslandPos islandPos, Set<TemplatesConfig.Spawn> possibleSpawns) {
        JsonArray north = new JsonArray();
        JsonArray east = new JsonArray();
        JsonArray south = new JsonArray();
        JsonArray west = new JsonArray();
        for (TemplatesConfig.Spawn spawn : possibleSpawns) {
            JsonArray position = new JsonArray();
            position.add((Number)(spawn.pos().m_123341_() % WorldConfig.islandDistance));
            position.add((Number)(spawn.pos().m_123342_() - islandPos.getCenter().m_123342_()));
            position.add((Number)(spawn.pos().m_123343_() % WorldConfig.islandDistance));
            switch (spawn.direction()) {
                case NORTH: {
                    north.add((JsonElement)position);
                    break;
                }
                case EAST: {
                    east.add((JsonElement)position);
                    break;
                }
                case SOUTH: {
                    south.add((JsonElement)position);
                    break;
                }
                case WEST: {
                    west.add((JsonElement)position);
                }
            }
        }
        JsonObject json = new JsonObject();
        json.add("north", (JsonElement)north);
        json.add("east", (JsonElement)east);
        json.add("south", (JsonElement)south);
        json.add("west", (JsonElement)west);
        return json;
    }

    public static void writeTemplate(Path path, CompoundTag template, boolean asSnbt) {
        try {
            if (asSnbt) {
                String snbt = NbtUtils.m_178063_((CompoundTag)template);
                Files.writeString(path, (CharSequence)snbt, new OpenOption[0]);
            } else {
                OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                NbtIo.m_128947_((CompoundTag)template, (OutputStream)outputStream);
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create template file", e);
        }
    }

    public static CompoundTag readTemplate(Path path) throws IOException, CommandSyntaxException {
        return TemplateUtil.readTemplate(path, path.toString().endsWith(".snbt"));
    }

    public static CompoundTag readTemplate(Path path, boolean snbt) throws IOException, CommandSyntaxException {
        if (snbt) {
            return NbtUtils.m_178024_((String)IOUtils.toString((Reader)Files.newBufferedReader(path)));
        }
        return NbtIo.m_128937_((File)path.toFile());
    }
}

