/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.ModBlockTags;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.SpawnSettings;
import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.PositionHelper;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldUtil {
    public static void teleportToIsland(ServerPlayer player, Team team) {
        Team playersTeam;
        MinecraftServer server = player.m_20194_();
        if (WorldConfig.leaveToOverworld && team.isSpawn() && ((playersTeam = SkyblockSavedData.get((Level)player.m_284548_()).getTeamFromPlayer((Player)player)) == null || playersTeam.isSpawn())) {
            ServerLevel overworld = server.m_129783_();
            BlockPos worldSpawn = overworld.m_220360_();
            player.m_8999_(overworld, (double)worldSpawn.m_123341_(), (double)worldSpawn.m_123342_(), (double)worldSpawn.m_123343_(), 0.0f, 0.0f);
            return;
        }
        ServerLevel level = WorldUtil.getConfiguredLevel(server);
        TemplatesConfig.Spawn spawn = WorldUtil.validPosition(level, team);
        player.m_8999_(level, (double)spawn.pos().m_123341_() + 0.5, (double)spawn.pos().m_123342_() + 0.2, (double)spawn.pos().m_123343_() + 0.5, (float)spawn.direction().getYRot(), 0.0f);
        player.m_9158_(level.m_46472_(), spawn.pos(), (float)spawn.direction().getYRot(), true, false);
        if (PermissionsConfig.Teleports.noFallDamage) {
            player.f_19789_ = 0.0f;
        }
    }

    public static boolean isSkyblock(Level level) {
        if (PermissionsConfig.forceSkyblockCheck) {
            return true;
        }
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        MinecraftServer server = ((ServerLevel)level).m_7654_();
        if (!DimensionsConfig.Overworld.Default) {
            return server.m_129783_().m_7726_().m_8481_() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (!DimensionsConfig.Nether.Default) {
            ServerLevel nether = server.m_129880_(Level.f_46429_);
            return nether != null && nether.m_7726_().m_8481_() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (!DimensionsConfig.End.Default) {
            ServerLevel end = server.m_129880_(Level.f_46430_);
            return end != null && end.m_7726_().m_8481_() instanceof SkyblockEndChunkGenerator;
        }
        return false;
    }

    public static void checkSkyblock(CommandSourceStack source) throws CommandSyntaxException {
        if (!WorldUtil.isSkyblock((Level)source.m_81377_().m_129783_())) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"skyblockbuilder.error.no_skyblock")).create();
        }
    }

    public static ServerLevel getConfiguredLevel(MinecraftServer server) {
        ResourceLocation location = SpawnConfig.dimension.m_135782_();
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
        ServerLevel configLevel = server.m_129880_(worldKey);
        if (configLevel == null) {
            SkyblockBuilder.getLogger().warn("Configured dimension for spawn does not exist: {}", (Object)location);
        }
        return configLevel != null ? configLevel : server.m_129783_();
    }

    private static TemplatesConfig.Spawn validPosition(ServerLevel level, Team team) {
        TemplatesConfig.Spawn spawn;
        ArrayList<TemplatesConfig.Spawn> spawns = new ArrayList<TemplatesConfig.Spawn>(team.getPossibleSpawns());
        Random random = new Random();
        while (!spawns.isEmpty()) {
            spawn = (TemplatesConfig.Spawn)spawns.get(random.nextInt(spawns.size()));
            if (WorldUtil.isValidSpawn((Level)level, spawn.pos())) {
                return spawn;
            }
            spawns.remove(spawn);
        }
        SkyblockBuilder.getLogger().info("No valid spawn position found, searching...");
        spawn = team.getPossibleSpawns().stream().findAny().orElse(new TemplatesConfig.Spawn(team.getIsland().getCenter(), Directions.SOUTH));
        return new TemplatesConfig.Spawn(PositionHelper.findPos(spawn.pos(), blockPos -> WorldUtil.isValidSpawn((Level)level, blockPos), SpawnConfig.radius), spawn.direction());
    }

    public static boolean isValidSpawn(Level level, BlockPos pos) {
        return WorldUtil.isValidSpawn(level, pos, level.m_141937_(), level.m_151558_());
    }

    public static boolean isValidSpawn(Level level, BlockPos pos, int bottom, int top) {
        return pos.m_123342_() >= bottom && pos.m_123342_() <= top && (level.m_8055_(pos.m_7495_()).m_60815_() || level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.ADDITIONAL_VALID_SPAWN)) && !level.m_8055_(pos).m_60815_() && !level.m_8055_(pos.m_7494_()).m_60815_();
    }

    public static int calcSpawnHeight(Level level, int x, int z) {
        int top = SpawnConfig.Height.range.top();
        int bottom = SpawnConfig.Height.range.bottom();
        return Math.max(level.m_141937_() + 1, switch (SpawnConfig.Height.spawnType) {
            case SpawnSettings.Type.RANGE_TOP, SpawnSettings.Type.RANGE_BOTTOM -> {
                BlockPos.MutableBlockPos spawn = new BlockPos.MutableBlockPos(x, top, z);
                while (!WorldUtil.isValidSpawn(level, (BlockPos)spawn, bottom, top)) {
                    if (spawn.m_123342_() <= level.m_141937_()) {
                        if (SpawnConfig.Height.spawnType == SpawnSettings.Type.RANGE_TOP) {
                            spawn.m_142448_(top);
                            break;
                        }
                        spawn.m_142448_(bottom);
                        break;
                    }
                    spawn.m_122175_(Direction.DOWN, 1);
                }
                yield spawn.m_123342_() + SpawnConfig.Height.offset;
            }
            default -> bottom;
        });
    }

    public static List<FlatLayerInfo> layersInfoFromString(String settings) {
        if (settings == null || settings.isBlank()) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        String[] astring = settings.split(",");
        int i = 0;
        for (String s : astring) {
            FlatLayerInfo flatlayerinfo = WorldUtil.getLayerInfo(s, i);
            if (flatlayerinfo == null) {
                return Collections.emptyList();
            }
            list.add(flatlayerinfo);
            i += flatlayerinfo.m_70337_();
        }
        return list;
    }

    @Nullable
    private static FlatLayerInfo getLayerInfo(String setting, int currentLayers) {
        Block block;
        int i;
        String[] info = setting.split("\\*", 2);
        if (info.length == 2) {
            try {
                i = Math.max(Integer.parseInt(info[0]), 0);
            }
            catch (NumberFormatException numberformatexception) {
                SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)numberformatexception.getMessage());
                return null;
            }
        } else {
            i = 1;
        }
        int maxLayers = Math.min(currentLayers + i, 384);
        int height = maxLayers - currentLayers;
        String blockName = info[info.length - 1];
        try {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        }
        catch (Exception exception) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)exception.getMessage());
            return null;
        }
        if (block == null) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => Unknown block, {}", (Object)blockName);
            return null;
        }
        return new FlatLayerInfo(height, block);
    }

    public static int calculateHeightFromLayers(List<FlatLayerInfo> layerInfos) {
        int i = 0;
        for (FlatLayerInfo info : layerInfos) {
            i += info.m_70337_();
        }
        return i;
    }

    public static CompoundTag getPosTag(BlockPos pos) {
        CompoundTag posTag = new CompoundTag();
        posTag.m_128405_("posX", pos.m_123341_());
        posTag.m_128405_("posY", pos.m_123342_());
        posTag.m_128405_("posZ", pos.m_123343_());
        return posTag;
    }

    public static BlockPos getPosFromTag(CompoundTag posTag) {
        return new BlockPos(posTag.m_128451_("posX"), posTag.m_128451_("posY"), posTag.m_128451_("posZ"));
    }

    public static enum Directions {
        NORTH(180),
        EAST(270),
        SOUTH(0),
        WEST(90);

        private final int yRot;

        private Directions(int yaw) {
            this.yRot = yaw;
        }

        public static Directions fromDirection(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> NORTH;
                case Direction.EAST -> EAST;
                case Direction.WEST -> WEST;
                default -> SOUTH;
            };
        }

        public int getYRot() {
            return this.yRot;
        }
    }
}

