/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;

public class SkyblockEndChunkGenerator
extends SkyblockNoiseBasedChunkGenerator {
    private static final int MAIN_ISLAND_DISTANCE = 16;
    public static final Codec<SkyblockEndChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.generatorSettings), (App)Level.f_46427_.fieldOf("dimension").forGetter(generator -> generator.dimension), (App)FlatLayerInfo.f_70329_.listOf().fieldOf("layers").forGetter(generator -> generator.layerInfos)).apply((Applicative)instance, instance.stable(SkyblockEndChunkGenerator::new)));

    public SkyblockEndChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> generatorSettings, ResourceKey<Level> dimension, List<FlatLayerInfo> layerInfos) {
        super(biomeSource, generatorSettings, dimension, layerInfos);
    }

    @Override
    @Nonnull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Override
    public void m_214194_(@Nonnull WorldGenRegion level, @Nonnull StructureManager structureManager, @Nonnull RandomState randomState, @Nonnull ChunkAccess chunk) {
        super.m_214194_(level, structureManager, randomState, chunk);
        ChunkPos chunkPos = chunk.m_7697_();
        if (chunkPos.f_45578_ == 0 && chunkPos.f_45579_ == 0) {
            chunk.m_6978_(new BlockPos(0, 64, 0), Blocks.f_50752_.m_49966_(), false);
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<ChunkAccess> m_213974_(@Nonnull Executor executor, @Nonnull Blender blender, @Nonnull RandomState randomState, @Nonnull StructureManager manager, @Nonnull ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (DimensionsConfig.End.mainIsland && Mth.m_14040_((int)chunkPos.f_45578_) <= 16 && Mth.m_14040_((int)chunkPos.f_45579_) <= 16) {
            return this.parent.m_213974_(executor, blender, randomState, manager, chunk);
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public void m_213679_(@Nonnull WorldGenRegion level, long seed, @Nonnull RandomState random, @Nonnull BiomeManager biomeManager, @Nonnull StructureManager structureManager, @Nonnull ChunkAccess chunk, @Nonnull GenerationStep.Carving carving) {
        ChunkPos pos = chunk.m_7697_();
        int value = 256;
        if (pos.m_45604_() <= value && pos.m_45604_() >= -value && pos.m_45605_() <= value && pos.m_45605_() >= -value) {
            super.m_213679_(level, seed, random, biomeManager, structureManager, chunk, carving);
        }
    }
}

