/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AcceptCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"accept").then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.INVITE_TEAMS).executes(context -> AcceptCommand.acceptTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int acceptTeam(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validateTeamExistence(source, teamName);
        if (validationResult == null) {
            return 0;
        }
        ServerPlayer player = validationResult.player();
        SkyblockSavedData data = SkyblockSavedData.get(player.level());
        Team team = validationResult.team();
        if (data.hasPlayerTeam((Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_PLAYER_HAS_TEAM.apply(player.getDisplayName().getString()));
            return 0;
        }
        if (!data.hasInvites((Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_NO_INVITATIONS);
            return 0;
        }
        switch (SkyblockHooks.onAccept(player, team)) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_ACCEPT_INVITATIONS);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_ACCEPT_INVITATIONS);
                return 0;
            }
        }
        if (!data.acceptInvite(team, (Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_ACCEPT_INVITATIONS);
            return 0;
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_JOINED_TEAM.apply(team.getName()), true);
        return 1;
    }
}

