/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.team;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RenameTeamCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"rename").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> RenameTeamCommand.renameTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), null))).then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> RenameTeamCommand.renameTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"team")))));
    }

    private static int renameTeam(CommandSourceStack source, String newName, String oldName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        if (!RenameTeamCommand.tryRenaming(source, newName, oldName, data)) {
            return 0;
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_RENAME_TEAM.apply(newName), true);
        return 1;
    }

    private static boolean tryRenaming(CommandSourceStack source, String newName, @Nullable String oldName, SkyblockSavedData data) throws CommandSyntaxException {
        RenameResult result;
        Team team;
        if (oldName == null) {
            ServerPlayer player = source.getPlayerOrException();
            team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
                return false;
            }
        } else {
            team = data.getTeam(oldName);
            if (team == null) {
                source.sendFailure((Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
                return false;
            }
        }
        if ((result = RenameTeamCommand.processRenameRequest(source, team, newName, oldName == null)) != RenameResult.ALLOWED) {
            source.sendFailure(result.getMessage());
            return false;
        }
        if (newName.length() > 64) {
            source.sendFailure((Component)SkyComponents.ERROR_NAME_LENGTH.apply(newName));
            return false;
        }
        ServerPlayer player = oldName == null ? source.getPlayerOrException() : null;
        SkyblockManageTeamEvent.Rename event = SkyblockHooks.onRename(player, team, newName);
        data.renameTeam(team, event.getPlayer(), event.getNewName());
        return true;
    }

    private static RenameResult processRenameRequest(CommandSourceStack source, Team team, String newName, boolean isPlayerRequest) {
        SkyblockManageTeamEvent.Rename event = SkyblockHooks.onRename(isPlayerRequest ? source.getPlayer() : null, team, newName);
        return switch (event.getResult()) {
            default -> throw new MatchException(null, null);
            case SkyblockManageTeamEvent.Result.DENY -> RenameResult.DENIED;
            case SkyblockManageTeamEvent.Result.DEFAULT -> {
                if (!isPlayerRequest && !PermissionManager.INSTANCE.mayBypassLimitation(source)) {
                    yield RenameResult.NO_PERMISSION;
                }
                yield RenameResult.ALLOWED;
            }
            case SkyblockManageTeamEvent.Result.ALLOW -> RenameResult.ALLOWED;
        };
    }

    private static enum RenameResult {
        ALLOWED(null),
        DENIED((Component)SkyComponents.DENIED_RENAME_TEAM),
        NO_PERMISSION((Component)SkyComponents.DISABLED_RENAME_TEAM);

        private final Component message;

        private RenameResult(Component message) {
            this.message = message;
        }

        public Component getMessage() {
            return this.message;
        }
    }
}

