/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.teleport;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SpawnCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"spawn").executes(context -> SpawnCommand.spawn((CommandSourceStack)context.getSource()));
    }

    private static int spawn(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.getPlayerOrException();
        Team team = data.getSpawn();
        if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_SPAWN) && !data.getOrCreateMetaInfo((Player)player).canTeleport(SkyMeta.TeleportType.SPAWN, level.getGameTime())) {
            source.sendFailure((Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)PermissionsConfig.Teleports.Cooldowns.spawnCooldown - (level.getGameTime() - data.getOrCreateMetaInfo((Player)player).getLastTeleport(SkyMeta.TeleportType.SPAWN)))));
            return 0;
        }
        if (CommandUtil.mayNotTeleport(source, data, player)) {
            return 0;
        }
        switch (SkyblockHooks.onTeleportToSpawn(player, team)) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_TELEPORT_TO_SPAWN);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_SPAWN)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_TELEPORT_SPAWN);
                return 0;
            }
        }
        data.getOrCreateMetaInfo((Player)player).setLastTeleport(SkyMeta.TeleportType.SPAWN, level.getGameTime());
        source.sendSuccess(() -> SkyComponents.SUCCESS_TELEPORT_TO_SPAWN, false);
        WorldUtil.teleportToIsland(player, team);
        return 1;
    }
}

