/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    public static final String MODID = "curios";
    private static final List<org.apache.commons.lang3.tuple.Pair<String, ItemStack>> STARTER_ITEMS = new ArrayList<org.apache.commons.lang3.tuple.Pair<String, ItemStack>>();

    public static void dropInventory(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getCurios().forEach((id, type) -> {
            IDynamicStackHandler stacks = type.getStacks();
            IDynamicStackHandler cosmeticStacks = type.getCosmeticStacks();
            for (int i = 0; i < type.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                ItemStack stack1 = cosmeticStacks.getStackInSlot(i);
                stacks.setStackInSlot(i, ItemStack.EMPTY);
                cosmeticStacks.setStackInSlot(i, ItemStack.EMPTY);
                player.drop(stack, true, false);
                player.drop(stack1, true, false);
            }
        }));
    }

    public static void setStartInventory(Player player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            block0: for (org.apache.commons.lang3.tuple.Pair<String, ItemStack> entry : STARTER_ITEMS) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(entry.getKey());
                if (stacksHandler == null) {
                    CuriosCompat.error(player);
                    SkyblockBuilder.getLogger().error("Curios slot identifier invalid: {}", entry.getKey());
                    continue;
                }
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (!stacks.getStackInSlot(i).isEmpty()) continue;
                    stacks.setStackInSlot(i, (ItemStack)entry.getValue());
                    continue block0;
                }
                CuriosCompat.error(player);
                SkyblockBuilder.getLogger().error("No slot available for item '{}' with identifier '{}'", entry.getValue(), entry.getKey());
            }
        });
    }

    public static void loadStarterInventory(JsonArray curiosItems, HolderLookup.Provider lookupProvider) {
        STARTER_ITEMS.clear();
        for (JsonElement element : curiosItems) {
            JsonObject mainObject = element.getAsJsonObject();
            Optional optional = ItemStack.OPTIONAL_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)mainObject.get("Item")).resultOrPartial(arg_0 -> ((Logger)SkyblockBuilder.getLogger()).error(arg_0));
            if (optional.isEmpty()) {
                throw new IllegalStateException("Unable to read starting item: " + String.valueOf(element));
            }
            ItemStack stack = (ItemStack)((Pair)optional.get()).getFirst();
            if (!mainObject.has("Slot")) {
                throw new IllegalStateException("Curios inventory 'Slot' identifier missing for " + String.valueOf(stack));
            }
            String identifier = mainObject.get("Slot").getAsString();
            STARTER_ITEMS.add((org.apache.commons.lang3.tuple.Pair<String, ItemStack>)org.apache.commons.lang3.tuple.Pair.of((Object)identifier, (Object)stack));
        }
    }

    private static void error(Player player) {
        player.sendSystemMessage((Component)Component.literal((String)"Something went wrong, look at the log for more information. If you're not the pack author, report it to them.").withStyle(ChatFormatting.RED));
    }
}

