/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;

public record TemplateSpawns(Set<BlockPos> south, Set<BlockPos> west, Set<BlockPos> north, Set<BlockPos> east) {
    public static TemplateSpawns fromJson(JsonObject json) {
        HashMap<String, Set<BlockPos>> spawns = new HashMap<String, Set<BlockPos>>();
        json.entrySet().forEach(entry -> ((JsonElement)entry.getValue()).getAsJsonArray().forEach(array -> {
            BlockPos pos = WorldUtil.blockPosFromJsonArray(array.getAsJsonArray());
            spawns.computeIfAbsent((String)entry.getKey(), k -> new HashSet()).add(pos);
        }));
        return TemplateSpawns.fromMap(spawns);
    }

    public static JsonObject toJson(TemplateSpawns spawns) {
        JsonObject json = new JsonObject();
        JsonArray southPositions = new JsonArray();
        for (BlockPos blockPos : spawns.south()) {
            JsonArray jsonArray = WorldUtil.blockPosToJsonArray(blockPos);
            southPositions.add((JsonElement)jsonArray);
        }
        JsonArray westPositions = new JsonArray();
        for (BlockPos blockPos : spawns.west()) {
            JsonArray jsonArray = WorldUtil.blockPosToJsonArray(blockPos);
            westPositions.add((JsonElement)jsonArray);
        }
        JsonArray jsonArray = new JsonArray();
        for (BlockPos blockPos : spawns.north()) {
            JsonArray jsonArray2 = WorldUtil.blockPosToJsonArray(blockPos);
            jsonArray.add((JsonElement)jsonArray2);
        }
        JsonArray jsonArray3 = new JsonArray();
        for (BlockPos blockPos : spawns.east()) {
            JsonArray jsonArray4 = WorldUtil.blockPosToJsonArray(blockPos);
            jsonArray3.add((JsonElement)jsonArray4);
        }
        json.add("south", (JsonElement)southPositions);
        json.add("west", (JsonElement)westPositions);
        json.add("north", (JsonElement)jsonArray);
        json.add("east", (JsonElement)jsonArray3);
        return json;
    }

    public static TemplateSpawns fromMap(Map<String, Set<BlockPos>> map) {
        return new TemplateSpawns(map.getOrDefault("south", Set.of()), map.getOrDefault("west", Set.of()), map.getOrDefault("north", Set.of()), map.getOrDefault("east", Set.of()));
    }

    public boolean allEmpty() {
        return this.south().isEmpty() && this.west().isEmpty() && this.north().isEmpty() && this.east().isEmpty();
    }
}

