/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class DeleteTagsHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("delete_tags"));

    protected DeleteTagsHandler() {
        super(TYPE, PacketFlow.SERVERBOUND, ItemStack.STREAM_CODEC.map(Message::new, Message::stack), HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = ItemStructureSaver.removeComponents(msg.stack);
        player2.setItemInHand(InteractionHand.MAIN_HAND, stack);
    }

    public record Message(ItemStack stack) implements CustomPacketPayload
    {
        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

