/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.registration.ModLootItemFunctions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class SpreadMapFunction
extends LootItemConditionalFunction {
    public static final Holder<MapDecorationType> DEFAULT_DECORATION = MapDecorationTypes.RED_X;
    public static final MapCodec<SpreadMapFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootItemConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.either((Codec)Codec.STRING.listOf(), (Codec)Codec.STRING).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((String)list.getFirst())) : Either.left((Object)list)).fieldOf("spreads").forGetter(function -> function.spreadNames), (App)MapDecorationType.CODEC.optionalFieldOf("decoration", DEFAULT_DECORATION).forGetter(function -> function.mapDecoration), (App)Codec.BYTE.optionalFieldOf("zoom", (Object)2).forGetter(function -> function.zoom))).apply((Applicative)instance, SpreadMapFunction::new));
    private final List<String> spreadNames;
    private final Holder<MapDecorationType> mapDecoration;
    private final byte zoom;

    public SpreadMapFunction(List<LootItemCondition> conditions, List<String> spreadNames, Holder<MapDecorationType> mapDecoration, byte zoom) {
        super(conditions);
        this.spreadNames = spreadNames;
        this.mapDecoration = mapDecoration;
        this.zoom = zoom;
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        ServerPlayer player;
        block10: {
            block9: {
                if (!stack.is(Items.MAP)) {
                    return stack;
                }
                Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
                Vec3 pos = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
                if (!(entity instanceof ServerPlayer)) break block9;
                player = (ServerPlayer)entity;
                if (pos != null) break block10;
            }
            return stack;
        }
        ServerLevel level = (ServerLevel)player.level();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            SkyblockBuilder.getLogger().error("Player {} does not have a team.", (Object)player);
            return stack;
        }
        if (team.getPlacedSpreads().isEmpty()) {
            SkyblockBuilder.getLogger().error("Team {} has no placed spreads", (Object)team.getName());
            return stack;
        }
        HashSet<Team.PlacedSpread> placedSpreads = new HashSet<Team.PlacedSpread>();
        for (String spreadName : this.spreadNames) {
            placedSpreads.addAll(team.getPlacedSpreads(spreadName));
        }
        if (placedSpreads.isEmpty()) {
            SkyblockBuilder.getLogger().error("No spread {} for team {}", this.spreadNames, (Object)team.getName());
            return stack;
        }
        BlockPos middle = SpreadMapFunction.getMiddle(placedSpreads.stream().map(Team.PlacedSpread::pos).collect(Collectors.toSet()));
        middle = middle.offset(0, 0, 0);
        ItemStack map = SpreadMapFunction.createFixedMap((Level)level, middle.getX(), middle.getZ(), this.zoom, true, true);
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)map);
        int i = 0;
        for (Team.PlacedSpread placedSpread : placedSpreads) {
            MapItemSavedData.addTargetDecoration((ItemStack)map, (BlockPos)placedSpread.pos(), (String)String.valueOf(i++), this.mapDecoration);
        }
        return map;
    }

    public static BlockPos getMiddle(Set<BlockPos> blocks) {
        double x = 0.0;
        double z = 0.0;
        for (BlockPos pos : blocks) {
            x += (double)pos.getX();
            z += (double)pos.getZ();
        }
        int avgX = (int)(x / (double)blocks.size());
        int avgZ = (int)(z / (double)blocks.size());
        return new BlockPos(avgX, 0, avgZ);
    }

    private static ItemStack createFixedMap(Level level, int levelX, int levelZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack map = Items.FILLED_MAP.getDefaultInstance();
        MapItemSavedData data = new MapItemSavedData(levelX, levelZ, scale, trackingPosition, unlimitedTracking, false, level.dimension());
        MapId freeMapId = level.getFreeMapId();
        level.setMapData(freeMapId, data);
        map.set(DataComponents.MAP_ID, (Object)freeMapId);
        return map;
    }

    @Nonnull
    public LootItemFunctionType<SpreadMapFunction> getType() {
        return ModLootItemFunctions.spreadMap;
    }
}

