/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TemplatePreview {
    private static final Set<String> LOGGED_IDS = new HashSet<String>();
    private final Icon icon;
    private final Path renderingTemplatePath;
    private final ConfiguredTemplate template;
    private final String id;
    private StructureTemplate loadedRenderingTemplate;

    public TemplatePreview(ConfiguredTemplate template) {
        this.id = Util.sanitizeName((String)template.getName().toLowerCase(Locale.ROOT), ResourceLocation::validPathChar);
        this.icon = TemplatePreview.searchForIconFile(this.id);
        this.renderingTemplatePath = TemplatePreview.searchForTemplateFile(this.id);
        this.template = template;
        if (this.icon == null && this.renderingTemplatePath == null && !LOGGED_IDS.contains(this.id)) {
            LOGGED_IDS.add(this.id);
            SkyblockBuilder.getLogger().info("No preview file \"{}.[png|nbt|snbt]\" found for \"{}\", using original template.", (Object)this.id, (Object)this.template.getName());
        }
    }

    private static Icon searchForIconFile(String id) {
        Path pngPath = SkyPaths.ICONS_DIR.resolve(id + ".png");
        return Files.exists(pngPath, new LinkOption[0]) ? new Icon(SkyblockBuilder.getInstance().resource(id + "/icon"), pngPath) : null;
    }

    private static Path searchForTemplateFile(String id) {
        Path nbtPath = SkyPaths.ICONS_DIR.resolve(id + ".nbt");
        Path snbtPath = SkyPaths.ICONS_DIR.resolve(id + ".snbt");
        return Files.exists(nbtPath, new LinkOption[0]) ? nbtPath : (Files.exists(snbtPath, new LinkOption[0]) ? snbtPath : null);
    }

    public PreviewType getType() {
        return this.icon != null ? PreviewType.IMAGE : (this.renderingTemplatePath != null ? PreviewType.TEMPLATE : PreviewType.NONE);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public StructureTemplate getRenderingTemplatePath() {
        if (this.getType() != PreviewType.TEMPLATE) {
            return this.template.getTemplate();
        }
        if (this.loadedRenderingTemplate != null) {
            return this.loadedRenderingTemplate;
        }
        StructureTemplate structureTemplate = new StructureTemplate();
        try {
            CompoundTag nbt = TemplateUtil.readTemplate(this.renderingTemplatePath);
            structureTemplate.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbt);
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException("Expected file at " + this.id + ".[s]nbt", e);
        }
        this.loadedRenderingTemplate = structureTemplate;
        return structureTemplate;
    }

    public record Icon(ResourceLocation location, Path path) {
    }

    public static enum PreviewType {
        IMAGE,
        TEMPLATE,
        NONE;

    }
}

