/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.mojang.datafixers.util.Pair;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import org.moddingx.libx.util.data.ResourceList;

public class BiomeSourceConverter {
    public static BiomeSource customBiomeSource(ResourceKey<Level> level, BiomeSource baseSource, HolderLookup<Biome> biomes) {
        ResourceList resourceList = WorldConfig.biomes.get(level.location().toString());
        if (resourceList != null) {
            HashSet newBiomes = new HashSet();
            for (Holder possibleBiome : baseSource.possibleBiomes()) {
                Optional optionalResourceKey = possibleBiome.unwrapKey();
                optionalResourceKey.ifPresent(key -> {
                    ResourceLocation location = key.location();
                    if (resourceList.test(location)) {
                        newBiomes.add(possibleBiome);
                    }
                });
            }
            if (newBiomes.isEmpty()) {
                biomes.listElementIds().filter(biomeKey -> resourceList.test(biomeKey.location())).forEach(key -> newBiomes.add(biomes.getOrThrow(key)));
            } else {
                SkyblockBuilder.getLogger().warn("Skipping biome filtering as all biomes were filtered out: {}", level);
                newBiomes.addAll(baseSource.possibleBiomes());
            }
            if (newBiomes.isEmpty()) {
                throw new IllegalStateException("No biomes selected for " + String.valueOf(level));
            }
            if (baseSource instanceof MultiNoiseBiomeSource) {
                List parameters = new ArrayList(((MultiNoiseBiomeSource)baseSource).parameters().values()).stream().filter(pair -> {
                    Holder holder = (Holder)pair.getSecond();
                    Optional optionalResourceKey = holder.unwrapKey();
                    return optionalResourceKey.filter(biomeResourceKey -> resourceList.test(biomeResourceKey.location())).isPresent();
                }).collect(Collectors.toList());
                if (parameters.isEmpty()) {
                    newBiomes.forEach(holder -> parameters.add(Pair.of((Object)new Climate.ParameterPoint(Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.point((float)0.0f), 0L), (Object)holder)));
                }
                return MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
            }
            if (baseSource instanceof TheEndBiomeSource) {
                if (newBiomes.size() == 5) {
                    List newBiomesList = newBiomes.stream().toList();
                    return new TheEndBiomeSource((Holder)newBiomesList.get(0), (Holder)newBiomesList.get(1), (Holder)newBiomesList.get(2), (Holder)newBiomesList.get(3), (Holder)newBiomesList.get(4));
                }
                SkyblockBuilder.getLogger().warn("Need to be exactly 5 biomes for '{}', currently {}", level, (Object)newBiomes.size());
            }
            SkyblockBuilder.getLogger().warn("Unable to modify dimension '{}' properly, using default", level);
        }
        return baseSource;
    }
}

