/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import palitraq.com.CustomTAB;

public class TabConfig {
    private static final String CONFIG_FILE = "customtab.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean enabled = true;
    public String header = "TPS - %TPS% \n MSPT - %MSPT% \n PLAYERS - %PLAYERS% \n RAM - %RAM% \n MAXRAM - %MAXRAM%";
    public String footer = "Uptime - %UPTIME% \n TPS_STYLED - %TPS_STYLED% \n MSPT_STYLED - %MSPT_STYLED%";
    public double maxTpsForGreen = 16.0;
    public double maxTpsForGold = 12.0;
    public double maxTpsForRed = 8.0;
    public String tpsComment = "settings\n\u2022 maxTpsForGreen=16\n\u2022 maxTpsForGold=12\n\u2022 maxTpsForRed=8\n\nColors\n\u2022 16+ TPS = Green\n\u2022 12-16 TPS = Gold\n\u2022 8-12 TPS = Red\n\u2022 <8 TPS = Dark Red";
    public boolean enableSmartUpdates = true;
    public long updateInterval = 1000L;

    public static TabConfig load() {
        TabConfig config;
        File file = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                config = (TabConfig)GSON.fromJson((Reader)reader, TabConfig.class);
            }
            catch (Exception e) {
                CustomTAB.LOGGER.error("Error loading config: ", (Throwable)e);
                config = new TabConfig();
                TabConfig.save(config);
            }
        } else {
            config = new TabConfig();
            TabConfig.save(config);
        }
        if (config.maxTpsForGreen > 20.0) {
            CustomTAB.LOGGER.warn("{}: maxTpsForGreen is set to {}, but Minecraft's max TPS is 20. Please lower this value to avoid misleading colors.", (Object)CONFIG_FILE, (Object)config.maxTpsForGreen);
        }
        if (config.maxTpsForGold > config.maxTpsForGreen) {
            CustomTAB.LOGGER.warn("{}: maxTpsForGold ({}) is greater than maxTpsForGreen ({}). Ensure maxTpsForGreen >= maxTpsForGold for correct coloring.", new Object[]{CONFIG_FILE, config.maxTpsForGold, config.maxTpsForGreen});
        }
        if (config.maxTpsForRed > config.maxTpsForGold) {
            CustomTAB.LOGGER.warn("{}: maxTpsForRed ({}) is greater than maxTpsForGold ({}). Ensure maxTpsForGold >= maxTpsForRed for correct coloring.", new Object[]{CONFIG_FILE, config.maxTpsForRed, config.maxTpsForGold});
        }
        return config;
    }

    private static void save(TabConfig config) {
        File file = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            CustomTAB.LOGGER.error("Error saving config: ", (Throwable)e);
        }
    }
}

