/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import palitraq.com.CustomTAB;
import palitraq.com.utils.DataCache;
import palitraq.com.utils.PlaceHolderRegistry;
import palitraq.com.utils.TextBuilder;

public class PlayerJoinHandler {
    private static final long UPDATE_INTERVAL = 1000L;
    private static long lastUpdateTime;
    private static boolean globalDataChanged;

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            long currentTime = System.currentTimeMillis();
            if (CustomTAB.CONFIG.enableSmartUpdates) {
                if (currentTime - lastUpdateTime >= CustomTAB.CONFIG.updateInterval && (globalDataChanged = DataCache.hasGlobalDataChanged())) {
                    lastUpdateTime = currentTime;
                    PlayerJoinHandler.updateAllPlayers();
                }
            } else if (currentTime - lastUpdateTime >= CustomTAB.CONFIG.updateInterval) {
                lastUpdateTime = currentTime;
                PlayerJoinHandler.updateAllPlayers();
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, serverInstance) -> {
            DataCache.forceUpdate();
            PlayerJoinHandler.updatePlayer(handler.field_14140);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, serverInstance) -> DataCache.clearPlayerCache(handler.field_14140.method_5820()));
    }

    public static void updateAllPlayers() {
        MinecraftServer server = CustomTAB.serverInstance;
        if (server == null || !CustomTAB.CONFIG.enabled || server.method_3760() == null) {
            return;
        }
        String[] headerAndFooter = new String[]{CustomTAB.CONFIG.header, CustomTAB.CONFIG.footer};
        PlayerJoinHandler.replaceFlatPlaceholders(PlaceHolderRegistry.GLOBAL_REGISTRY, null, headerAndFooter);
        Map<String, class_2561> globalPlaceholders = PlayerJoinHandler.getGlobalPlaceholders();
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean playerDataChanged = DataCache.hasPlayerDataChanged(player);
            if (!globalDataChanged && !playerDataChanged) continue;
            Map<String, class_2561> allPlaceholders = PlayerJoinHandler.mergeMaps(globalPlaceholders, PlayerJoinHandler.getSpecifiedPlayerPlaceholders(player));
            String[] specifiedHeaderAndFooter = new String[]{headerAndFooter[0], headerAndFooter[1]};
            PlayerJoinHandler.replaceFlatPlaceholders(PlaceHolderRegistry.PLAYER_REGISTRY, player, specifiedHeaderAndFooter);
            class_5250 header = TextBuilder.buildFromTemplate(specifiedHeaderAndFooter[0], allPlaceholders);
            class_5250 footer = TextBuilder.buildFromTemplate(specifiedHeaderAndFooter[1], allPlaceholders);
            class_2772 packet = new class_2772((class_2561)header, (class_2561)footer);
            player.field_13987.method_14364((class_2596)packet);
        }
        globalDataChanged = false;
    }

    public static void updatePlayer(class_3222 player) {
        if (player == null || CustomTAB.serverInstance == null || !CustomTAB.CONFIG.enabled || player.field_13987 == null) {
            return;
        }
        Map<String, class_2561> placeholders = PlayerJoinHandler.mergeMaps(PlayerJoinHandler.getGlobalPlaceholders(), PlayerJoinHandler.getSpecifiedPlayerPlaceholders(player));
        String[] headerAndFooter = new String[]{CustomTAB.CONFIG.header, CustomTAB.CONFIG.footer};
        PlayerJoinHandler.replaceFlatPlaceholders(PlayerJoinHandler.mergeMaps(PlaceHolderRegistry.GLOBAL_REGISTRY, PlaceHolderRegistry.PLAYER_REGISTRY), player, headerAndFooter);
        class_5250 header = TextBuilder.buildFromTemplate(headerAndFooter[0], placeholders);
        class_5250 footer = TextBuilder.buildFromTemplate(headerAndFooter[1], placeholders);
        class_2772 packet = new class_2772((class_2561)header, (class_2561)footer);
        player.field_13987.method_14364((class_2596)packet);
    }

    private static Map<String, class_2561> computePlaceholders(Map<String, PlaceHolderRegistry.PlaceHolder> registry, @Nullable class_3222 player) {
        return registry.values().stream().filter(PlaceHolderRegistry.PlaceHolder::isTextObject).collect(Collectors.toMap(PlaceHolderRegistry.PlaceHolder::phKey, ph -> ph.valueSupplier().apply(player)));
    }

    private static String[] replaceFlatPlaceholders(Map<String, PlaceHolderRegistry.PlaceHolder> registry, class_3222 player, String ... base) {
        registry.values().stream().filter(ph -> !ph.isTextObject()).forEach(ph -> {
            for (int i = 0; i < base.length; ++i) {
                base[i] = base[i].replace(ph.phKey(), ph.flatValueSupplier().apply(player));
            }
        });
        return base;
    }

    private static Map<String, class_2561> getGlobalPlaceholders() {
        return PlayerJoinHandler.computePlaceholders(PlaceHolderRegistry.GLOBAL_REGISTRY, null);
    }

    private static Map<String, class_2561> getSpecifiedPlayerPlaceholders(class_3222 player) {
        return PlayerJoinHandler.computePlaceholders(PlaceHolderRegistry.PLAYER_REGISTRY, player);
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> left, Map<K, V> right) {
        HashMap<K, V> result = new HashMap<K, V>(left);
        result.putAll(right);
        return result;
    }

    static {
        globalDataChanged = false;
    }
}

