/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3222;
import palitraq.com.CustomTAB;
import palitraq.com.utils.StatisticsUtils;

public class DataCache {
    private static final Map<String, Object> globalCache = new HashMap<String, Object>();
    private static final Map<String, Map<String, Object>> playerCache = new HashMap<String, Map<String, Object>>();
    private static long lastTpsUpdate = 0L;
    private static long lastRamUpdate = 0L;
    private static long lastUptimeUpdate = 0L;
    private static long lastPlayersUpdate = 0L;
    private static final long TPS_CACHE_TIME = 200L;
    private static final long RAM_CACHE_TIME = 2000L;
    private static final long UPTIME_CACHE_TIME = 1000L;
    private static final long PLAYERS_CACHE_TIME = 500L;

    public static boolean hasGlobalDataChanged() {
        long currentTime = System.currentTimeMillis();
        boolean changed = false;
        if (currentTime - lastTpsUpdate >= 200L) {
            double currentTps = StatisticsUtils.calculateTPS();
            Object cachedTps = globalCache.get("tps");
            if (cachedTps == null || Math.abs((Double)cachedTps - currentTps) > 0.1) {
                globalCache.put("tps", currentTps);
                lastTpsUpdate = currentTime;
                changed = true;
            }
        }
        if (currentTime - lastRamUpdate >= 2000L) {
            String currentRam = StatisticsUtils.getRam();
            String cachedRam = (String)globalCache.get("ram");
            if (cachedRam == null || !cachedRam.equals(currentRam)) {
                globalCache.put("ram", currentRam);
                globalCache.put("maxRam", StatisticsUtils.getMaxRam());
                lastRamUpdate = currentTime;
                changed = true;
            }
        }
        if (currentTime - lastUptimeUpdate >= 1000L) {
            String currentUptime = StatisticsUtils.getUptime();
            String cachedUptime = (String)globalCache.get("uptime");
            if (cachedUptime == null || !cachedUptime.equals(currentUptime)) {
                globalCache.put("uptime", currentUptime);
                lastUptimeUpdate = currentTime;
                changed = true;
            }
        }
        if (currentTime - lastPlayersUpdate >= 500L) {
            int currentPlayers = CustomTAB.serverInstance.method_3788();
            Integer cachedPlayers = (Integer)globalCache.get("players");
            if (cachedPlayers == null || !cachedPlayers.equals(currentPlayers)) {
                globalCache.put("players", currentPlayers);
                lastPlayersUpdate = currentTime;
                changed = true;
            }
        }
        return changed;
    }

    public static boolean hasPlayerDataChanged(class_3222 player) {
        if (player == null) {
            return false;
        }
        String playerName = player.method_5820();
        Map playerData = playerCache.computeIfAbsent(playerName, k -> new HashMap());
        boolean changed = false;
        float currentHealth = player.method_6032();
        Float cachedHealth = (Float)playerData.get("health");
        if (cachedHealth == null || Math.abs(cachedHealth.floatValue() - currentHealth) > 0.1f) {
            playerData.put("health", Float.valueOf(currentHealth));
            changed = true;
        }
        int currentFood = player.method_7344().method_7586();
        Integer cachedFood = (Integer)playerData.get("food");
        if (cachedFood == null || !cachedFood.equals(currentFood)) {
            playerData.put("food", currentFood);
            changed = true;
        }
        int currentLevel = player.field_7520;
        Integer cachedLevel = (Integer)playerData.get("level");
        if (cachedLevel == null || !cachedLevel.equals(currentLevel)) {
            playerData.put("level", currentLevel);
            changed = true;
        }
        int currentPing = player.field_13967;
        Integer cachedPing = (Integer)playerData.get("ping");
        if (cachedPing == null || Math.abs(cachedPing - currentPing) > 50) {
            playerData.put("ping", currentPing);
            changed = true;
        }
        return changed;
    }

    public static void forceUpdate() {
        globalCache.clear();
        playerCache.clear();
        lastTpsUpdate = 0L;
        lastRamUpdate = 0L;
        lastUptimeUpdate = 0L;
        lastPlayersUpdate = 0L;
    }

    public static void clearPlayerCache(String playerName) {
        playerCache.remove(playerName);
    }

    public static Object getCachedValue(String key) {
        return globalCache.get(key);
    }

    public static Object getCachedPlayerValue(String playerName, String key) {
        Map<String, Object> playerData = playerCache.get(playerName);
        return playerData != null ? playerData.get(key) : null;
    }
}

