/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import palitraq.com.CustomTAB;
import palitraq.com.utils.StatisticsUtils;

public class PlaceHolderRegistry {
    public static final Map<String, PlaceHolder> GLOBAL_REGISTRY = new HashMap<String, PlaceHolder>();
    public static final Map<String, PlaceHolder> PLAYER_REGISTRY = new HashMap<String, PlaceHolder>();

    public static void registerGlobal(String phKey, Supplier<String> supplier) {
        GLOBAL_REGISTRY.put(phKey, new PlaceHolder(phKey, false, null, p -> (String)supplier.get()));
    }

    public static void registerGlobalStyled(String phKey, Supplier<class_2561> supplier) {
        GLOBAL_REGISTRY.put(phKey, new PlaceHolder(phKey, true, p -> (class_2561)supplier.get(), null));
    }

    public static void registerPerPlayer(String phKey, Function<class_3222, String> supplier) {
        PLAYER_REGISTRY.put(phKey, new PlaceHolder(phKey, false, null, supplier));
    }

    public static void registerPerPlayerStyled(String phKey, Function<class_3222, class_2561> supplier) {
        PLAYER_REGISTRY.put(phKey, new PlaceHolder(phKey, true, supplier, null));
    }

    static {
        PlaceHolderRegistry.registerGlobalStyled("%TPS_STYLED%", () -> {
            double tps = StatisticsUtils.calculateTPS();
            return class_2561.method_43470((String)String.format("%.1f", tps)).method_27694(style -> {
                if (tps >= CustomTAB.CONFIG.maxTpsForGreen) {
                    return style.method_10977(class_124.field_1060);
                }
                if (tps >= CustomTAB.CONFIG.maxTpsForGold) {
                    return style.method_10977(class_124.field_1065);
                }
                if (tps >= CustomTAB.CONFIG.maxTpsForRed) {
                    return style.method_10977(class_124.field_1061);
                }
                return style.method_10977(class_124.field_1079);
            });
        });
        PlaceHolderRegistry.registerGlobalStyled("%MSPT_STYLED%", () -> {
            double mspt = StatisticsUtils.getMSPT();
            return class_2561.method_43470((String)String.format("%.1f", mspt)).method_27694(style -> {
                if (mspt <= 1000.0 / CustomTAB.CONFIG.maxTpsForGreen) {
                    return style.method_10977(class_124.field_1060);
                }
                if (mspt <= 1000.0 / CustomTAB.CONFIG.maxTpsForGold) {
                    return style.method_10977(class_124.field_1065);
                }
                if (mspt <= 1000.0 / CustomTAB.CONFIG.maxTpsForRed) {
                    return style.method_10977(class_124.field_1061);
                }
                return style.method_10977(class_124.field_1079);
            });
        });
        PlaceHolderRegistry.registerGlobal("%TPS%", () -> String.format("%.1f", StatisticsUtils.calculateTPS()));
        PlaceHolderRegistry.registerGlobal("%MSPT%", () -> String.format("%.1f", StatisticsUtils.getMSPT()));
        PlaceHolderRegistry.registerGlobal("%PLAYERS%", () -> String.valueOf(CustomTAB.serverInstance.method_3788()));
        PlaceHolderRegistry.registerGlobal("%RAM%", StatisticsUtils::getRam);
        PlaceHolderRegistry.registerGlobal("%MAXRAM%", StatisticsUtils::getMaxRam);
        PlaceHolderRegistry.registerGlobal("%UPTIME%", StatisticsUtils::getUptime);
        PlaceHolderRegistry.registerPerPlayer("%PLAYER%", p -> p == null ? "Unknown" : p.method_5820());
    }

    public record PlaceHolder(String phKey, boolean isTextObject, Function<class_3222, class_2561> valueSupplier, Function<class_3222, String> flatValueSupplier) {
    }
}

