/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import palitraq.com.CustomTAB;

public class TpsConfig {
    private static final String CONFIG_FILE = "customtab.tpsvalues.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public double maxTpsForGreen = 16.0;
    public double maxTpsForGold = 12.0;
    public double maxTpsForRed = 8.0;
    public String comment = "You can change this variables to configure TPS/MSPT breakpoints. Example values: maxTpsForGreen=16, maxTpsForGold=12, maxTpsForRed=8. So 16<=TPS<20 -> Formatting.GREEN, 12<=TPS<16 -> Formatting.GOLD, 8<=TPS<12 -> Formatting.RED, TPS<8 -> Formatting.DARK_RED";

    public static TpsConfig load() {
        TpsConfig config;
        File file = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                config = (TpsConfig)GSON.fromJson((Reader)reader, TpsConfig.class);
            }
            catch (Exception e) {
                CustomTAB.LOGGER.error("Error loading config: ", (Throwable)e);
                config = new TpsConfig();
                TpsConfig.save(config);
            }
        } else {
            config = new TpsConfig();
            TpsConfig.save(config);
        }
        if (config.maxTpsForGreen > 20.0) {
            CustomTAB.LOGGER.warn("{}: maxTpsForGreen is set to {}, but Minecraft's max TPS is 20. Please lower this value to avoid misleading colors.", (Object)CONFIG_FILE, (Object)config.maxTpsForGreen);
        }
        if (config.maxTpsForGold > config.maxTpsForGreen) {
            CustomTAB.LOGGER.warn("{}: maxTpsForGold ({}) is greater than maxTpsForGreen ({}). Ensure maxTpsForGreen >= maxTpsForGold for correct coloring.", new Object[]{CONFIG_FILE, config.maxTpsForGold, config.maxTpsForGreen});
        }
        if (config.maxTpsForRed > config.maxTpsForGold) {
            CustomTAB.LOGGER.warn("{}: maxTpsForRed ({}) is greater than maxTpsForGold ({}). Ensure maxTpsForGold >= maxTpsForRed for correct coloring.", new Object[]{CONFIG_FILE, config.maxTpsForRed, config.maxTpsForGold});
        }
        return config;
    }

    private static void save(TpsConfig config) {
        File file = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE).toFile();
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            CustomTAB.LOGGER.error("Error saving config: ", (Throwable)e);
        }
    }
}

