/*
 * Decompiled with CFR 0.152.
 */
package palitraq.com.utils;

import palitraq.com.CustomTAB;

public class StatisticsUtils {
    private static long serverStartTime = System.currentTimeMillis();

    public static void setServerStartTime(long time) {
        serverStartTime = time;
    }

    public static double calculateTPS() {
        if (CustomTAB.serverInstance == null) {
            return 20.0;
        }
        try {
            double mspt = StatisticsUtils.getMSPT();
            return Math.min(20.0, 1000.0 / Math.max(mspt, 50.0));
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public static double getMSPT() {
        long[] tickTimes = CustomTAB.serverInstance.field_4573;
        if (tickTimes == null || tickTimes.length == 0) {
            return 50.0;
        }
        long sum = 0L;
        for (long value : tickTimes) {
            sum += value;
        }
        return (double)sum / (double)tickTimes.length * 1.0E-6;
    }

    public static String getUptime() {
        long uptimeMillis = System.currentTimeMillis() - serverStartTime;
        long seconds = uptimeMillis / 1000L;
        long days = seconds / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d:");
        }
        if (hours > 0L || days > 0L) {
            sb.append(hours).append("h:");
        }
        sb.append(minutes).append("m:");
        sb.append(seconds).append("s");
        return sb.toString();
    }

    public static String getRam() {
        long ramBytes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return String.valueOf(ramBytes / 1024L / 1024L);
    }

    public static String getMaxRam() {
        long maxRamBytes = Runtime.getRuntime().maxMemory();
        return String.valueOf(maxRamBytes / 1024L / 1024L);
    }
}

