/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.handtohand;

import com.saltywater.handtohand.HandToHandClient;
import com.saltywater.handtohand.networking.HandToHandNetworking;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="handtohand")
public class HandToHand {
    public static final String MODID = "handtohand";
    private static final Set<UUID> GIVING_STATE_PLAYERS = new HashSet<UUID>();

    public static boolean isInGivingState(ServerPlayer player) {
        return GIVING_STATE_PLAYERS.contains(player.m_20148_());
    }

    public static void setGivingState(ServerPlayer player, boolean state) {
        if (player == null) {
            return;
        }
        if (state) {
            GIVING_STATE_PLAYERS.add(player.m_20148_());
        } else {
            GIVING_STATE_PLAYERS.remove(player.m_20148_());
        }
    }

    public HandToHand() {
        HandToHandClient.registerClient();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        HandToHandNetworking.register();
    }

    public static void transferItem(ServerPlayer sender, ServerPlayer receiver, boolean transferAll) {
        if (sender == null || receiver == null) {
            return;
        }
        ItemStack itemInMainHand = sender.m_21205_();
        if (!itemInMainHand.m_41619_()) {
            int transferCount = transferAll ? itemInMainHand.m_41613_() : 1;
            ItemStack itemToGive = itemInMainHand.m_41777_();
            itemToGive.m_41764_(transferCount);
            boolean added = receiver.m_150109_().m_36054_(itemToGive);
            if (added) {
                itemInMainHand.m_41774_(transferCount);
                if (itemInMainHand.m_41619_()) {
                    sender.m_150109_().m_6836_(sender.m_150109_().f_35977_, ItemStack.f_41583_);
                }
            } else {
                sender.m_5661_((Component)receiver.m_5446_().m_6881_().m_130946_(" has a full inventory!"), true);
            }
        }
    }

    public static boolean isInventoryFull(ServerPlayer player) {
        return false;
    }

    public static boolean canFitItem(ServerPlayer player, ItemStack stackToGive) {
        if (stackToGive.m_41619_()) {
            return true;
        }
        for (ItemStack slotStack : player.m_150109_().f_35974_) {
            if (slotStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stackToGive) || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
            return true;
        }
        return false;
    }
}

