/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.handtohand;

import com.mojang.blaze3d.platform.InputConstants;
import com.saltywater.handtohand.networking.HandToHandNetworking;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="handtohand", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HandToHandClient {
    private static KeyMapping giveKey;
    private static final ResourceLocation GIVE_ANIMATION_ID;
    private static final ResourceLocation GIVE_STATE_ANIMATION_ID;
    private static final ResourceLocation GIVE_START_ANIMATION_ID;
    private static final ResourceLocation GIVE_END_ANIMATION_ID;
    private static final Set<UUID> CLIENT_GIVE_STATE;
    private static final ScheduledExecutorService SCHEDULER;

    private static boolean isLocalPlayerInGivingState() {
        LocalPlayer lp = Minecraft.m_91087_().f_91074_;
        return lp != null && CLIENT_GIVE_STATE.contains(lp.m_20148_());
    }

    public static void setLocalGiveState(UUID playerId, boolean state) {
        if (state) {
            CLIENT_GIVE_STATE.add(playerId);
        } else {
            CLIENT_GIVE_STATE.remove(playerId);
        }
    }

    public static void registerClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(HandToHandClient::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)new HandToHandClient());
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        giveKey = new KeyMapping("Give", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.m_84895_(82), "key.categories.gameplay");
        Minecraft.m_91087_().f_91066_.f_92059_ = HandToHandClient.appendKeyBinding(Minecraft.m_91087_().f_91066_.f_92059_, giveKey);
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (giveKey.m_90859_()) {
            EntityHitResult entityHitResult;
            Entity targetEntity;
            if (HandToHandClient.isLocalPlayerInGivingState()) {
                HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.StartGiveAnimationPacket(player.m_20148_().toString(), GIVE_END_ANIMATION_ID));
                this.playAnimationOnLayer1(player, GIVE_END_ANIMATION_ID);
                HandToHandNetworking.CHANNEL.sendToServer((Object)HandToHandNetworking.SetGiveStatePacket.create(player.m_20148_(), false));
                HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.StopGiveAnimationPacket(player.m_20148_().toString()));
                return;
            }
            boolean transferAll = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345);
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult instanceof EntityHitResult && (targetEntity = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof Player) {
                Player targetPlayer = (Player)targetEntity;
                HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.TransferItemPacket(player.m_20148_(), targetPlayer.m_20148_(), transferAll));
                HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.StartGiveAnimationPacket(player.m_20148_().toString(), GIVE_ANIMATION_ID));
                this.playAnimationOnLayer1(player, GIVE_ANIMATION_ID);
                return;
            }
            HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.StartGiveAnimationPacket(player.m_20148_().toString(), GIVE_START_ANIMATION_ID));
            this.playAnimationOnLayer1(player, GIVE_START_ANIMATION_ID);
            SCHEDULER.schedule(() -> {
                HandToHandNetworking.CHANNEL.sendToServer((Object)new HandToHandNetworking.StartGiveAnimationPacket(player.m_20148_().toString(), GIVE_STATE_ANIMATION_ID));
                HandToHandNetworking.CHANNEL.sendToServer((Object)HandToHandNetworking.SetGiveStatePacket.create(player.m_20148_(), true));
                Minecraft.m_91087_().execute(() -> this.playAnimationOnLayer0(player, GIVE_STATE_ANIMATION_ID));
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private void playAnimationOnLayer0(LocalPlayer player, ResourceLocation animationId) {
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        if (animationStack == null) {
            return;
        }
        KeyframeAnimation animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationId);
        if (animationData == null) {
            return;
        }
        animationStack.removeLayer(0);
        animationStack.addAnimLayer(0, (IAnimation)new KeyframeAnimationPlayer(animationData));
    }

    private void playAnimationOnLayer1(LocalPlayer player, ResourceLocation animationId) {
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        if (animationStack == null) {
            return;
        }
        KeyframeAnimation animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)animationId);
        if (animationData == null) {
            return;
        }
        animationStack.removeLayer(1);
        animationStack.addAnimLayer(1, (IAnimation)new KeyframeAnimationPlayer(animationData));
    }

    private void playAnimation(LocalPlayer player, ResourceLocation animationId) {
    }

    private static KeyMapping[] appendKeyBinding(KeyMapping[] existingKeyMappings, KeyMapping newKeyMapping) {
        KeyMapping[] newArray = new KeyMapping[existingKeyMappings.length + 1];
        System.arraycopy(existingKeyMappings, 0, newArray, 0, existingKeyMappings.length);
        newArray[existingKeyMappings.length] = newKeyMapping;
        return newArray;
    }

    static {
        GIVE_ANIMATION_ID = new ResourceLocation("handtohand", "give");
        GIVE_STATE_ANIMATION_ID = new ResourceLocation("handtohand", "givestate");
        GIVE_START_ANIMATION_ID = new ResourceLocation("handtohand", "givestart");
        GIVE_END_ANIMATION_ID = new ResourceLocation("handtohand", "giveend");
        CLIENT_GIVE_STATE = new HashSet<UUID>();
        SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    }
}

