/*
 * Decompiled with CFR 0.152.
 */
package com.saltywater.handtohand.networking;

import com.saltywater.handtohand.HandToHand;
import com.saltywater.handtohand.HandToHandClient;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class HandToHandNetworking {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("handtohand", "network"), () -> "1.0", "1.0"::equals, "1.0"::equals);
    public static boolean ALLOW_EXIT_GIVING_STATE_ON_TRANSFER = false;

    public static void register() {
        CHANNEL.registerMessage(0, StartGiveAnimationPacket.class, StartGiveAnimationPacket::encode, StartGiveAnimationPacket::decode, StartGiveAnimationPacket::handle);
        CHANNEL.registerMessage(1, StopGiveAnimationPacket.class, StopGiveAnimationPacket::encode, StopGiveAnimationPacket::decode, StopGiveAnimationPacket::handle);
        CHANNEL.registerMessage(2, TransferItemPacket.class, TransferItemPacket::encode, TransferItemPacket::decode, TransferItemPacket::handle);
        CHANNEL.registerMessage(3, SetGiveStatePacket.class, SetGiveStatePacket::encode, SetGiveStatePacket::decode, SetGiveStatePacket::handle);
    }

    public static class StartGiveAnimationPacket {
        private final String playerId;
        private final ResourceLocation animationId;

        public StartGiveAnimationPacket(String playerId, ResourceLocation animationId) {
            this.playerId = playerId;
            this.animationId = animationId;
        }

        public static void encode(StartGiveAnimationPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
            buf.m_130070_(packet.animationId.toString());
        }

        public static StartGiveAnimationPacket decode(FriendlyByteBuf buf) {
            String playerId = buf.m_130277_();
            ResourceLocation animId = new ResourceLocation(buf.m_130277_());
            return new StartGiveAnimationPacket(playerId, animId);
        }

        public static void handle(StartGiveAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            if (ctx.getDirection().getReceptionSide().isServer()) {
                CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            } else {
                ctx.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91073_.m_6907_().stream().filter(p -> p.m_20148_().toString().equals(packet.playerId) && p instanceof AbstractClientPlayer).findFirst().ifPresent(p -> {
                        KeyframeAnimation animationData;
                        AbstractClientPlayer player = p;
                        AnimationStack stack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
                        if (stack != null && (animationData = PlayerAnimationRegistry.getAnimation((ResourceLocation)packet.animationId)) != null) {
                            String path = packet.animationId.m_135815_();
                            int layerIndex = 0;
                            if (path.equals("givestart") || path.equals("giveend") || path.equals("give")) {
                                layerIndex = 1;
                            }
                            stack.removeLayer(layerIndex);
                            stack.addAnimLayer(layerIndex, (IAnimation)new KeyframeAnimationPlayer(animationData));
                        }
                    });
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static class StopGiveAnimationPacket {
        private final String playerId;

        public StopGiveAnimationPacket(String playerId) {
            this.playerId = playerId;
        }

        public static void encode(StopGiveAnimationPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.playerId);
        }

        public static StopGiveAnimationPacket decode(FriendlyByteBuf buf) {
            return new StopGiveAnimationPacket(buf.m_130277_());
        }

        public static void handle(StopGiveAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            if (ctx.getDirection().getReceptionSide().isServer()) {
                CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            } else {
                ctx.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    minecraft.f_91073_.m_6907_().stream().filter(p -> p.m_20148_().toString().equals(packet.playerId) && p instanceof AbstractClientPlayer).findFirst().ifPresent(p -> {
                        AnimationStack stack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)p);
                        if (stack != null) {
                            stack.removeLayer(0);
                        }
                    });
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static class TransferItemPacket {
        private final UUID senderUUID;
        private final UUID targetUUID;
        private final boolean transferAll;

        public TransferItemPacket(UUID senderUUID, UUID targetUUID, boolean transferAll) {
            this.senderUUID = senderUUID;
            this.targetUUID = targetUUID;
            this.transferAll = transferAll;
        }

        public static void encode(TransferItemPacket packet, FriendlyByteBuf buf) {
            buf.m_130077_(packet.senderUUID);
            buf.m_130077_(packet.targetUUID);
            buf.writeBoolean(packet.transferAll);
        }

        public static TransferItemPacket decode(FriendlyByteBuf buf) {
            return new TransferItemPacket(buf.m_130259_(), buf.m_130259_(), buf.readBoolean());
        }

        public static void handle(TransferItemPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer clicker = ctx.getSender();
                if (clicker == null) {
                    return;
                }
                ServerPlayer target = clicker.f_8924_.m_6846_().m_11259_(packet.targetUUID);
                if (target != null) {
                    if (HandToHand.isInGivingState(target)) {
                        HandToHand.transferItem(target, clicker, packet.transferAll);
                        if (ALLOW_EXIT_GIVING_STATE_ON_TRANSFER) {
                            HandToHand.setGivingState(target, false);
                            CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StopGiveAnimationPacket(target.m_20148_().toString()));
                        }
                    } else if (!clicker.m_21205_().m_41619_()) {
                        int xferCount = packet.transferAll ? clicker.m_21205_().m_41613_() : 1;
                        ItemStack itemToGive = clicker.m_21205_().m_41777_();
                        itemToGive.m_41764_(xferCount);
                        if (!HandToHand.canFitItem(target, itemToGive)) {
                            clicker.m_5661_((Component)target.m_5446_().m_6881_().m_130946_(" has no space for this item!"), true);
                        } else {
                            HandToHand.transferItem(clicker, target, packet.transferAll);
                        }
                    }
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class SetGiveStatePacket {
        private final UUID playerId;
        private final boolean state;

        public SetGiveStatePacket(UUID playerId, boolean state) {
            this.playerId = playerId;
            this.state = state;
        }

        public static SetGiveStatePacket create(UUID playerId, boolean state) {
            return new SetGiveStatePacket(playerId, state);
        }

        public static void encode(SetGiveStatePacket packet, FriendlyByteBuf buf) {
            buf.m_130077_(packet.playerId);
            buf.writeBoolean(packet.state);
        }

        public static SetGiveStatePacket decode(FriendlyByteBuf buf) {
            return new SetGiveStatePacket(buf.m_130259_(), buf.readBoolean());
        }

        public static void handle(SetGiveStatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                if (ctx.getDirection().getReceptionSide().isServer()) {
                    ServerPlayer sp = ctx.getSender();
                    if (sp == null) {
                        return;
                    }
                    if (!sp.m_20148_().equals(packet.playerId)) {
                        return;
                    }
                    HandToHand.setGivingState(sp, packet.state);
                    CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
                } else {
                    Minecraft minecraft = Minecraft.m_91087_();
                    if (minecraft.f_91073_ == null) {
                        return;
                    }
                    if (minecraft.f_91074_ != null && minecraft.f_91074_.m_20148_().equals(packet.playerId)) {
                        HandToHandClient.setLocalGiveState(packet.playerId, packet.state);
                    }
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

