/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits;

import ca.landonjw.gooeylibs2.api.tasks.Task;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.pokeskies.skieskits.commands.BaseCommand;
import com.pokeskies.skieskits.config.ConfigManager;
import com.pokeskies.skieskits.config.Kit;
import com.pokeskies.skieskits.config.actions.Action;
import com.pokeskies.skieskits.config.actions.ActionType;
import com.pokeskies.skieskits.config.requirements.ComparisonType;
import com.pokeskies.skieskits.config.requirements.Requirement;
import com.pokeskies.skieskits.config.requirements.RequirementType;
import com.pokeskies.skieskits.economy.EconomyType;
import com.pokeskies.skieskits.economy.IEconomyService;
import com.pokeskies.skieskits.placeholders.PlaceholderManager;
import com.pokeskies.skieskits.storage.IStorage;
import com.pokeskies.skieskits.storage.StorageType;
import com.pokeskies.skieskits.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Engine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ^2\u00020\u0001:\u0001^B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J1\u0010\u000e\u001a\u00028\u0000\"\b\b\u0000\u0010\b*\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0012\u001a\u00020\f\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u00002\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010#\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u0004\u0018\u00010)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00101\u001a\u0002008\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00108\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010?\u001a\u00020>8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR(\u0010G\u001a\b\u0012\u0004\u0012\u00020F0E8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\"\u0010N\u001a\u00020M8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\"\u0010U\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\"\u0010[\u001a\u00020T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010V\u001a\u0004\b\\\u0010X\"\u0004\b]\u0010Z\u00a8\u0006_"}, d2={"Lcom/pokeskies/skieskits/SkiesKits;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "reload", "", "T", "", "filename", "default", "", "create", "loadFile", "(Ljava/lang/String;Ljava/lang/Object;Z)Ljava/lang/Object;", "object", "path", "saveFile", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Z", "Ljava/io/File;", "configDir", "Ljava/io/File;", "getConfigDir", "()Ljava/io/File;", "setConfigDir", "(Ljava/io/File;)V", "Lcom/pokeskies/skieskits/config/ConfigManager;", "configManager", "Lcom/pokeskies/skieskits/config/ConfigManager;", "getConfigManager", "()Lcom/pokeskies/skieskits/config/ConfigManager;", "setConfigManager", "(Lcom/pokeskies/skieskits/config/ConfigManager;)V", "Lcom/pokeskies/skieskits/storage/IStorage;", "storage", "Lcom/pokeskies/skieskits/storage/IStorage;", "getStorage", "()Lcom/pokeskies/skieskits/storage/IStorage;", "setStorage", "(Lcom/pokeskies/skieskits/storage/IStorage;)V", "Lcom/pokeskies/skieskits/economy/IEconomyService;", "economyService", "Lcom/pokeskies/skieskits/economy/IEconomyService;", "getEconomyService", "()Lcom/pokeskies/skieskits/economy/IEconomyService;", "setEconomyService", "(Lcom/pokeskies/skieskits/economy/IEconomyService;)V", "Lcom/pokeskies/skieskits/placeholders/PlaceholderManager;", "placeholderManager", "Lcom/pokeskies/skieskits/placeholders/PlaceholderManager;", "getPlaceholderManager", "()Lcom/pokeskies/skieskits/placeholders/PlaceholderManager;", "setPlaceholderManager", "(Lcom/pokeskies/skieskits/placeholders/PlaceholderManager;)V", "Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "adventure", "Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "getAdventure", "()Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "setAdventure", "(Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "setServer", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_6903;", "Lnet/minecraft/class_2520;", "nbtOpts", "Lnet/minecraft/class_6903;", "getNbtOpts", "()Lnet/minecraft/class_6903;", "setNbtOpts", "(Lnet/minecraft/class_6903;)V", "Lorg/graalvm/polyglot/Engine;", "graalEngine", "Lorg/graalvm/polyglot/Engine;", "getGraalEngine", "()Lorg/graalvm/polyglot/Engine;", "setGraalEngine", "(Lorg/graalvm/polyglot/Engine;)V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "setGson", "(Lcom/google/gson/Gson;)V", "gsonPretty", "getGsonPretty", "setGsonPretty", "Companion", "SkiesKits"})
public final class SkiesKits
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public File configDir;
    public ConfigManager configManager;
    @Nullable
    private IStorage storage;
    @Nullable
    private IEconomyService economyService;
    public PlaceholderManager placeholderManager;
    @Nullable
    private FabricServerAudiences adventure;
    public MinecraftServer server;
    public class_6903<class_2520> nbtOpts;
    public Engine graalEngine;
    @NotNull
    private Gson gson;
    @NotNull
    private Gson gsonPretty;
    public static SkiesKits INSTANCE;
    @NotNull
    private static final Logger LOGGER;

    public SkiesKits() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Action.class), (Object)new ActionType.ActionTypeAdaptor()).registerTypeAdapter((Type)((Object)Requirement.class), (Object)new RequirementType.RequirementTypeAdaptor()).registerTypeAdapter((Type)((Object)ComparisonType.class), (Object)new ComparisonType.ComparisonTypeAdaptor()).registerTypeAdapter((Type)((Object)EconomyType.class), (Object)new EconomyType.EconomyTypeAdaptor()).registerTypeAdapter((Type)((Object)StorageType.class), (Object)new StorageType.StorageTypeAdaptor());
        class_7922 class_79222 = class_7923.field_41178;
        Intrinsics.checkNotNullExpressionValue((Object)class_79222, (String)"ITEM");
        GsonBuilder gsonBuilder2 = gsonBuilder.registerTypeHierarchyAdapter(class_1792.class, new Utils.RegistrySerializer((class_2378)class_79222));
        class_2378 class_23782 = class_7923.field_41172;
        Intrinsics.checkNotNullExpressionValue((Object)class_23782, (String)"SOUND_EVENT");
        GsonBuilder gsonBuilder3 = gsonBuilder2.registerTypeHierarchyAdapter(class_3414.class, new Utils.RegistrySerializer(class_23782));
        Codec codec = class_2487.field_25128;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        Gson gson = gsonBuilder3.registerTypeHierarchyAdapter(class_2487.class, new Utils.CodecSerializer(codec)).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this.gson = gson;
        Gson gson2 = this.gson.newBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
        this.gsonPretty = gson2;
    }

    @NotNull
    public final File getConfigDir() {
        File file = this.configDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configDir");
        return null;
    }

    public final void setConfigDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.configDir = file;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        ConfigManager configManager = this.configManager;
        if (configManager != null) {
            return configManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configManager");
        return null;
    }

    public final void setConfigManager(@NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter((Object)configManager, (String)"<set-?>");
        this.configManager = configManager;
    }

    @Nullable
    public final IStorage getStorage() {
        return this.storage;
    }

    public final void setStorage(@Nullable IStorage iStorage) {
        this.storage = iStorage;
    }

    @Nullable
    public final IEconomyService getEconomyService() {
        return this.economyService;
    }

    public final void setEconomyService(@Nullable IEconomyService iEconomyService) {
        this.economyService = iEconomyService;
    }

    @NotNull
    public final PlaceholderManager getPlaceholderManager() {
        PlaceholderManager placeholderManager = this.placeholderManager;
        if (placeholderManager != null) {
            return placeholderManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"placeholderManager");
        return null;
    }

    public final void setPlaceholderManager(@NotNull PlaceholderManager placeholderManager) {
        Intrinsics.checkNotNullParameter((Object)placeholderManager, (String)"<set-?>");
        this.placeholderManager = placeholderManager;
    }

    @Nullable
    public final FabricServerAudiences getAdventure() {
        return this.adventure;
    }

    public final void setAdventure(@Nullable FabricServerAudiences fabricServerAudiences) {
        this.adventure = fabricServerAudiences;
    }

    @NotNull
    public final MinecraftServer getServer() {
        MinecraftServer minecraftServer = this.server;
        if (minecraftServer != null) {
            return minecraftServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        return null;
    }

    public final void setServer(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<set-?>");
        this.server = minecraftServer;
    }

    @NotNull
    public final class_6903<class_2520> getNbtOpts() {
        class_6903<class_2520> class_69032 = this.nbtOpts;
        if (class_69032 != null) {
            return class_69032;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nbtOpts");
        return null;
    }

    public final void setNbtOpts(@NotNull class_6903<class_2520> class_69032) {
        Intrinsics.checkNotNullParameter(class_69032, (String)"<set-?>");
        this.nbtOpts = class_69032;
    }

    @NotNull
    public final Engine getGraalEngine() {
        Engine engine = this.graalEngine;
        if (engine != null) {
            return engine;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"graalEngine");
        return null;
    }

    public final void setGraalEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"<set-?>");
        this.graalEngine = engine;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    public final void setGson(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"<set-?>");
        this.gson = gson;
    }

    @NotNull
    public final Gson getGsonPretty() {
        return this.gsonPretty;
    }

    public final void setGsonPretty(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"<set-?>");
        this.gsonPretty = gson;
    }

    public void onInitialize() {
        Companion.setINSTANCE(this);
        this.setConfigDir(new File(FabricLoader.getInstance().getConfigDirectory(), "skieskits"));
        this.setConfigManager(new ConfigManager(this.getConfigDir()));
        try {
            this.storage = IStorage.Companion.load(this.getConfigManager().getConfig().getStorage());
        }
        catch (IOException e) {
            Utils.INSTANCE.printError(e.getMessage());
            this.storage = null;
        }
        this.economyService = IEconomyService.Companion.getEconomyService(this.getConfigManager().getConfig().getEconomy());
        this.setPlaceholderManager(new PlaceholderManager());
        this.setGraalEngine(Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build());
        ServerLifecycleEvents.SERVER_STARTING.register(arg_0 -> SkiesKits.onInitialize$lambda$0(this, arg_0));
        ServerLifecycleEvents.SERVER_STARTED.register(arg_0 -> SkiesKits.onInitialize$lambda$1(this, arg_0));
        ServerLifecycleEvents.SERVER_STOPPED.register(arg_0 -> SkiesKits.onInitialize$lambda$2(this, arg_0));
        CommandRegistrationCallback.EVENT.register(SkiesKits::onInitialize$lambda$3);
        ServerPlayConnectionEvents.JOIN.register(SkiesKits::onInitialize$lambda$5);
    }

    public final void reload() {
        IStorage iStorage = this.storage;
        if (iStorage != null) {
            iStorage.close();
        }
        this.getConfigManager().reload();
        try {
            this.storage = IStorage.Companion.load(this.getConfigManager().getConfig().getStorage());
        }
        catch (IOException e) {
            Utils.INSTANCE.printError(e.getMessage());
            this.storage = null;
        }
        this.economyService = IEconomyService.Companion.getEconomyService(this.getConfigManager().getConfig().getEconomy());
        this.getConfigManager().loadKits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T loadFile(@NotNull String filename, @NotNull T t, boolean create) {
        Object value;
        block13: {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter(t, (String)"default");
            File file = new File(this.getConfigDir(), filename);
            value = null;
            value = t;
            try {
                Files.createDirectories(this.getConfigDir().toPath(), new FileAttribute[0]);
                if (file.exists()) {
                    Closeable closeable = new FileReader(file, Charsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        FileReader reader = (FileReader)closeable;
                        boolean bl = false;
                        JsonReader jsonReader = new JsonReader((Reader)reader);
                        value = this.gsonPretty.fromJson(jsonReader, (Type)t.getClass());
                        reader = Unit.INSTANCE;
                        break block13;
                    }
                    catch (Throwable reader) {
                        throwable = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (!create) break block13;
                Files.createFile(file.toPath(), new FileAttribute[0]);
                Closeable closeable = new FileWriter(file);
                Throwable throwable = null;
                try {
                    FileWriter fileWriter = (FileWriter)closeable;
                    boolean bl = false;
                    fileWriter.write(this.gsonPretty.toJson(t));
                    fileWriter.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)value;
    }

    public static /* synthetic */ Object loadFile$default(SkiesKits skiesKits, String string, Object object, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return skiesKits.loadFile(string, object, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean saveFile(@NotNull String filename, T object, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Object object2 = path;
        File file = new File(object2 == null || object2.length() == 0 ? this.getConfigDir() : new File(this.getConfigDir(), path), filename);
        try {
            object2 = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)object2;
                boolean bl = false;
                fileWriter.write(this.gsonPretty.toJson(object));
                fileWriter.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean saveFile$default(SkiesKits skiesKits, String string, Object object, String string2, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return skiesKits.saveFile(string, object, string2);
    }

    private static final void onInitialize$lambda$0(SkiesKits this$0, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this$0.adventure = FabricServerAudiences.of((MinecraftServer)server);
        this$0.setServer(server);
        this$0.setNbtOpts((class_6903<class_2520>)server.method_30611().method_57093((DynamicOps)class_2509.field_11560));
    }

    private static final void onInitialize$lambda$1(SkiesKits this$0, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this$0.getConfigManager().loadKits();
    }

    private static final void onInitialize$lambda$2(SkiesKits this$0, MinecraftServer server) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            this$0.adventure = null;
            IStorage iStorage = this$0.storage;
            if (iStorage == null) break block0;
            iStorage.close();
        }
    }

    private static final void onInitialize$lambda$3(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        BaseCommand baseCommand = new BaseCommand();
        Intrinsics.checkNotNull((Object)dispatcher);
        baseCommand.register((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final void onInitialize$lambda$5$lambda$4(class_3244 $event, Task ctx) {
        class_3222 player = $event.field_14140;
        Utils.printDebug$default(Utils.INSTANCE, "Player " + player.method_5477().getString() + " joined the server! Checking " + ConfigManager.Companion.getKITS().size() + " kits...", false, 2, null);
        if (!player.method_14239()) {
            for (Map.Entry entry : ((Map)ConfigManager.Companion.getKITS()).entrySet()) {
                String id = (String)entry.getKey();
                Kit kit = (Kit)entry.getValue();
                boolean bl = kit.getOnJoin();
                Intrinsics.checkNotNull((Object)player);
                Utils.printDebug$default(Utils.INSTANCE, "Checking kit " + id + "! Kit onJoin=" + bl + ", Player hasPermission=" + kit.hasPermission(player), false, 2, null);
                if (!kit.getOnJoin() || !kit.hasPermission(player)) continue;
                Intrinsics.checkNotNull((Object)id);
                Kit.claim$default(kit, id, player, false, false, 12, null);
            }
        }
    }

    private static final void onInitialize$lambda$5(class_3244 event, PacketSender packetSender, MinecraftServer minecraftServer) {
        Task.builder().execute(arg_0 -> SkiesKits.onInitialize$lambda$5$lambda$4(event, arg_0)).delay(20L).build();
    }

    static {
        Logger logger = LogManager.getLogger((String)"skieskits");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/pokeskies/skieskits/SkiesKits$Companion;", "", "<init>", "()V", "Lcom/pokeskies/skieskits/SkiesKits;", "INSTANCE", "Lcom/pokeskies/skieskits/SkiesKits;", "getINSTANCE", "()Lcom/pokeskies/skieskits/SkiesKits;", "setINSTANCE", "(Lcom/pokeskies/skieskits/SkiesKits;)V", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "SkiesKits"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SkiesKits getINSTANCE() {
            SkiesKits skiesKits = INSTANCE;
            if (skiesKits != null) {
                return skiesKits;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"INSTANCE");
            return null;
        }

        public final void setINSTANCE(@NotNull SkiesKits skiesKits) {
            Intrinsics.checkNotNullParameter((Object)skiesKits, (String)"<set-?>");
            INSTANCE = skiesKits;
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

