/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.Kit;
import com.pokeskies.skieskits.config.KitMenuConfig;
import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/pokeskies/skieskits/config/ConfigManager;", "", "Ljava/io/File;", "configDir", "<init>", "(Ljava/io/File;)V", "", "reload", "()V", "copyDefaults", "loadKits", "Ljava/io/File;", "Lcom/pokeskies/skieskits/config/MainConfig;", "config", "Lcom/pokeskies/skieskits/config/MainConfig;", "getConfig", "()Lcom/pokeskies/skieskits/config/MainConfig;", "setConfig", "(Lcom/pokeskies/skieskits/config/MainConfig;)V", "Lcom/pokeskies/skieskits/config/KitMenuConfig;", "menuConfig", "Lcom/pokeskies/skieskits/config/KitMenuConfig;", "getMenuConfig", "()Lcom/pokeskies/skieskits/config/KitMenuConfig;", "setMenuConfig", "(Lcom/pokeskies/skieskits/config/KitMenuConfig;)V", "Companion", "SkiesKits"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File configDir;
    public MainConfig config;
    public KitMenuConfig menuConfig;
    @NotNull
    private static BiMap<String, Kit> KITS;

    public ConfigManager(@NotNull File configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        this.configDir = configDir;
        this.reload();
    }

    @NotNull
    public final MainConfig getConfig() {
        MainConfig mainConfig = this.config;
        if (mainConfig != null) {
            return mainConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull MainConfig mainConfig) {
        Intrinsics.checkNotNullParameter((Object)mainConfig, (String)"<set-?>");
        this.config = mainConfig;
    }

    @NotNull
    public final KitMenuConfig getMenuConfig() {
        KitMenuConfig kitMenuConfig = this.menuConfig;
        if (kitMenuConfig != null) {
            return kitMenuConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"menuConfig");
        return null;
    }

    public final void setMenuConfig(@NotNull KitMenuConfig kitMenuConfig) {
        Intrinsics.checkNotNullParameter((Object)kitMenuConfig, (String)"<set-?>");
        this.menuConfig = kitMenuConfig;
    }

    public final void reload() {
        this.copyDefaults();
        this.setConfig((MainConfig)SkiesKits.loadFile$default(SkiesKits.Companion.getINSTANCE(), "config.json", new MainConfig(false, null, null, null, null, 31, null), false, 4, null));
        this.setMenuConfig((KitMenuConfig)SkiesKits.loadFile$default(SkiesKits.Companion.getINSTANCE(), "menu.json", new KitMenuConfig(null, 0, null, null, 15, null), false, 4, null));
    }

    public final void copyDefaults() {
        File kitsDir;
        File menuFile;
        ClassLoader classLoader = SkiesKits.class.getClassLoader();
        this.configDir.mkdirs();
        File configFile = FilesKt.resolve((File)this.configDir, (String)"config.json");
        if (!configFile.exists()) {
            try {
                InputStream inputStream = classLoader.getResourceAsStream("assets/skieskits/config.json");
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResourceAsStream(...)");
                InputStream inputStream2 = inputStream;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(inputStream2, configFile.toPath(), copyOptionArray);
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default config file: " + e + " - " + e.getMessage());
            }
        }
        if (!(menuFile = FilesKt.resolve((File)this.configDir, (String)"menu.json")).exists()) {
            try {
                InputStream inputStream = classLoader.getResourceAsStream("assets/skieskits/menu.json");
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResourceAsStream(...)");
                InputStream inputStream3 = inputStream;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(inputStream3, menuFile.toPath(), copyOptionArray);
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default menu file: " + e + " - " + e.getMessage());
            }
        }
        if (!(kitsDir = FilesKt.resolve((File)this.configDir, (String)"kits")).exists()) {
            kitsDir.mkdirs();
            File file = FilesKt.resolve((File)kitsDir, (String)"example_kit.json");
            try {
                Path path = Path.of(classLoader.getResource("assets/skieskits/kits/example_kit.json").toURI());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                Path resourceFile = path;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Path path2 = Files.copy(resourceFile, file.toPath(), copyOptionArray);
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default kit file: " + e.getMessage());
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void loadKits() {
        KITS.clear();
        File dir = FilesKt.resolve((File)this.configDir, (String)"kits");
        if (dir.exists() && dir.isDirectory()) {
            Object[] files = dir.listFiles();
            if (files != null) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    String fileName = file.getName();
                    if (file.isFile()) {
                        Intrinsics.checkNotNull((Object)fileName);
                        if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".json", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNullExpressionValue((Object)fileName.substring(0, StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".json", (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
                            try {
                                String id;
                                ((Map)KITS).put(id, SkiesKits.Companion.getINSTANCE().getGsonPretty().fromJson(JsonParser.parseReader((JsonReader)jsonReader), Kit.class));
                                Utils.INSTANCE.printInfo("Successfully read and loaded the file " + fileName + "!");
                            }
                            catch (Exception ex) {
                                Utils.INSTANCE.printError("Error while trying to parse the file " + fileName + " as a Kit!");
                                ex.printStackTrace();
                            }
                            continue;
                        }
                    }
                    Utils.INSTANCE.printError("File " + fileName + " is either not a file or is not a .json file!");
                }
            }
        } else {
            Utils.INSTANCE.printError("The 'kits' directory either does not exist or is not a directory!");
        }
    }

    static {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        KITS = (BiMap)hashBiMap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R.\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/pokeskies/skieskits/config/ConfigManager$Companion;", "", "<init>", "()V", "Lcom/google/common/collect/BiMap;", "", "Lcom/pokeskies/skieskits/config/Kit;", "KITS", "Lcom/google/common/collect/BiMap;", "getKITS", "()Lcom/google/common/collect/BiMap;", "setKITS", "(Lcom/google/common/collect/BiMap;)V", "SkiesKits"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BiMap<String, Kit> getKITS() {
            return KITS;
        }

        public final void setKITS(@NotNull BiMap<String, Kit> biMap) {
            Intrinsics.checkNotNullParameter(biMap, (String)"<set-?>");
            KITS = biMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

