/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.config;

import com.google.gson.annotations.SerializedName;
import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.KitItem;
import com.pokeskies.skieskits.config.actions.ActionOptions;
import com.pokeskies.skieskits.config.requirements.Requirement;
import com.pokeskies.skieskits.config.requirements.RequirementOptions;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.data.UserData;
import com.pokeskies.skieskits.storage.IStorage;
import com.pokeskies.skieskits.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001f\u0018\u00002\u00020\u0001Bk\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b\u001e\u0010#R\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010#R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010)\u001a\u0004\b*\u0010+R\u001a\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\u000b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010,\u001a\u0004\b/\u0010.R\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u00100\u001a\u0004\b1\u00102R\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u00103\u001a\u0004\b4\u00105R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u00106\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lcom/pokeskies/skieskits/config/Kit;", "", "", "displayName", "permission", "", "cooldown", "", "maxUses", "", "onJoin", "notifications", "", "Lcom/pokeskies/skieskits/config/KitItem;", "items", "Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "requirements", "Lcom/pokeskies/skieskits/config/actions/ActionOptions;", "actions", "<init>", "(Ljava/lang/String;Ljava/lang/String;JIZZLjava/util/List;Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;Lcom/pokeskies/skieskits/config/actions/ActionOptions;)V", "kitId", "Lnet/minecraft/class_3222;", "player", "bypassChecks", "bypassRequirements", "", "claim", "(Ljava/lang/String;Lnet/minecraft/class_3222;ZZ)V", "id", "getDisplayName", "(Ljava/lang/String;)Ljava/lang/String;", "hasPermission", "(Lnet/minecraft/class_3222;)Z", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getPermission", "J", "getCooldown", "()J", "I", "getMaxUses", "()I", "Z", "getOnJoin", "()Z", "getNotifications", "Ljava/util/List;", "getItems", "()Ljava/util/List;", "Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "getRequirements", "()Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "Lcom/pokeskies/skieskits/config/actions/ActionOptions;", "getActions", "()Lcom/pokeskies/skieskits/config/actions/ActionOptions;", "SkiesKits"})
public final class Kit {
    @SerializedName(value="display_name")
    @Nullable
    private final String displayName;
    @Nullable
    private final String permission;
    private final long cooldown;
    @SerializedName(value="max_uses")
    private final int maxUses;
    @SerializedName(value="on_join")
    private final boolean onJoin;
    private final boolean notifications;
    @NotNull
    private final List<KitItem> items;
    @NotNull
    private final RequirementOptions requirements;
    @NotNull
    private final ActionOptions actions;

    public Kit(@Nullable String displayName, @Nullable String permission, long cooldown, int maxUses, boolean onJoin, boolean notifications, @NotNull List<KitItem> items, @NotNull RequirementOptions requirements, @NotNull ActionOptions actions) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.displayName = displayName;
        this.permission = permission;
        this.cooldown = cooldown;
        this.maxUses = maxUses;
        this.onJoin = onJoin;
        this.notifications = notifications;
        this.items = items;
        this.requirements = requirements;
        this.actions = actions;
    }

    public /* synthetic */ Kit(String string, String string2, long l, int n, boolean bl, boolean bl2, List list, RequirementOptions requirementOptions, ActionOptions actionOptions, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            l = -1L;
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80) != 0) {
            requirementOptions = new RequirementOptions(null, null, null, 7, null);
        }
        if ((n2 & 0x100) != 0) {
            actionOptions = new ActionOptions(null, null, null, null, null, 31, null);
        }
        this(string, string2, l, n, bl, bl2, list, requirementOptions, actionOptions);
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public final String getPermission() {
        return this.permission;
    }

    public final long getCooldown() {
        return this.cooldown;
    }

    public final int getMaxUses() {
        return this.maxUses;
    }

    public final boolean getOnJoin() {
        return this.onJoin;
    }

    public final boolean getNotifications() {
        return this.notifications;
    }

    @NotNull
    public final List<KitItem> getItems() {
        return this.items;
    }

    @NotNull
    public final RequirementOptions getRequirements() {
        return this.requirements;
    }

    @NotNull
    public final ActionOptions getActions() {
        return this.actions;
    }

    public final void claim(@NotNull String kitId, @NotNull class_3222 player, boolean bypassChecks, boolean bypassRequirements) {
        KitData kitData;
        UserData userdata;
        Intrinsics.checkNotNullParameter((Object)kitId, (String)"kitId");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Utils.printDebug$default(Utils.INSTANCE, "Attempting to claim kit " + kitId + " for player " + player.method_5477().getString() + "! BypassChecks=" + bypassChecks + ", BypassRequirements=" + bypassRequirements, false, 2, null);
        if (SkiesKits.Companion.getINSTANCE().getStorage() == null) {
            player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText("<red>There was an error with the storage system! Please check the console..."));
            Utils.INSTANCE.printError("Storage system is null! Cannot claim kit " + kitId + " for player " + player.method_5477().getString() + "!");
            return;
        }
        IStorage iStorage = SkiesKits.Companion.getINSTANCE().getStorage();
        if (iStorage != null) {
            UUID uUID = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v2 = iStorage.getUser(uUID);
        } else {
            v2 = userdata = null;
        }
        if (userdata == null) {
            player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText("<red>There was an error with the storage system! Please check the console..."));
            Utils.INSTANCE.printError("Returned player data is null! Cannot claim kit " + kitId + " for player " + player.method_5477().getString() + "!");
            return;
        }
        if (userdata.getKits().containsKey(kitId)) {
            KitData kitData2 = userdata.getKits().get(kitId);
            Intrinsics.checkNotNull((Object)kitData2);
            v4 = kitData2;
        } else {
            v4 = kitData = new KitData(0, 0L, 3, null);
        }
        if (!bypassChecks) {
            if (!kitData.checkUsage(this.maxUses)) {
                Utils.printDebug$default(Utils.INSTANCE, "Player " + player.method_5477().getString() + " has reached the maximum uses for kit " + kitId + "! Kit uses=" + kitData.getUses() + " and maxUses=" + this.maxUses, false, 2, null);
                this.actions.executeUsesActions(player, kitId, this, kitData);
                if (this.notifications) {
                    player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)SkiesKits.Companion.getINSTANCE().getConfigManager().getConfig().getMessages().getKitFailedUses(), (String)"%kit_name%", (String)this.getDisplayName(kitId), (boolean)false, (int)4, null), (String)"%kit_uses%", (String)String.valueOf(kitData.getUses()), (boolean)false, (int)4, null), (String)"%kit_max_uses%", (String)String.valueOf(this.maxUses), (boolean)false, (int)4, null)));
                }
                return;
            }
            if (!kitData.checkCooldown(this.cooldown)) {
                Utils.printDebug$default(Utils.INSTANCE, "Player " + player.method_5477().getString() + " is still on cooldown for kit " + kitId + "! Kit cooldown=" + kitData.getTimeRemaining(this.cooldown), false, 2, null);
                this.actions.executeCooldownActions(player, kitId, this, kitData);
                if (this.notifications) {
                    player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText(StringsKt.replace$default((String)StringsKt.replace$default((String)SkiesKits.Companion.getINSTANCE().getConfigManager().getConfig().getMessages().getKitFailedCooldown(), (String)"%kit_name%", (String)this.getDisplayName(kitId), (boolean)false, (int)4, null), (String)"%kit_cooldown%", (String)Utils.INSTANCE.getFormattedTime(kitData.getTimeRemaining(this.cooldown)), (boolean)false, (int)4, null)));
                }
                return;
            }
        }
        if (!bypassRequirements) {
            boolean success = true;
            for (Map.Entry<String, Requirement> entry : this.requirements.getRequirements().entrySet()) {
                String id = entry.getKey();
                Requirement requirement = entry.getValue();
                if (requirement.passesRequirements(player, kitId, this, kitData)) {
                    requirement.executeSuccessActions(player, kitId, this, kitData);
                    continue;
                }
                success = false;
                requirement.executeDenyActions(player, kitId, this, kitData);
            }
            if (!success) {
                Utils.printDebug$default(Utils.INSTANCE, "Player " + player.method_5477().getString() + " failed the requirements for kit " + kitId + "!", false, 2, null);
                this.requirements.executeDenyActions(player, kitId, this, kitData);
                this.actions.executeRequirementsActions(player, kitId, this, kitData);
                if (this.notifications) {
                    player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText(StringsKt.replace$default((String)SkiesKits.Companion.getINSTANCE().getConfigManager().getConfig().getMessages().getKitFailedRequirements(), (String)"%kit_name%", (String)this.getDisplayName(kitId), (boolean)false, (int)4, null)));
                }
                return;
            }
            this.requirements.executeSuccessActions(player, kitId, this, kitData);
        }
        kitData.setUses(kitData.getUses() + 1);
        kitData.setLastUse(System.currentTimeMillis());
        userdata.getKits().put(kitId, kitData);
        IStorage iStorage2 = SkiesKits.Companion.getINSTANCE().getStorage();
        Intrinsics.checkNotNull((Object)iStorage2);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if (!iStorage2.saveUser(uUID, userdata)) {
            player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText("<red>There was an error with the storage system! Please check the console..."));
            Utils.INSTANCE.printError("Failed to save player data for " + player.method_5477().getString() + " while claiming kit " + kitId + "!");
            return;
        }
        for (KitItem item : this.items) {
            item.giveItem(player, kitId, this, kitData);
        }
        Utils.printDebug$default(Utils.INSTANCE, "Player " + player.method_5477().getString() + " successfully claimed kit " + kitId + "!", false, 2, null);
        this.actions.executeClaimedActions(player, kitId, this, kitData);
        if (this.notifications) {
            player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText(StringsKt.replace$default((String)SkiesKits.Companion.getINSTANCE().getConfigManager().getConfig().getMessages().getKitReceived(), (String)"%kit_name%", (String)this.getDisplayName(kitId), (boolean)false, (int)4, null)));
        }
    }

    public static /* synthetic */ void claim$default(Kit kit, String string, class_3222 class_32222, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        kit.claim(string, class_32222, bl, bl2);
    }

    @NotNull
    public final String getDisplayName(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CharSequence charSequence = this.displayName;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? id : this.displayName;
    }

    public final boolean hasPermission(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CharSequence charSequence = this.permission;
        return !(charSequence == null || charSequence.length() == 0) ? Permissions.check((class_1297)((class_1297)player), (String)this.permission, (int)2) : true;
    }

    @NotNull
    public String toString() {
        return "Kit(cooldown=" + this.cooldown + ", max_uses=" + this.maxUses + ", on_join=" + this.onJoin + ", display_name=" + this.displayName + ", permission=" + this.permission + ", items=" + this.items + ", requirements=" + this.requirements + ", actions=" + this.actions + ")";
    }

    public Kit() {
        this(null, null, 0L, 0, false, false, null, null, null, 511, null);
    }
}

