/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.config.actions;

import ca.landonjw.gooeylibs2.api.tasks.Task;
import com.pokeskies.skieskits.config.Kit;
import com.pokeskies.skieskits.config.actions.ActionType;
import com.pokeskies.skieskits.config.requirements.Requirement;
import com.pokeskies.skieskits.config.requirements.RequirementOptions;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.utils.Utils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0017\u0010\u0016J-\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001b\u0010\u0016J-\u0010\u001c\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001c\u0010\u0016J\u000f\u0010\u001d\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/pokeskies/skieskits/config/actions/Action;", "", "Lcom/pokeskies/skieskits/config/actions/ActionType;", "type", "", "delay", "", "chance", "Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "requirements", "<init>", "(Lcom/pokeskies/skieskits/config/actions/ActionType;JDLcom/pokeskies/skieskits/config/requirements/RequirementOptions;)V", "Lnet/minecraft/class_3222;", "player", "", "kitId", "Lcom/pokeskies/skieskits/config/Kit;", "kit", "Lcom/pokeskies/skieskits/data/KitData;", "kitData", "", "attemptExecution", "(Lnet/minecraft/class_3222;Ljava/lang/String;Lcom/pokeskies/skieskits/config/Kit;Lcom/pokeskies/skieskits/data/KitData;)V", "executeAction", "", "checkRequirements", "(Lnet/minecraft/class_3222;Ljava/lang/String;Lcom/pokeskies/skieskits/config/Kit;Lcom/pokeskies/skieskits/data/KitData;)Z", "executeDenyActions", "executeSuccessActions", "toString", "()Ljava/lang/String;", "Lcom/pokeskies/skieskits/config/actions/ActionType;", "getType", "()Lcom/pokeskies/skieskits/config/actions/ActionType;", "J", "getDelay", "()J", "D", "getChance", "()D", "Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "getRequirements", "()Lcom/pokeskies/skieskits/config/requirements/RequirementOptions;", "SkiesKits"})
public abstract class Action {
    @NotNull
    private final ActionType type;
    private final long delay;
    private final double chance;
    @Nullable
    private final RequirementOptions requirements;

    public Action(@NotNull ActionType type2, long delay, double chance, @Nullable RequirementOptions requirements) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.type = type2;
        this.delay = delay;
        this.chance = chance;
        this.requirements = requirements;
    }

    public /* synthetic */ Action(ActionType actionType, long l, double d, RequirementOptions requirementOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            requirementOptions = new RequirementOptions(null, null, null, 7, null);
        }
        this(actionType, l, d, requirementOptions);
    }

    @NotNull
    public final ActionType getType() {
        return this.type;
    }

    public final long getDelay() {
        return this.delay;
    }

    public final double getChance() {
        return this.chance;
    }

    @Nullable
    public final RequirementOptions getRequirements() {
        return this.requirements;
    }

    public void attemptExecution(@NotNull class_3222 player, @NotNull String kitId, @NotNull Kit kit, @NotNull KitData kitData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)kitId, (String)"kitId");
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)kitData, (String)"kitData");
        if (this.chance > 0.0 && this.chance < 1.0) {
            float roll;
            Utils.printDebug$default(Utils.INSTANCE, "Attempting chance roll for " + this.type + " Action. Result is: " + roll + " <= " + this.chance + " = " + ((double)(roll = Random.Default.nextFloat()) <= this.chance) + ".", false, 2, null);
            if ((double)roll > this.chance) {
                Utils.printDebug$default(Utils.INSTANCE, "Failed chance roll for " + this.type + " Action.", false, 2, null);
                return;
            }
        }
        if (this.delay <= 0L) {
            this.executeAction(player, kitId, kit, kitData);
            return;
        }
        Utils.printDebug$default(Utils.INSTANCE, "Delay found for " + this.type + " Action. Waiting " + this.delay + " ticks before execution.", false, 2, null);
        Task.builder().execute(arg_0 -> Action.attemptExecution$lambda$0(this, player, kitId, kit, kitData, arg_0)).delay(this.delay).build();
    }

    public abstract void executeAction(@NotNull class_3222 var1, @NotNull String var2, @NotNull Kit var3, @NotNull KitData var4);

    public final boolean checkRequirements(@NotNull class_3222 player, @NotNull String kitId, @NotNull Kit kit, @NotNull KitData kitData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)kitId, (String)"kitId");
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)kitData, (String)"kitData");
        if (this.requirements != null) {
            for (Map.Entry<String, Requirement> requirement : this.requirements.getRequirements().entrySet()) {
                if (requirement.getValue().passesRequirements(player, kitId, kit, kitData)) continue;
                return false;
            }
        }
        return true;
    }

    public final void executeDenyActions(@NotNull class_3222 player, @NotNull String kitId, @NotNull Kit kit, @NotNull KitData kitData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)kitId, (String)"kitId");
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)kitData, (String)"kitData");
        if (this.requirements != null) {
            for (Map.Entry<String, Action> entry : this.requirements.getDenyActions().entrySet()) {
                String id = entry.getKey();
                Action action = entry.getValue();
                action.attemptExecution(player, kitId, kit, kitData);
            }
        }
    }

    public final void executeSuccessActions(@NotNull class_3222 player, @NotNull String kitId, @NotNull Kit kit, @NotNull KitData kitData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)kitId, (String)"kitId");
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)kitData, (String)"kitData");
        if (this.requirements != null) {
            for (Map.Entry<String, Action> entry : this.requirements.getSuccessActions().entrySet()) {
                String id = entry.getKey();
                Action action = entry.getValue();
                action.attemptExecution(player, kitId, kit, kitData);
            }
        }
    }

    @NotNull
    public String toString() {
        return "Action(type=" + this.type + ", requirements=" + this.requirements + ")";
    }

    private static final void attemptExecution$lambda$0(Action this$0, class_3222 $player, String $kitId, Kit $kit, KitData $kitData, Task task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$kitId, (String)"$kitId");
        Intrinsics.checkNotNullParameter((Object)$kit, (String)"$kit");
        Intrinsics.checkNotNullParameter((Object)$kitData, (String)"$kitData");
        this$0.executeAction($player, $kitId, $kit, $kitData);
    }
}

