/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.economy.services;

import com.pokeskies.skieskits.economy.IEconomyService;
import com.pokeskies.skieskits.economy.services.ImpactorEconomyService;
import com.pokeskies.skieskits.utils.Utils;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.kyori.adventure.key.Key;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ'\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000eJ%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/pokeskies/skieskits/economy/services/ImpactorEconomyService;", "Lcom/pokeskies/skieskits/economy/IEconomyService;", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "currency", "", "balance", "(Lnet/minecraft/class_3222;Ljava/lang/String;)D", "amount", "", "withdraw", "(Lnet/minecraft/class_3222;DLjava/lang/String;)Z", "deposit", "set", "Ljava/util/UUID;", "uuid", "Lnet/impactdev/impactor/api/economy/currency/Currency;", "Ljava/util/concurrent/CompletableFuture;", "Lnet/impactdev/impactor/api/economy/accounts/Account;", "getAccount", "(Ljava/util/UUID;Lnet/impactdev/impactor/api/economy/currency/Currency;)Ljava/util/concurrent/CompletableFuture;", "id", "getCurrency", "(Ljava/lang/String;)Lnet/impactdev/impactor/api/economy/currency/Currency;", "SkiesKits"})
public final class ImpactorEconomyService
implements IEconomyService {
    public ImpactorEconomyService() {
        Utils.INSTANCE.printInfo("Impactor Economy Service has been found and loaded for any Currency actions/requirements!");
    }

    @Override
    public double balance(@NotNull class_3222 player, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return ((BigDecimal)((CompletableFuture)this.getAccount(uUID, this.getCurrency(currency)).thenCompose(arg_0 -> ImpactorEconomyService.balance$lambda$0(balance.1.INSTANCE, arg_0))).join()).doubleValue();
    }

    @Override
    public boolean withdraw(@NotNull class_3222 player, double amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return ((EconomyTransaction)this.getAccount(uUID, this.getCurrency(currency)).join().withdrawAsync(new BigDecimal(amount)).join()).successful();
    }

    @Override
    public boolean deposit(@NotNull class_3222 player, double amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return ((EconomyTransaction)this.getAccount(uUID, this.getCurrency(currency)).join().depositAsync(new BigDecimal(amount)).join()).successful();
    }

    @Override
    public boolean set(@NotNull class_3222 player, double amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return ((EconomyTransaction)this.getAccount(uUID, this.getCurrency(currency)).join().setAsync(new BigDecimal(amount)).join()).successful();
    }

    private final CompletableFuture<Account> getAccount(UUID uuid, Currency currency) {
        CompletableFuture completableFuture = EconomyService.instance().account(currency, uuid);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"account(...)");
        return completableFuture;
    }

    private final Currency getCurrency(String id) {
        if (((CharSequence)id).length() == 0) {
            Currency currency = EconomyService.instance().currencies().primary();
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"primary(...)");
            return currency;
        }
        Optional optional = EconomyService.instance().currencies().currency(Key.key((String)id));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"currency(...)");
        Optional currency = optional;
        if (currency.isEmpty()) {
            Utils.INSTANCE.printError("Could not find a currency by the ID " + id + "! Valid currencies: " + EconomyService.instance().currencies());
            Currency currency2 = EconomyService.instance().currencies().primary();
            Intrinsics.checkNotNullExpressionValue((Object)currency2, (String)"primary(...)");
            return currency2;
        }
        Object t = currency.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Currency)t;
    }

    private static final CompletionStage balance$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }
}

