/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.gui;

import ca.landonjw.gooeylibs2.api.UIManager;
import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.button.ButtonAction;
import ca.landonjw.gooeylibs2.api.button.GooeyButton;
import ca.landonjw.gooeylibs2.api.data.UpdateEmitter;
import ca.landonjw.gooeylibs2.api.page.Page;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.ConfigManager;
import com.pokeskies.skieskits.config.Kit;
import com.pokeskies.skieskits.config.KitMenuConfig;
import com.pokeskies.skieskits.config.KitMenuOptions;
import com.pokeskies.skieskits.config.MenuItem;
import com.pokeskies.skieskits.config.requirements.Requirement;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.data.UserData;
import com.pokeskies.skieskits.utils.Utils;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/pokeskies/skieskits/gui/KitsMenu;", "Lca/landonjw/gooeylibs2/api/data/UpdateEmitter;", "Lca/landonjw/gooeylibs2/api/page/Page;", "Lnet/minecraft/class_3222;", "player", "<init>", "(Lnet/minecraft/class_3222;)V", "", "refresh", "()V", "Lca/landonjw/gooeylibs2/api/template/Template;", "getTemplate", "()Lca/landonjw/gooeylibs2/api/template/Template;", "Lnet/minecraft/class_2561;", "getTitle", "()Lnet/minecraft/class_2561;", "Lnet/minecraft/class_3222;", "Lcom/pokeskies/skieskits/config/KitMenuConfig;", "config", "Lcom/pokeskies/skieskits/config/KitMenuConfig;", "Lca/landonjw/gooeylibs2/api/template/types/ChestTemplate;", "template", "Lca/landonjw/gooeylibs2/api/template/types/ChestTemplate;", "SkiesKits"})
public final class KitsMenu
extends UpdateEmitter<Page>
implements Page {
    @NotNull
    private final class_3222 player;
    @NotNull
    private final KitMenuConfig config;
    @NotNull
    private final ChestTemplate template;

    public KitsMenu(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.config = SkiesKits.Companion.getINSTANCE().getConfigManager().getMenuConfig();
        ChestTemplate chestTemplate = new ChestTemplate.Builder(this.config.getSize()).build();
        Intrinsics.checkNotNullExpressionValue((Object)chestTemplate, (String)"build(...)");
        this.template = chestTemplate;
        this.refresh();
    }

    private final void refresh() {
        for (Map.Entry<String, MenuItem> entry : this.config.getItems().entrySet()) {
            String id = entry.getKey();
            MenuItem item = entry.getValue();
            GooeyButton.Builder button = item.createButton(this.player, null, null, null);
            Iterator<Integer> iterator = item.getSlots().iterator();
            while (iterator.hasNext()) {
                int slot = ((Number)iterator.next()).intValue();
                this.template.set(slot, (Button)button.build());
            }
        }
        for (Map.Entry<String, Object> entry : this.config.getKits().entrySet()) {
            Iterator<Object> iterator;
            KitData kitData;
            Object object;
            Kit kit;
            KitMenuOptions options;
            String kitId;
            block21: {
                block20: {
                    kitId = entry.getKey();
                    options = (KitMenuOptions)entry.getValue();
                    kit = (Kit)ConfigManager.Companion.getKITS().get((Object)kitId);
                    if (kit == null) {
                        Utils.INSTANCE.printError("Menu references a kit named " + kitId + " but the kit was not found!");
                        continue;
                    }
                    object = SkiesKits.Companion.getINSTANCE().getStorage();
                    if (object == null) break block20;
                    UUID uUID = this.player.method_5667();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    if ((object = object.getUser(uUID)) != null) break block21;
                }
                return;
            }
            Object userdata = object;
            if (((UserData)userdata).getKits().containsKey(kitId)) {
                KitData kitData2 = ((UserData)userdata).getKits().get(kitId);
                Intrinsics.checkNotNull((Object)kitData2);
                v3 = kitData2;
            } else {
                v3 = kitData = new KitData(0, 0L, 3, null);
            }
            if (!kit.hasPermission(this.player)) {
                Iterator<Integer> iterator4 = options.getSlots().iterator();
                while (iterator4.hasNext()) {
                    int slot = ((Number)iterator4.next()).intValue();
                    this.template.set(slot, (Button)options.getNoPermission().createButton(this.player, kitId, kit, kitData).build());
                }
                continue;
            }
            if (!kitData.checkUsage(kit.getMaxUses())) {
                Iterator<Integer> iterator2 = options.getSlots().iterator();
                while (iterator2.hasNext()) {
                    int slot = ((Number)iterator2.next()).intValue();
                    this.template.set(slot, (Button)options.getMaxUses().createButton(this.player, kitId, kit, kitData).build());
                }
                continue;
            }
            if (!kitData.checkCooldown(kit.getCooldown())) {
                Iterator<Integer> iterator3 = options.getSlots().iterator();
                while (iterator3.hasNext()) {
                    int slot = ((Number)iterator3.next()).intValue();
                    this.template.set(slot, (Button)options.getOnCooldown().createButton(this.player, kitId, kit, kitData).build());
                }
                continue;
            }
            boolean passed = true;
            for (Map.Entry<String, Requirement> entry2 : kit.getRequirements().getRequirements().entrySet()) {
                String id = entry2.getKey();
                Requirement requirement = entry2.getValue();
                if (requirement.passesRequirements(this.player, kitId, kit, kitData)) continue;
                passed = false;
            }
            if (!passed) {
                iterator = options.getSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = ((Number)iterator.next()).intValue();
                    this.template.set(slot, (Button)options.getFailedRequirements().createButton(this.player, kitId, kit, kitData).build());
                }
                continue;
            }
            iterator = options.getSlots().iterator();
            while (iterator.hasNext()) {
                int slot = ((Number)iterator.next()).intValue();
                this.template.set(slot, (Button)options.getAvailable().createButton(this.player, kitId, kit, kitData).onClick(arg_0 -> KitsMenu.refresh$lambda$0(kit, this, kitId, arg_0)).build());
            }
        }
    }

    @NotNull
    public Template getTemplate() {
        return (Template)this.template;
    }

    @NotNull
    public class_2561 getTitle() {
        return Utils.INSTANCE.deserializeText(Utils.INSTANCE.parsePlaceholders(this.player, this.config.getTitle(), null, null, null));
    }

    private static final void refresh$lambda$0(Kit $kit, KitsMenu this$0, String $kitId, ButtonAction ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$kitId, (String)"$kitId");
        if (!$kit.hasPermission(this$0.player)) {
            this$0.player.sendMessage((ComponentLike)Utils.INSTANCE.deserializeText(StringsKt.replace$default((String)SkiesKits.Companion.getINSTANCE().getConfigManager().getConfig().getMessages().getKitNoPermission(), (String)"%kit_name%", (String)$kitId, (boolean)false, (int)4, null)));
            return;
        }
        Kit.claim$default($kit, $kitId, this$0.player, false, false, 12, null);
        UIManager.closeUI((class_3222)this$0.player);
    }
}

