/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.placeholders;

import com.pokeskies.skieskits.config.Kit;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.placeholders.IPlaceholderService;
import com.pokeskies.skieskits.placeholders.PlaceholderMod;
import com.pokeskies.skieskits.placeholders.services.DefaultPlaceholderService;
import com.pokeskies.skieskits.placeholders.services.ImpactorPlaceholderService;
import com.pokeskies.skieskits.placeholders.services.MiniPlaceholdersService;
import com.pokeskies.skieskits.placeholders.services.PlaceholderAPIService;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/pokeskies/skieskits/placeholders/PlaceholderManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "text", "kitId", "Lcom/pokeskies/skieskits/config/Kit;", "kit", "Lcom/pokeskies/skieskits/data/KitData;", "kitData", "parse", "(Lnet/minecraft/class_3222;Ljava/lang/String;Ljava/lang/String;Lcom/pokeskies/skieskits/config/Kit;Lcom/pokeskies/skieskits/data/KitData;)Ljava/lang/String;", "Lcom/pokeskies/skieskits/placeholders/PlaceholderMod;", "placeholderMod", "Lcom/pokeskies/skieskits/placeholders/IPlaceholderService;", "getServiceForType", "(Lcom/pokeskies/skieskits/placeholders/PlaceholderMod;)Lcom/pokeskies/skieskits/placeholders/IPlaceholderService;", "", "services", "Ljava/util/List;", "SkiesKits"})
public final class PlaceholderManager {
    @NotNull
    private final List<IPlaceholderService> services = new ArrayList();

    public PlaceholderManager() {
        this.services.add(new DefaultPlaceholderService());
        for (PlaceholderMod service : PlaceholderMod.values()) {
            if (!service.isModPresent()) continue;
            this.services.add(this.getServiceForType(service));
        }
    }

    @NotNull
    public final String parse(@NotNull class_3222 player, @NotNull String text, @Nullable String kitId, @Nullable Kit kit, @Nullable KitData kitData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String returnValue = text;
        for (IPlaceholderService service : this.services) {
            returnValue = service.parsePlaceholders(player, returnValue, kitId, kit, kitData);
        }
        return returnValue;
    }

    private final IPlaceholderService getServiceForType(PlaceholderMod placeholderMod) {
        return switch (WhenMappings.$EnumSwitchMapping$0[placeholderMod.ordinal()]) {
            case 1 -> new ImpactorPlaceholderService();
            case 2 -> new PlaceholderAPIService();
            case 3 -> new MiniPlaceholdersService();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlaceholderMod.values().length];
            try {
                nArray[PlaceholderMod.IMPACTOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderMod.PLACEHOLDERAPI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderMod.MINIPLACEHOLDERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

