/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.storage.database;

import com.google.gson.reflect.TypeToken;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.SocketSettings;
import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.data.UserData;
import com.pokeskies.skieskits.storage.IStorage;
import com.pokeskies.skieskits.utils.UUIDCodec;
import com.pokeskies.skieskits.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/pokeskies/skieskits/storage/database/MongoStorage;", "Lcom/pokeskies/skieskits/storage/IStorage;", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "config", "<init>", "(Lcom/pokeskies/skieskits/config/MainConfig$Storage;)V", "Ljava/util/UUID;", "uuid", "Lcom/pokeskies/skieskits/data/UserData;", "getUser", "(Ljava/util/UUID;)Lcom/pokeskies/skieskits/data/UserData;", "userData", "", "saveUser", "(Ljava/util/UUID;Lcom/pokeskies/skieskits/data/UserData;)Z", "", "close", "()V", "Lcom/mongodb/client/MongoClient;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "Lcom/mongodb/client/MongoDatabase;", "mongoDatabase", "Lcom/mongodb/client/MongoDatabase;", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "userdataCollection", "Lcom/mongodb/client/MongoCollection;", "SkiesKits"})
public final class MongoStorage
implements IStorage {
    @Nullable
    private MongoClient mongoClient;
    @Nullable
    private MongoDatabase mongoDatabase;
    @Nullable
    private MongoCollection<Document> userdataCollection;

    public MongoStorage(@NotNull MainConfig.Storage config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        try {
            String string = config.getUsername();
            char[] cArray = config.getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            MongoCredential credential = MongoCredential.createCredential((String)string, (String)"admin", (char[])cArray);
            MongoClientSettings.Builder settings = MongoClientSettings.builder().applyToSocketSettings(MongoStorage::_init_$lambda$0).applyToClusterSettings(MongoStorage::_init_$lambda$1).uuidRepresentation(UuidRepresentation.STANDARD);
            settings = ((CharSequence)config.getUrlOverride()).length() > 0 ? settings.applyConnectionString(new ConnectionString(config.getUrlOverride())) : settings.credential(credential).applyToClusterSettings(arg_0 -> MongoStorage._init_$lambda$2(config, arg_0));
            this.mongoClient = MongoClients.create((MongoClientSettings)settings.build());
            CodecRegistry[] codecRegistryArray = new CodecRegistry[3];
            codecRegistryArray[0] = MongoClientSettings.getDefaultCodecRegistry();
            Codec[] codecArray = new Codec[]{new UUIDCodec()};
            codecRegistryArray[1] = CodecRegistries.fromCodecs((Codec[])codecArray);
            codecArray = new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()};
            codecRegistryArray[2] = CodecRegistries.fromProviders((CodecProvider[])codecArray);
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])codecRegistryArray);
            MongoClient mongoClient = this.mongoClient;
            Intrinsics.checkNotNull((Object)mongoClient);
            MongoDatabase mongoDatabase = this.mongoDatabase = mongoClient.getDatabase(config.getDatabase()).withCodecRegistry(codecRegistry);
            Intrinsics.checkNotNull((Object)mongoDatabase);
            this.userdataCollection = mongoDatabase.getCollection("userdata");
        }
        catch (Exception e) {
            throw new IOException("Error while attempting to setup Mongo Database: " + e);
        }
    }

    @Override
    @NotNull
    public UserData getUser(@NotNull UUID uuid) {
        UserData userData;
        Document doc;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (this.mongoDatabase == null) {
            Utils.INSTANCE.printError("There was an error while attempting to fetch data from the Mongo database!");
            return new UserData(null, 1, null);
        }
        FindIterable findIterable = this.userdataCollection;
        Document document = findIterable != null && (findIterable = findIterable.find(Filters.eq((String)"uuid", (Object)uuid.toString()))) != null ? (Document)findIterable.first() : (doc = null);
        if (doc != null) {
            Type type2 = new TypeToken<HashMap<String, KitData>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
            Type mapType2 = type2;
            Object object = SkiesKits.Companion.getINSTANCE().getGson().fromJson(doc.getString((Object)"kits"), mapType2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            userData = new UserData((Map)object);
        } else {
            userData = new UserData(null, 1, null);
        }
        return userData;
    }

    @Override
    public boolean saveUser(@NotNull UUID uuid, @NotNull UserData userData) {
        UpdateResult result;
        Document doc;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)userData, (String)"userData");
        if (this.mongoDatabase == null) {
            Utils.INSTANCE.printError("There was an error while attempting to save data to the Mongo database!");
            return false;
        }
        Bson query = Filters.eq((String)"uuid", (Object)uuid.toString());
        FindIterable findIterable = this.userdataCollection;
        Document document = findIterable != null && (findIterable = findIterable.find(query)) != null ? (Document)findIterable.first() : (doc = null);
        if (doc == null) {
            doc = new Document();
        }
        ((Map)doc).put("uuid", uuid.toString());
        ((Map)doc).put("kits", SkiesKits.Companion.getINSTANCE().getGson().toJson(userData.getKits()));
        MongoCollection<Document> mongoCollection = this.userdataCollection;
        UpdateResult updateResult = result = mongoCollection != null ? mongoCollection.replaceOne(query, (Object)doc, new ReplaceOptions().upsert(true)) : null;
        return updateResult != null ? updateResult.wasAcknowledged() : false;
    }

    @Override
    public void close() {
        block0: {
            MongoClient mongoClient = this.mongoClient;
            if (mongoClient == null) break block0;
            mongoClient.close();
        }
    }

    private static final void _init_$lambda$0(SocketSettings.Builder socketSettingsBuilder) {
        socketSettingsBuilder.connectTimeout(60, TimeUnit.SECONDS).readTimeout(120, TimeUnit.SECONDS).build();
    }

    private static final void _init_$lambda$1(ClusterSettings.Builder clusterSettingsBuilder) {
        clusterSettingsBuilder.serverSelectionTimeout(5L, TimeUnit.SECONDS);
    }

    private static final void _init_$lambda$2(MainConfig.Storage $config, ClusterSettings.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.hosts(CollectionsKt.listOf((Object)new ServerAddress($config.getHost(), $config.getPort())));
    }
}

