/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.storage.database.sql;

import com.google.gson.reflect.TypeToken;
import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.data.KitData;
import com.pokeskies.skieskits.data.UserData;
import com.pokeskies.skieskits.storage.IStorage;
import com.pokeskies.skieskits.storage.StorageType;
import com.pokeskies.skieskits.storage.database.sql.ConnectionProvider;
import com.pokeskies.skieskits.storage.database.sql.providers.MySQLProvider;
import com.pokeskies.skieskits.storage.database.sql.providers.SQLiteProvider;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/pokeskies/skieskits/storage/database/sql/SQLStorage;", "Lcom/pokeskies/skieskits/storage/IStorage;", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "config", "<init>", "(Lcom/pokeskies/skieskits/config/MainConfig$Storage;)V", "Ljava/util/UUID;", "uuid", "Lcom/pokeskies/skieskits/data/UserData;", "getUser", "(Ljava/util/UUID;)Lcom/pokeskies/skieskits/data/UserData;", "userData", "", "saveUser", "(Ljava/util/UUID;Lcom/pokeskies/skieskits/data/UserData;)Z", "", "close", "()V", "Lcom/pokeskies/skieskits/storage/database/sql/ConnectionProvider;", "connectionProvider", "Lcom/pokeskies/skieskits/storage/database/sql/ConnectionProvider;", "Ljava/lang/reflect/Type;", "type", "Ljava/lang/reflect/Type;", "SkiesKits"})
public final class SQLStorage
implements IStorage {
    @NotNull
    private final ConnectionProvider connectionProvider;
    @NotNull
    private final Type type;

    public SQLStorage(@NotNull MainConfig.Storage config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.connectionProvider = switch (WhenMappings.$EnumSwitchMapping$0[config.getType().ordinal()]) {
            case 1 -> new MySQLProvider(config);
            case 2 -> new SQLiteProvider(config);
            default -> throw new IllegalStateException("Invalid storage type!");
        };
        Type type2 = new TypeToken<Map<String, KitData>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        this.type = type2;
        this.connectionProvider.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UserData getUser(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Object kits = null;
        kits = new LinkedHashMap();
        try {
            AutoCloseable autoCloseable = this.connectionProvider.createConnection();
            Throwable throwable = null;
            try {
                Connection it = (Connection)autoCloseable;
                boolean bl = false;
                Statement statement = it.createStatement();
                String string = "SELECT * FROM userdata WHERE uuid='%s'";
                Object[] objectArray = new Object[]{uuid.toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                ResultSet result = statement.executeQuery(string2);
                if (result != null && result.next()) {
                    kits = SkiesKits.Companion.getINSTANCE().getGson().fromJson(result.getString("kits"), this.type);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new UserData((Map<String, KitData>)kits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUser(@NotNull UUID uuid, @NotNull UserData userData) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)userData, (String)"userData");
        try {
            AutoCloseable autoCloseable = this.connectionProvider.createConnection();
            Throwable throwable = null;
            try {
                Connection it = (Connection)autoCloseable;
                boolean bl2 = false;
                Statement statement = it.createStatement();
                String string = "REPLACE INTO userdata (uuid, kits) VALUES ('%s', '%s')";
                Object[] objectArray = new Object[]{uuid.toString(), SkiesKits.Companion.getINSTANCE().getGson().toJson(userData.getKits())};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                boolean bl3 = statement.execute(string2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public void close() {
        this.connectionProvider.shutdown();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageType.values().length];
            try {
                nArray[StorageType.MYSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageType.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

