/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.storage.database.sql.providers;

import com.pokeskies.skieskits.SkiesKits;
import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.storage.database.sql.providers.HikariCPProvider;
import com.zaxxer.hikari.HikariConfig;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/pokeskies/skieskits/storage/database/sql/providers/H2Provider;", "Lcom/pokeskies/skieskits/storage/database/sql/providers/HikariCPProvider;", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "config", "<init>", "(Lcom/pokeskies/skieskits/config/MainConfig$Storage;)V", "", "getConnectionURL", "()Ljava/lang/String;", "getDriverClassName", "getDriverName", "Lcom/zaxxer/hikari/HikariConfig;", "", "configure", "(Lcom/zaxxer/hikari/HikariConfig;)V", "SkiesKits"})
public final class H2Provider
extends HikariCPProvider {
    public H2Provider(@NotNull MainConfig.Storage config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
    }

    @Override
    @NotNull
    public String getConnectionURL() {
        String string = "jdbc:h2:%s;AUTO_SERVER=TRUE";
        Object[] objectArray = new Object[]{new File(SkiesKits.Companion.getINSTANCE().getConfigDir(), "storage.db").toPath().toAbsolutePath()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "org.h2.Driver";
    }

    @Override
    @NotNull
    public String getDriverName() {
        return "h2";
    }

    @Override
    public void configure(@NotNull HikariConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }
}

