/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.storage.database.sql.providers;

import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.storage.database.sql.ConnectionProvider;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH&\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H&\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H&\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0011H&\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/pokeskies/skieskits/storage/database/sql/providers/HikariCPProvider;", "Lcom/pokeskies/skieskits/storage/database/sql/ConnectionProvider;", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "storageConfig", "<init>", "(Lcom/pokeskies/skieskits/config/MainConfig$Storage;)V", "", "init", "()V", "shutdown", "Ljava/sql/Connection;", "createConnection", "()Ljava/sql/Connection;", "Lcom/zaxxer/hikari/HikariConfig;", "config", "configure", "(Lcom/zaxxer/hikari/HikariConfig;)V", "", "getConnectionURL", "()Ljava/lang/String;", "getDriverClassName", "getDriverName", "getName", "", "isInitialized", "()Z", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "Lcom/zaxxer/hikari/HikariDataSource;", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "SkiesKits"})
@SourceDebugExtension(value={"SMAP\nHikariCPProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HikariCPProvider.kt\ncom/pokeskies/skieskits/storage/database/sql/providers/HikariCPProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n216#2,2:79\n*S KotlinDebug\n*F\n+ 1 HikariCPProvider.kt\ncom/pokeskies/skieskits/storage/database/sql/providers/HikariCPProvider\n*L\n23#1:79,2\n*E\n"})
public abstract class HikariCPProvider
implements ConnectionProvider {
    @NotNull
    private final MainConfig.Storage storageConfig;
    private HikariDataSource dataSource;

    public HikariCPProvider(@NotNull MainConfig.Storage storageConfig) {
        Intrinsics.checkNotNullParameter((Object)storageConfig, (String)"storageConfig");
        this.storageConfig = storageConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws SQLException {
        HikariConfig config = new HikariConfig();
        this.configure(config);
        config.setUsername(this.storageConfig.getUsername());
        config.setPassword(this.storageConfig.getPassword());
        config.setJdbcUrl(this.getConnectionURL());
        config.setDriverClassName(this.getDriverClassName());
        config.setPoolName("skieskits-" + this.getDriverName());
        Map<String, String> $this$forEach$iv = this.storageConfig.getProperties();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String propertyName = entry.getKey();
            String value = entry.getValue();
            config.addDataSourceProperty(propertyName, (Object)value);
        }
        config.setMaximumPoolSize(this.storageConfig.getPoolSettings().getMaximumPoolSize());
        config.setMinimumIdle(this.storageConfig.getPoolSettings().getMinimumIdle());
        config.setKeepaliveTime(this.storageConfig.getPoolSettings().getKeepaliveTime());
        config.setConnectionTimeout(this.storageConfig.getPoolSettings().getConnectionTimeout());
        config.setIdleTimeout(this.storageConfig.getPoolSettings().getIdleTimeout());
        config.setMaxLifetime(this.storageConfig.getPoolSettings().getMaxLifetime());
        this.dataSource = new HikariDataSource(config);
        try {
            AutoCloseable autoCloseable = this.createConnection();
            Throwable $i$f$forEach2 = null;
            try {
                Connection it = (Connection)autoCloseable;
                boolean bl = false;
                Statement statement = it.createStatement();
                int n = statement.executeUpdate("CREATE TABLE IF NOT EXISTS userdata (uuid VARCHAR(36) NOT NULL, kits TEXT NOT NULL, PRIMARY KEY (uuid))");
            }
            catch (Throwable throwable) {
                $i$f$forEach2 = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)$i$f$forEach2);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() throws SQLException {
        if (this.dataSource != null) {
            HikariDataSource hikariDataSource = this.dataSource;
            if (hikariDataSource == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
                hikariDataSource = null;
            }
            hikariDataSource.close();
        }
    }

    @Override
    @NotNull
    public Connection createConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new SQLException("The data source is not initialized!");
        }
        HikariDataSource hikariDataSource = this.dataSource;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
            hikariDataSource = null;
        }
        Connection connection = hikariDataSource.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    public abstract void configure(@NotNull HikariConfig var1);

    @NotNull
    public abstract String getConnectionURL();

    @NotNull
    public abstract String getDriverClassName();

    @NotNull
    public abstract String getDriverName();

    @Override
    @NotNull
    public String getName() {
        return "hikaricp - " + this.getDriverName();
    }

    @Override
    public boolean isInitialized() {
        if (this.dataSource == null) {
            return false;
        }
        HikariDataSource hikariDataSource = this.dataSource;
        if (hikariDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSource");
            hikariDataSource = null;
        }
        return !hikariDataSource.isClosed();
    }
}

