/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.skieskits.storage.database.sql.providers;

import com.pokeskies.skieskits.config.MainConfig;
import com.pokeskies.skieskits.storage.database.sql.providers.HikariCPProvider;
import com.zaxxer.hikari.HikariConfig;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/pokeskies/skieskits/storage/database/sql/providers/MySQLProvider;", "Lcom/pokeskies/skieskits/storage/database/sql/providers/HikariCPProvider;", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "config", "<init>", "(Lcom/pokeskies/skieskits/config/MainConfig$Storage;)V", "", "getConnectionURL", "()Ljava/lang/String;", "getDriverClassName", "getDriverName", "Lcom/zaxxer/hikari/HikariConfig;", "", "configure", "(Lcom/zaxxer/hikari/HikariConfig;)V", "Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "getConfig", "()Lcom/pokeskies/skieskits/config/MainConfig$Storage;", "SkiesKits"})
public final class MySQLProvider
extends HikariCPProvider {
    @NotNull
    private final MainConfig.Storage config;

    public MySQLProvider(@NotNull MainConfig.Storage config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        this.config = config;
    }

    @NotNull
    public final MainConfig.Storage getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public String getConnectionURL() {
        String string = "jdbc:mysql://%s:%d/%s";
        Object[] objectArray = new Object[]{this.config.getHost(), this.config.getPort(), this.config.getDatabase()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return "com.mysql.cj.jdbc.Driver";
    }

    @Override
    @NotNull
    public String getDriverName() {
        return "mysql";
    }

    @Override
    public void configure(@NotNull HikariConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }
}

